/***************************************************************************
                          qscandialog.h  -  description
                             -------------------
    begin                : Thu Jun 22 2000
    copyright            : (C) 2000 by M. Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#ifndef QScanDialog_H
#define QScanDialog_H

#include <qarray.h>
#include <qlistview.h>
#include <qnamespace.h>
#include <qwidget.h>
#include "qscanner.h"
#include "qextensionwidget.h"
#include "quiteinsanenamespace.h"
/**
  *@author M. Herder
  */
//forward declarations
class ImageHistoryBrowser;
class PreviewWidget;
class QCheckBox;
class QComboBox;
class QDragLabel;
class QFileListWidget;
class QGridLayout;
class QGroupBox;
class QHBox;
class QVBox;
class QHTMLView;
class QLabel;
class QLineEdit;
class QMultiScan;
class QOptionScrollView;
class QReadOnlyOption;
class QRect;
class QSaneOption;
class QScanner;
class QScrollBarOption;
class QTimer;
class QTabWidget;
class QToolButton;
class QVBox;
class QVBoxLayout;
class QWidget;
class SaneWidgetHolder;
class ScanArea;

class QScanDialog : public QWidget
{
   Q_OBJECT
public:
	QScanDialog(QScanner* s,QWidget *parent=0, const char *name=0,WFlags f=0);
  ~QScanDialog();
  /**  */
  QIN::Status status();
protected:
  /**  */
  virtual void resizeEvent(QResizeEvent* e);
  /**  */
  virtual void closeEvent(QCloseEvent* e);
  /**  */
  void showEvent(QShowEvent* se);
private:
  QReadOnlyOption* mpButtonOption;
  QPushButton* mpBrowserButton;
  QPushButton* mpDeviceButton;
  QPushButton* mpQuitButton;
  QPushButton* mpAboutButton;
  QPushButton* mpScanButton;
  QPushButton* mpOptionsButton;
  QPushButton* mpPreviewButton;
  PreviewWidget *mpPreviewWidget;
  ImageHistoryBrowser* mpHistoryWidget;
  /**  */
  QArray <SaneWidgetHolder *> mOptionWidgets;
  /**  */
  QScanner* mpScanner;
  /**  */
  QScrollBarOption* mpTlxOption;
  /**  */
  QScrollBarOption* mpTlyOption;
  /**  */
  QScrollBarOption* mpBrxOption;
  /**  */
  QScrollBarOption* mpBryOption;
  /**  */
  QToolButton* mpWhatsThisButton;
  /**  */
  QMultiScan* mpMultiScanWidget;
  /**  */
  QPushButton* mpMultiScanButton;
  /**  */
  QTabWidget* mpOptionTabWidget;
  /**  */
  QOptionScrollView* mpOptionScrollView;
  /** */
  QWidget* mpOptionMainWidget;
  /** */
  QArray <QWidget*> mOptionSubArray;
  /**  */
  QGridLayout* mpMainLayout;
  /**  */
  QArray <QGroupBox*> mGroupBoxArray;
  /**  */
  QLabel* mpLabelImageInfo;
  /**  */
  QPushButton* mpViewerButton;
  /**  */
  QPushButton* mpHelpButton;
  QString mDeviceName;
  /**  */
  QHTMLView* mpHelpViewer;
  /**  */
  QIN::Status mStatus;
  /**  */
  QIN::Layout mLayout;
  /** */
  QIN::MetricSystem mMetricSystem;
  /** */
  QComboBox* mpModeCombo;
  /**  */
  int mShowCnt;
  /**  */
  QWidgetStack* mpOptionWidgetStack;
  /**  */
  QDragLabel* mpDragLabel;
  /**  */
  QLineEdit* mpDragLineEdit;
  /**  */
  QComboBox* mpDragTypeCombo;
  /**  */
  QCheckBox* mpAutoNameCheckBox;
  /**  */
  QHBox* mpInfoHBox;
  /**  */
  QHBox* mpModeHBox;
  /**  */
  QHBox* mpButtonHBox1;
  /**  */
  QHBox* mpButtonHBox2;
  /**  */
  QHBox* mpDragHBox1;
  /**  */
  QHBox* mpDragHBox2;
  /**  */
  QWidget* mpOptionListWidget;
  /**  */
  QListView* mpOptionListView;
  /**  */
  QVBox* mpSeparator;
private: //methods
  bool mMultiSelectionMode;
	QIN::Status initDialog();
  /**  */
  void changeLayout(QIN::Layout l);
  /** Do a scan with the current settings. Return false
if an error occurs. Otherwise true is returned and the
image is saved to .scantemp.pnm.*/
  bool scanImage(bool pre = false,bool adf_warning=true,QWidget* parent=0);
  /**  */
  bool scanPreviewImage(double tlx=0.0,double tly=0.0,
                        double brx=1.0,double bry=1.0,int res=50);
  /**  */
  void enableGUI(bool enable,bool preview_scan=false);
  /**  */
  void createOptionWidget();
  /**  */
  void setAllOptions();
  /**  */
  void createWhatsThisHelp();
  /**  */
  QGroupBox* createOptionGroupBox(QString title,int firstoption,int lastoption);
  /**  */
  void createPreviewWidget();
  /** No descriptions */
  void resizeScanArea();
  /** No descriptions */
  void setPreviewRange();
  /** No descriptions */
  void scanInTemporaryMode();
  /** No descriptions */
  void scanInSingleFileMode();
  /** No descriptions */
  void scanInCopyPrintMode();
  /** No descriptions */
  void scanInMultiScanMode();
  /** No descriptions */
  void scanInOcrMode();
  /** No descriptions */
  void scanInSaveMode();
  /** No descriptions */
  QSaneOption* createSaneOptionWidget(QWidget* parent,int opt_num);
  /** No descriptions */
  void checkOptionValidity(int opt_num);
public slots:
  /**  */
  void slotUserSize(int);
  /**  */
  void slotOptionChanged(int num);
  /**  */
  void slotPreviewSize(QRect rect);
  /**  */
  void slotResizeScanRect();
  /**  */
  void slotSetPredefinedSize(ScanArea* sca);
private slots:
  /**  */
  void slotScan();
  /**  */
  void slotPreview(double tlx,double tly,double brx,double bry,int res);
  /**  */
  void slotReloadOptions();
  /**  */
  void slotShowOptionsWidget();
  /**  */
  void slotShowPreviewWidget();
  /**  */
  void slotAbout();
  /**  */
  void slotShowMultiScanWidget();
  /**  */
  void slotImageInfo();
  /** This slot is called, when setting an option results
in an return value SANE_INFO_INEXACT.
This normally happens, when the value set in
the backend  is different from the requested value. */
  void slotInfoInexact(int num);
  /**  */
  void slotViewer();
  /**  */
  void slotChangeMode(int index);
  /**  */
  void slotAutoMode(int num,bool b);
  /**  */
  void slotShowHelp();
  /**  */
  void slotDeviceSettings();
  /**  */
  void slotRaiseOptionWidget(QListViewItem* lvi);
  /**  */
  void slotHidePreview();
  /**  */
  void slotImageSettings();
  /**  */
  void slotChangeFilename();
  /**  */
  void slotDragType(int index);
  /**  */
  void slotAutoName(bool b);
  /**  */
  void slotDragFilename(const QString& qs);
  /**  */
  void slotShowBrowser();
  /**  */
  void slotShowImage(QString filename);
  /**  */
  void slotAddImageToHistory(QString abspath);
  /** No descriptions */
  void slotMultiSelectionMode(bool state);
  /** No descriptions */
  void slotEnableScanAreaOptions(bool on);
  /** No descriptions */
  void slotFilenameGenerationSettings();
signals:
  /** */
  void signalChangeStyle(int s);
  /** */
  void signalQuit();
  /**  */
  void signalNewImage();
  /**  */
  void signalMetricSystem(QIN::MetricSystem ms);
};

#endif

