/***************************************************************************
                          gaussiirblurdialog.h  -  description
                             -------------------
    begin                : Thu Feb 7 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GAUSSIIRBLURDIALOG_H
#define GAUSSIIRBLURDIALOG_H

#include "imagefilterdialog.h"

/**
  *@author Michael Herder
  */

class QCheckBox;
class SliderSpin;

class GaussIIRBlurDialog : public ImageFilterDialog
{
Q_OBJECT
public:
	GaussIIRBlurDialog(int preview_size=150,QImage* image=0,QWidget* parent=0);
	~GaussIIRBlurDialog();
  /** No descriptions */
  bool apply(QImage* image,bool emit_progress=true);
protected:
  /** No descriptions */
  void saveConfig();
private: // Private methods
  /** No descriptions */
  void initControls();
  /** No descriptions */
  SliderSpin* mpSliderSpinH;
  /** No descriptions */
  SliderSpin* mpSliderSpinV;
  /** No descriptions */
  QCheckBox* mpBindCheckBox;
  /** No descriptions */
  void findConstants(double n_p[],double n_m[],double d_p[],
                     double d_m[],double bd_p[],double bd_m[],
                     double std_dev);
  /** No descriptions */
  void separateAlpha(unsigned char* buf,int width,int bytes);
  /** No descriptions */
  void multiplyAlpha(unsigned char* buf,int width,int bytes);
  /** No descriptions */
  void transferPixels(double* src1,double* src2,unsigned char* dest,
		                  int bytes,int width);
  /** No descriptions */
  double mRadiusH;
  /** No descriptions */
  double mRadiusV;
private slots:
  /** No descriptions */
  void slotBindValues(bool state);
  /** No descriptions */
  void slotRadiusHChanged(int value);
  /** No descriptions */
  void slotRadiusVChanged(int value);
};

#endif
