/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * This file was generated by the dom/make_names.pl script.
 *
 * Copyright (C) 2005, 2006, 2007, 2008, 2009 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "MathMLElementFactory.h"
#include "MathMLNames.h"

#if ENABLE(MATHML)

#include "MathMLMathElement.h"
#include "MathMLInlineContainerElement.h"
#include "MathMLTextElement.h"
#include "MathMLElement.h"
#include <wtf/HashMap.h>

#if ENABLE(DASHBOARD_SUPPORT) || ENABLE(VIDEO)
#include "Document.h"
#include "Settings.h"
#endif

namespace WebCore {

using namespace MathMLNames;

typedef PassRefPtr<MathMLElement> (*ConstructorFunction)(const QualifiedName&, Document*, bool createdByParser);
typedef HashMap<AtomicStringImpl*, ConstructorFunction> FunctionMap;

static FunctionMap* gFunctionMap = 0;

static PassRefPtr<MathMLElement> mathConstructor(const QualifiedName& tagName, Document* document, bool)
{
    return MathMLMathElement::create(tagName, document);
}

static PassRefPtr<MathMLElement> inlinecontainerConstructor(const QualifiedName& tagName, Document* document, bool)
{
    return MathMLInlineContainerElement::create(tagName, document);
}

static PassRefPtr<MathMLElement> textConstructor(const QualifiedName& tagName, Document* document, bool)
{
    return MathMLTextElement::create(tagName, document);
}

static void addTag(const QualifiedName& tag, ConstructorFunction func)
{
    gFunctionMap->set(tag.localName().impl(), func);
}

static void createFunctionMap()
{
    ASSERT(!gFunctionMap);

    // Create the table.
    gFunctionMap = new FunctionMap;
    
    // Populate it with constructor functions.
    addTag(mathTag, mathConstructor);
    addTag(mfencedTag, inlinecontainerConstructor);
    addTag(mfracTag, inlinecontainerConstructor);
    addTag(miTag, textConstructor);
    addTag(mnTag, textConstructor);
    addTag(moTag, textConstructor);
    addTag(moverTag, inlinecontainerConstructor);
    addTag(mrootTag, inlinecontainerConstructor);
    addTag(mrowTag, inlinecontainerConstructor);
    addTag(msqrtTag, inlinecontainerConstructor);
    addTag(msubsupTag, inlinecontainerConstructor);
    addTag(mtextTag, textConstructor);
    addTag(munderTag, inlinecontainerConstructor);
    addTag(munderoverTag, inlinecontainerConstructor);
}

PassRefPtr<MathMLElement> MathMLElementFactory::createMathMLElement(const QualifiedName& qName, Document* document, bool createdByParser)
{
    if (!document)
        return 0;

#if ENABLE(DASHBOARD_SUPPORT)
    Settings* settings = document->settings();
    if (settings && settings->usesDashboardBackwardCompatibilityMode())
        return 0;
#endif
    if (!gFunctionMap)
        createFunctionMap();
    if (ConstructorFunction function = gFunctionMap->get(qName.localName().impl()))
        return function(qName, document, createdByParser);
    return MathMLElement::create(qName, document);
}

} // namespace WebCore

#endif
