/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGNumberList.h"

#include "JSSVGNumber.h"
#include "JSSVGPODListCustom.h"
#include "SVGNumberList.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGNumberList);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGNumberListTableValues[3] =
{
    { "numberOfItems", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGNumberListNumberOfItems), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGNumberListConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGNumberListTable = { 4, 3, JSSVGNumberListTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGNumberListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGNumberListConstructorTable = { 1, 0, JSSVGNumberListConstructorTableValues, 0 };
class JSSVGNumberListConstructor : public DOMConstructorObject {
public:
    JSSVGNumberListConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGNumberListConstructor::s_info = { "SVGNumberListConstructor", 0, &JSSVGNumberListConstructorTable, 0 };

JSSVGNumberListConstructor::JSSVGNumberListConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSSVGNumberListConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSSVGNumberListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGNumberListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGNumberListConstructor, DOMObject>(exec, &JSSVGNumberListConstructorTable, this, propertyName, slot);
}

bool JSSVGNumberListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGNumberListConstructor, DOMObject>(exec, &JSSVGNumberListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGNumberListPrototypeTableValues[8] =
{
    { "clear", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionClear), (intptr_t)0 THUNK_GENERATOR(0) },
    { "initialize", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionInitialize), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getItem", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionGetItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { "insertItemBefore", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionInsertItemBefore), (intptr_t)2 THUNK_GENERATOR(0) },
    { "replaceItem", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionReplaceItem), (intptr_t)2 THUNK_GENERATOR(0) },
    { "removeItem", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionRemoveItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { "appendItem", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionAppendItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGNumberListPrototypeTable = { 18, 15, JSSVGNumberListPrototypeTableValues, 0 };
const ClassInfo JSSVGNumberListPrototype::s_info = { "SVGNumberListPrototype", 0, &JSSVGNumberListPrototypeTable, 0 };

JSObject* JSSVGNumberListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGNumberList>(exec, globalObject);
}

bool JSSVGNumberListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGNumberListPrototypeTable, this, propertyName, slot);
}

bool JSSVGNumberListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGNumberListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGNumberList::s_info = { "SVGNumberList", 0, &JSSVGNumberListTable, 0 };

JSSVGNumberList::JSSVGNumberList(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGNumberList> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGNumberList::~JSSVGNumberList()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGNumberList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGNumberListPrototype(globalObject, JSSVGNumberListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGNumberList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGNumberList, Base>(exec, &JSSVGNumberListTable, this, propertyName, slot);
}

bool JSSVGNumberList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGNumberList, Base>(exec, &JSSVGNumberListTable, this, propertyName, descriptor);
}

JSValue jsSVGNumberListNumberOfItems(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGNumberList* castedThis = static_cast<JSSVGNumberList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGNumberList* imp = static_cast<SVGNumberList*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->numberOfItems());
    return result;
}

JSValue jsSVGNumberListConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGNumberList* domObject = static_cast<JSSVGNumberList*>(asObject(slotBase));
    return JSSVGNumberList::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGNumberList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGNumberListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionClear(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSValue::encode(JSSVGPODListCustom::clear<JSSVGNumberList, float>(castedThis, exec, toSVGNumber));
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionInitialize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSValue::encode(JSSVGPODListCustom::initialize<JSSVGNumberList, float>(castedThis, exec, toSVGNumber));
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionGetItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSValue::encode(JSSVGPODListCustom::getItem<JSSVGNumberList, float>(castedThis, exec, toSVGNumber));
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionInsertItemBefore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSValue::encode(JSSVGPODListCustom::insertItemBefore<JSSVGNumberList, float>(castedThis, exec, toSVGNumber));
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionReplaceItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSValue::encode(JSSVGPODListCustom::replaceItem<JSSVGNumberList, float>(castedThis, exec, toSVGNumber));
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionRemoveItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSValue::encode(JSSVGPODListCustom::removeItem<JSSVGNumberList, float>(castedThis, exec, toSVGNumber));
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionAppendItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSValue::encode(JSSVGPODListCustom::appendItem<JSSVGNumberList, float>(castedThis, exec, toSVGNumber));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGNumberList* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGNumberList>(exec, globalObject, object, context);
}
SVGNumberList* toSVGNumberList(JSC::JSValue value)
{
    return value.inherits(&JSSVGNumberList::s_info) ? static_cast<JSSVGNumberList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
