/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIndexedDatabaseRequest.h"

#include "IDBKeyRange.h"
#include "IDBRequest.h"
#include "IndexedDatabaseRequest.h"
#include "JSIDBKeyRange.h"
#include "JSIDBRequest.h"
#include "SerializedScriptValue.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIndexedDatabaseRequest);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIndexedDatabaseRequestTableValues[2] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIndexedDatabaseRequestConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIndexedDatabaseRequestTable = { 2, 1, JSIndexedDatabaseRequestTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIndexedDatabaseRequestConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIndexedDatabaseRequestConstructorTable = { 1, 0, JSIndexedDatabaseRequestConstructorTableValues, 0 };
class JSIndexedDatabaseRequestConstructor : public DOMConstructorObject {
public:
    JSIndexedDatabaseRequestConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIndexedDatabaseRequestConstructor::s_info = { "IndexedDatabaseRequestConstructor", 0, &JSIndexedDatabaseRequestConstructorTable, 0 };

JSIndexedDatabaseRequestConstructor::JSIndexedDatabaseRequestConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSIndexedDatabaseRequestConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSIndexedDatabaseRequestPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIndexedDatabaseRequestConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIndexedDatabaseRequestConstructor, DOMObject>(exec, &JSIndexedDatabaseRequestConstructorTable, this, propertyName, slot);
}

bool JSIndexedDatabaseRequestConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIndexedDatabaseRequestConstructor, DOMObject>(exec, &JSIndexedDatabaseRequestConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIndexedDatabaseRequestPrototypeTableValues[6] =
{
    { "open", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIndexedDatabaseRequestPrototypeFunctionOpen), (intptr_t)2 THUNK_GENERATOR(0) },
    { "makeSingleKeyRange", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIndexedDatabaseRequestPrototypeFunctionMakeSingleKeyRange), (intptr_t)1 THUNK_GENERATOR(0) },
    { "makeLeftBoundKeyRange", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIndexedDatabaseRequestPrototypeFunctionMakeLeftBoundKeyRange), (intptr_t)2 THUNK_GENERATOR(0) },
    { "makeRightBoundKeyRange", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIndexedDatabaseRequestPrototypeFunctionMakeRightBoundKeyRange), (intptr_t)2 THUNK_GENERATOR(0) },
    { "makeBoundKeyRange", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIndexedDatabaseRequestPrototypeFunctionMakeBoundKeyRange), (intptr_t)4 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIndexedDatabaseRequestPrototypeTable = { 18, 15, JSIndexedDatabaseRequestPrototypeTableValues, 0 };
const ClassInfo JSIndexedDatabaseRequestPrototype::s_info = { "IndexedDatabaseRequestPrototype", 0, &JSIndexedDatabaseRequestPrototypeTable, 0 };

JSObject* JSIndexedDatabaseRequestPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIndexedDatabaseRequest>(exec, globalObject);
}

bool JSIndexedDatabaseRequestPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSIndexedDatabaseRequestPrototypeTable, this, propertyName, slot);
}

bool JSIndexedDatabaseRequestPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSIndexedDatabaseRequestPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSIndexedDatabaseRequest::s_info = { "IndexedDatabaseRequest", 0, &JSIndexedDatabaseRequestTable, 0 };

JSIndexedDatabaseRequest::JSIndexedDatabaseRequest(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<IndexedDatabaseRequest> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSIndexedDatabaseRequest::~JSIndexedDatabaseRequest()
{
    forgetDOMObject(this, impl());
}

JSObject* JSIndexedDatabaseRequest::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSIndexedDatabaseRequestPrototype(globalObject, JSIndexedDatabaseRequestPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSIndexedDatabaseRequest::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIndexedDatabaseRequest, Base>(exec, &JSIndexedDatabaseRequestTable, this, propertyName, slot);
}

bool JSIndexedDatabaseRequest::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIndexedDatabaseRequest, Base>(exec, &JSIndexedDatabaseRequestTable, this, propertyName, descriptor);
}

JSValue jsIndexedDatabaseRequestConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIndexedDatabaseRequest* domObject = static_cast<JSIndexedDatabaseRequest*>(asObject(slotBase));
    return JSIndexedDatabaseRequest::getConstructor(exec, domObject->globalObject());
}
JSValue JSIndexedDatabaseRequest::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIndexedDatabaseRequestConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIndexedDatabaseRequestPrototypeFunctionOpen(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIndexedDatabaseRequest::s_info))
        return throwVMTypeError(exec);
    JSIndexedDatabaseRequest* castedThis = static_cast<JSIndexedDatabaseRequest*>(asObject(thisValue));
    IndexedDatabaseRequest* imp = static_cast<IndexedDatabaseRequest*>(castedThis->impl());
    ScriptExecutionContext* scriptContext = static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    const String& name = ustringToString(exec->argument(0).toString(exec));
    const String& description = ustringToString(exec->argument(1).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->open(scriptContext, name, description)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIndexedDatabaseRequestPrototypeFunctionMakeSingleKeyRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIndexedDatabaseRequest::s_info))
        return throwVMTypeError(exec);
    JSIndexedDatabaseRequest* castedThis = static_cast<JSIndexedDatabaseRequest*>(asObject(thisValue));
    IndexedDatabaseRequest* imp = static_cast<IndexedDatabaseRequest*>(castedThis->impl());
    RefPtr<SerializedScriptValue> value = SerializedScriptValue::create(exec, exec->argument(0));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->makeSingleKeyRange(value)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIndexedDatabaseRequestPrototypeFunctionMakeLeftBoundKeyRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIndexedDatabaseRequest::s_info))
        return throwVMTypeError(exec);
    JSIndexedDatabaseRequest* castedThis = static_cast<JSIndexedDatabaseRequest*>(asObject(thisValue));
    IndexedDatabaseRequest* imp = static_cast<IndexedDatabaseRequest*>(castedThis->impl());
    RefPtr<SerializedScriptValue> bound = SerializedScriptValue::create(exec, exec->argument(0));

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->makeLeftBoundKeyRange(bound)));
        return JSValue::encode(result);
    }

    bool open = exec->argument(1).toBoolean(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->makeLeftBoundKeyRange(bound, open)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIndexedDatabaseRequestPrototypeFunctionMakeRightBoundKeyRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIndexedDatabaseRequest::s_info))
        return throwVMTypeError(exec);
    JSIndexedDatabaseRequest* castedThis = static_cast<JSIndexedDatabaseRequest*>(asObject(thisValue));
    IndexedDatabaseRequest* imp = static_cast<IndexedDatabaseRequest*>(castedThis->impl());
    RefPtr<SerializedScriptValue> bound = SerializedScriptValue::create(exec, exec->argument(0));

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->makeRightBoundKeyRange(bound)));
        return JSValue::encode(result);
    }

    bool open = exec->argument(1).toBoolean(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->makeRightBoundKeyRange(bound, open)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIndexedDatabaseRequestPrototypeFunctionMakeBoundKeyRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIndexedDatabaseRequest::s_info))
        return throwVMTypeError(exec);
    JSIndexedDatabaseRequest* castedThis = static_cast<JSIndexedDatabaseRequest*>(asObject(thisValue));
    IndexedDatabaseRequest* imp = static_cast<IndexedDatabaseRequest*>(castedThis->impl());
    RefPtr<SerializedScriptValue> left = SerializedScriptValue::create(exec, exec->argument(0));
    RefPtr<SerializedScriptValue> right = SerializedScriptValue::create(exec, exec->argument(1));

    int argsCount = exec->argumentCount();
    if (argsCount < 3) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->makeBoundKeyRange(left, right)));
        return JSValue::encode(result);
    }

    bool openLeft = exec->argument(2).toBoolean(exec);
    if (argsCount < 4) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->makeBoundKeyRange(left, right, openLeft)));
        return JSValue::encode(result);
    }

    bool openRight = exec->argument(3).toBoolean(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->makeBoundKeyRange(left, right, openLeft, openRight)));
    return JSValue::encode(result);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IndexedDatabaseRequest* object)
{
    return getDOMObjectWrapper<JSIndexedDatabaseRequest>(exec, globalObject, object);
}
IndexedDatabaseRequest* toIndexedDatabaseRequest(JSC::JSValue value)
{
    return value.inherits(&JSIndexedDatabaseRequest::s_info) ? static_cast<JSIndexedDatabaseRequest*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
