/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBKeyRange.h"

#include "IDBAny.h"
#include "IDBKeyRange.h"
#include "JSIDBAny.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIDBKeyRange);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBKeyRangeTableValues[5] =
{
    { "left", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLeft), (intptr_t)0 THUNK_GENERATOR(0) },
    { "right", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeRight), (intptr_t)0 THUNK_GENERATOR(0) },
    { "flags", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeFlags), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBKeyRangeTable = { 8, 7, JSIDBKeyRangeTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBKeyRangeConstructorTableValues[6] =
{
    { "SINGLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeSINGLE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "LEFT_OPEN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLEFT_OPEN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "RIGHT_OPEN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeRIGHT_OPEN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "LEFT_BOUND", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLEFT_BOUND), (intptr_t)0 THUNK_GENERATOR(0) },
    { "RIGHT_BOUND", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeRIGHT_BOUND), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBKeyRangeConstructorTable = { 16, 15, JSIDBKeyRangeConstructorTableValues, 0 };

COMPILE_ASSERT(0 == IDBKeyRange::SINGLE, IDBKeyRangeEnumSINGLEIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == IDBKeyRange::LEFT_OPEN, IDBKeyRangeEnumLEFT_OPENIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == IDBKeyRange::RIGHT_OPEN, IDBKeyRangeEnumRIGHT_OPENIsWrongUseDontCheckEnums);
COMPILE_ASSERT(4 == IDBKeyRange::LEFT_BOUND, IDBKeyRangeEnumLEFT_BOUNDIsWrongUseDontCheckEnums);
COMPILE_ASSERT(8 == IDBKeyRange::RIGHT_BOUND, IDBKeyRangeEnumRIGHT_BOUNDIsWrongUseDontCheckEnums);

class JSIDBKeyRangeConstructor : public DOMConstructorObject {
public:
    JSIDBKeyRangeConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIDBKeyRangeConstructor::s_info = { "IDBKeyRangeConstructor", 0, &JSIDBKeyRangeConstructorTable, 0 };

JSIDBKeyRangeConstructor::JSIDBKeyRangeConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSIDBKeyRangeConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSIDBKeyRangePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIDBKeyRangeConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBKeyRangeConstructor, DOMObject>(exec, &JSIDBKeyRangeConstructorTable, this, propertyName, slot);
}

bool JSIDBKeyRangeConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBKeyRangeConstructor, DOMObject>(exec, &JSIDBKeyRangeConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBKeyRangePrototypeTableValues[6] =
{
    { "SINGLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeSINGLE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "LEFT_OPEN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLEFT_OPEN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "RIGHT_OPEN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeRIGHT_OPEN), (intptr_t)0 THUNK_GENERATOR(0) },
    { "LEFT_BOUND", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLEFT_BOUND), (intptr_t)0 THUNK_GENERATOR(0) },
    { "RIGHT_BOUND", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeRIGHT_BOUND), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBKeyRangePrototypeTable = { 16, 15, JSIDBKeyRangePrototypeTableValues, 0 };
const ClassInfo JSIDBKeyRangePrototype::s_info = { "IDBKeyRangePrototype", 0, &JSIDBKeyRangePrototypeTable, 0 };

JSObject* JSIDBKeyRangePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBKeyRange>(exec, globalObject);
}

bool JSIDBKeyRangePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBKeyRangePrototype, JSObject>(exec, &JSIDBKeyRangePrototypeTable, this, propertyName, slot);
}

bool JSIDBKeyRangePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBKeyRangePrototype, JSObject>(exec, &JSIDBKeyRangePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSIDBKeyRange::s_info = { "IDBKeyRange", 0, &JSIDBKeyRangeTable, 0 };

JSIDBKeyRange::JSIDBKeyRange(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBKeyRange> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSIDBKeyRange::~JSIDBKeyRange()
{
    forgetDOMObject(this, impl());
}

JSObject* JSIDBKeyRange::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSIDBKeyRangePrototype(globalObject, JSIDBKeyRangePrototype::createStructure(globalObject->objectPrototype()));
}

bool JSIDBKeyRange::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBKeyRange, Base>(exec, &JSIDBKeyRangeTable, this, propertyName, slot);
}

bool JSIDBKeyRange::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBKeyRange, Base>(exec, &JSIDBKeyRangeTable, this, propertyName, descriptor);
}

JSValue jsIDBKeyRangeLeft(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBKeyRange* castedThis = static_cast<JSIDBKeyRange*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBKeyRange* imp = static_cast<IDBKeyRange*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->left()));
    return result;
}

JSValue jsIDBKeyRangeRight(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBKeyRange* castedThis = static_cast<JSIDBKeyRange*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBKeyRange* imp = static_cast<IDBKeyRange*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->right()));
    return result;
}

JSValue jsIDBKeyRangeFlags(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBKeyRange* castedThis = static_cast<JSIDBKeyRange*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBKeyRange* imp = static_cast<IDBKeyRange*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->flags());
    return result;
}

JSValue jsIDBKeyRangeConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBKeyRange* domObject = static_cast<JSIDBKeyRange*>(asObject(slotBase));
    return JSIDBKeyRange::getConstructor(exec, domObject->globalObject());
}
JSValue JSIDBKeyRange::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBKeyRangeConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsIDBKeyRangeSINGLE(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsIDBKeyRangeLEFT_OPEN(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsIDBKeyRangeRIGHT_OPEN(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsIDBKeyRangeLEFT_BOUND(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValue jsIDBKeyRangeRIGHT_BOUND(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(8));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBKeyRange* object)
{
    return getDOMObjectWrapper<JSIDBKeyRange>(exec, globalObject, object);
}
IDBKeyRange* toIDBKeyRange(JSC::JSValue value)
{
    return value.inherits(&JSIDBKeyRange::s_info) ? static_cast<JSIDBKeyRange*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
