/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBEvent.h"

#include "IDBAny.h"
#include "IDBEvent.h"
#include "JSIDBAny.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIDBEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBEventTableValues[3] =
{
    { "source", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBEventSource), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBEventTable = { 4, 3, JSIDBEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBEventConstructorTable = { 1, 0, JSIDBEventConstructorTableValues, 0 };
class JSIDBEventConstructor : public DOMConstructorObject {
public:
    JSIDBEventConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIDBEventConstructor::s_info = { "IDBEventConstructor", 0, &JSIDBEventConstructorTable, 0 };

JSIDBEventConstructor::JSIDBEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSIDBEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSIDBEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIDBEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBEventConstructor, DOMObject>(exec, &JSIDBEventConstructorTable, this, propertyName, slot);
}

bool JSIDBEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBEventConstructor, DOMObject>(exec, &JSIDBEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBEventPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBEventPrototypeTable = { 1, 0, JSIDBEventPrototypeTableValues, 0 };
const ClassInfo JSIDBEventPrototype::s_info = { "IDBEventPrototype", 0, &JSIDBEventPrototypeTable, 0 };

JSObject* JSIDBEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBEvent>(exec, globalObject);
}

const ClassInfo JSIDBEvent::s_info = { "IDBEvent", &JSEvent::s_info, &JSIDBEventTable, 0 };

JSIDBEvent::JSIDBEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSIDBEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSIDBEventPrototype(globalObject, JSIDBEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSIDBEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBEvent, Base>(exec, &JSIDBEventTable, this, propertyName, slot);
}

bool JSIDBEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBEvent, Base>(exec, &JSIDBEventTable, this, propertyName, descriptor);
}

JSValue jsIDBEventSource(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBEvent* castedThis = static_cast<JSIDBEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBEvent* imp = static_cast<IDBEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->source()));
    return result;
}

JSValue jsIDBEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBEvent* domObject = static_cast<JSIDBEvent*>(asObject(slotBase));
    return JSIDBEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSIDBEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(INDEXED_DATABASE)
