/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLSourceElement.h"

#include "HTMLNames.h"
#include "HTMLSourceElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLSourceElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLSourceElementTableValues[5] =
{
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementSrc), (intptr_t)setJSHTMLSourceElementSrc THUNK_GENERATOR(0) },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementType), (intptr_t)setJSHTMLSourceElementType THUNK_GENERATOR(0) },
    { "media", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementMedia), (intptr_t)setJSHTMLSourceElementMedia THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLSourceElementTable = { 9, 7, JSHTMLSourceElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLSourceElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLSourceElementConstructorTable = { 1, 0, JSHTMLSourceElementConstructorTableValues, 0 };
class JSHTMLSourceElementConstructor : public DOMConstructorObject {
public:
    JSHTMLSourceElementConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLSourceElementConstructor::s_info = { "HTMLSourceElementConstructor", 0, &JSHTMLSourceElementConstructorTable, 0 };

JSHTMLSourceElementConstructor::JSHTMLSourceElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSHTMLSourceElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSHTMLSourceElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLSourceElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLSourceElementConstructor, DOMObject>(exec, &JSHTMLSourceElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLSourceElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLSourceElementConstructor, DOMObject>(exec, &JSHTMLSourceElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLSourceElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLSourceElementPrototypeTable = { 1, 0, JSHTMLSourceElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLSourceElementPrototype::s_info = { "HTMLSourceElementPrototype", 0, &JSHTMLSourceElementPrototypeTable, 0 };

JSObject* JSHTMLSourceElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLSourceElement>(exec, globalObject);
}

const ClassInfo JSHTMLSourceElement::s_info = { "HTMLSourceElement", &JSHTMLElement::s_info, &JSHTMLSourceElementTable, 0 };

JSHTMLSourceElement::JSHTMLSourceElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLSourceElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLSourceElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLSourceElementPrototype(globalObject, JSHTMLSourceElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLSourceElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLSourceElement, Base>(exec, &JSHTMLSourceElementTable, this, propertyName, slot);
}

bool JSHTMLSourceElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLSourceElement, Base>(exec, &JSHTMLSourceElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLSourceElementSrc(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLSourceElement* castedThis = static_cast<JSHTMLSourceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getNonEmptyURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}

JSValue jsHTMLSourceElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLSourceElement* castedThis = static_cast<JSHTMLSourceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}

JSValue jsHTMLSourceElementMedia(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLSourceElement* castedThis = static_cast<JSHTMLSourceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->media());
    return result;
}

JSValue jsHTMLSourceElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLSourceElement* domObject = static_cast<JSHTMLSourceElement*>(asObject(slotBase));
    return JSHTMLSourceElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLSourceElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLSourceElement, Base>(exec, propertyName, value, &JSHTMLSourceElementTable, this, slot);
}

void setJSHTMLSourceElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLSourceElement* castedThis = static_cast<JSHTMLSourceElement*>(thisObject);
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::srcAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLSourceElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLSourceElement* castedThis = static_cast<JSHTMLSourceElement*>(thisObject);
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(castedThis->impl());
    imp->setType(ustringToString(value.toString(exec)));
}

void setJSHTMLSourceElementMedia(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLSourceElement* castedThis = static_cast<JSHTMLSourceElement*>(thisObject);
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(castedThis->impl());
    imp->setMedia(ustringToString(value.toString(exec)));
}

JSValue JSHTMLSourceElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLSourceElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(VIDEO)
