/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATAGRID)

#include "JSHTMLDataGridCellElement.h"

#include "HTMLDataGridCellElement.h"
#include "KURL.h"
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDataGridCellElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLDataGridCellElementTableValues[7] =
{
    { "label", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataGridCellElementLabel), (intptr_t)setJSHTMLDataGridCellElementLabel THUNK_GENERATOR(0) },
    { "focused", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataGridCellElementFocused), (intptr_t)setJSHTMLDataGridCellElementFocused THUNK_GENERATOR(0) },
    { "checked", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataGridCellElementChecked), (intptr_t)setJSHTMLDataGridCellElementChecked THUNK_GENERATOR(0) },
    { "indeterminate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataGridCellElementIndeterminate), (intptr_t)setJSHTMLDataGridCellElementIndeterminate THUNK_GENERATOR(0) },
    { "progress", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataGridCellElementProgress), (intptr_t)setJSHTMLDataGridCellElementProgress THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataGridCellElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridCellElementTable = { 17, 15, JSHTMLDataGridCellElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLDataGridCellElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridCellElementConstructorTable = { 1, 0, JSHTMLDataGridCellElementConstructorTableValues, 0 };
class JSHTMLDataGridCellElementConstructor : public DOMConstructorObject {
public:
    JSHTMLDataGridCellElementConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLDataGridCellElementConstructor::s_info = { "HTMLDataGridCellElementConstructor", 0, &JSHTMLDataGridCellElementConstructorTable, 0 };

JSHTMLDataGridCellElementConstructor::JSHTMLDataGridCellElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSHTMLDataGridCellElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSHTMLDataGridCellElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLDataGridCellElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataGridCellElementConstructor, DOMObject>(exec, &JSHTMLDataGridCellElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLDataGridCellElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataGridCellElementConstructor, DOMObject>(exec, &JSHTMLDataGridCellElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLDataGridCellElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridCellElementPrototypeTable = { 1, 0, JSHTMLDataGridCellElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLDataGridCellElementPrototype::s_info = { "HTMLDataGridCellElementPrototype", 0, &JSHTMLDataGridCellElementPrototypeTable, 0 };

JSObject* JSHTMLDataGridCellElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDataGridCellElement>(exec, globalObject);
}

const ClassInfo JSHTMLDataGridCellElement::s_info = { "HTMLDataGridCellElement", &JSHTMLElement::s_info, &JSHTMLDataGridCellElementTable, 0 };

JSHTMLDataGridCellElement::JSHTMLDataGridCellElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDataGridCellElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLDataGridCellElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLDataGridCellElementPrototype(globalObject, JSHTMLDataGridCellElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLDataGridCellElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataGridCellElement, Base>(exec, &JSHTMLDataGridCellElementTable, this, propertyName, slot);
}

bool JSHTMLDataGridCellElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataGridCellElement, Base>(exec, &JSHTMLDataGridCellElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLDataGridCellElementLabel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->label());
    return result;
}

JSValue jsHTMLDataGridCellElementFocused(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->focused());
    return result;
}

JSValue jsHTMLDataGridCellElementChecked(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->checked());
    return result;
}

JSValue jsHTMLDataGridCellElementIndeterminate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->indeterminate());
    return result;
}

JSValue jsHTMLDataGridCellElementProgress(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->progress());
    return result;
}

JSValue jsHTMLDataGridCellElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDataGridCellElement* domObject = static_cast<JSHTMLDataGridCellElement*>(asObject(slotBase));
    return JSHTMLDataGridCellElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLDataGridCellElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDataGridCellElement, Base>(exec, propertyName, value, &JSHTMLDataGridCellElementTable, this, slot);
}

void setJSHTMLDataGridCellElementLabel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(thisObject);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    imp->setLabel(ustringToString(value.toString(exec)));
}

void setJSHTMLDataGridCellElementFocused(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(thisObject);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    imp->setFocused(value.toBoolean(exec));
}

void setJSHTMLDataGridCellElementChecked(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(thisObject);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    imp->setChecked(value.toBoolean(exec));
}

void setJSHTMLDataGridCellElementIndeterminate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(thisObject);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    imp->setIndeterminate(value.toBoolean(exec));
}

void setJSHTMLDataGridCellElementProgress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(thisObject);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    imp->setProgress(value.toFloat(exec));
}

JSValue JSHTMLDataGridCellElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDataGridCellElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(DATAGRID)
