/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_READER)

#include "JSFileReader.h"

#include "EventListener.h"
#include "FileError.h"
#include "FileReader.h"
#include "JSBlob.h"
#include "JSEventListener.h"
#include "JSFile.h"
#include "JSFileError.h"
#include "KURL.h"
#include "RegisteredEventListener.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSFileReader);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFileReaderTableValues[11] =
{
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderReadyState), (intptr_t)0 THUNK_GENERATOR(0) },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderResult), (intptr_t)0 THUNK_GENERATOR(0) },
    { "error", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderError), (intptr_t)0 THUNK_GENERATOR(0) },
    { "onloadstart", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnloadstart), (intptr_t)setJSFileReaderOnloadstart THUNK_GENERATOR(0) },
    { "onprogress", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnprogress), (intptr_t)setJSFileReaderOnprogress THUNK_GENERATOR(0) },
    { "onload", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnload), (intptr_t)setJSFileReaderOnload THUNK_GENERATOR(0) },
    { "onabort", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnabort), (intptr_t)setJSFileReaderOnabort THUNK_GENERATOR(0) },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnerror), (intptr_t)setJSFileReaderOnerror THUNK_GENERATOR(0) },
    { "onloadend", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnloadend), (intptr_t)setJSFileReaderOnloadend THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFileReaderTable = { 34, 31, JSFileReaderTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFileReaderConstructorTableValues[4] =
{
    { "EMPTY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderEMPTY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "LOADING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderLOADING), (intptr_t)0 THUNK_GENERATOR(0) },
    { "DONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderDONE), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFileReaderConstructorTable = { 9, 7, JSFileReaderConstructorTableValues, 0 };
class JSFileReaderConstructor : public DOMConstructorObject {
public:
    JSFileReaderConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
    static JSC::EncodedJSValue JSC_HOST_CALL constructJSFileReader(JSC::ExecState*);
    virtual JSC::ConstructType getConstructData(JSC::ConstructData&);
};

const ClassInfo JSFileReaderConstructor::s_info = { "FileReaderConstructor", 0, &JSFileReaderConstructorTable, 0 };

JSFileReaderConstructor::JSFileReaderConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSFileReaderConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSFileReaderPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSFileReaderConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileReaderConstructor, DOMObject>(exec, &JSFileReaderConstructorTable, this, propertyName, slot);
}

bool JSFileReaderConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFileReaderConstructor, DOMObject>(exec, &JSFileReaderConstructorTable, this, propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSFileReaderConstructor::constructJSFileReader(ExecState* exec)
{
    ScriptExecutionContext* context = static_cast<JSFileReaderConstructor*>(exec->callee())->scriptExecutionContext();
    if (!context)
        return throwVMError(exec, createReferenceError(exec, "Reference error"));
    return JSValue::encode(asObject(toJS(exec, static_cast<JSFileReaderConstructor*>(exec->callee())->globalObject(), FileReader::create(context))));
}

ConstructType JSFileReaderConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSFileReader;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFileReaderPrototypeTableValues[8] =
{
    { "EMPTY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderEMPTY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "LOADING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderLOADING), (intptr_t)0 THUNK_GENERATOR(0) },
    { "DONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderDONE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "readAsBinaryString", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionReadAsBinaryString), (intptr_t)1 THUNK_GENERATOR(0) },
    { "readAsText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionReadAsText), (intptr_t)2 THUNK_GENERATOR(0) },
    { "readAsDataURL", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionReadAsDataURL), (intptr_t)1 THUNK_GENERATOR(0) },
    { "abort", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionAbort), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFileReaderPrototypeTable = { 17, 15, JSFileReaderPrototypeTableValues, 0 };
static const HashTable* getJSFileReaderPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileReaderPrototypeTable);
}
const ClassInfo JSFileReaderPrototype::s_info = { "FileReaderPrototype", 0, 0, getJSFileReaderPrototypeTable };

JSObject* JSFileReaderPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileReader>(exec, globalObject);
}

bool JSFileReaderPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSFileReaderPrototype, JSObject>(exec, getJSFileReaderPrototypeTable(exec), this, propertyName, slot);
}

bool JSFileReaderPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSFileReaderPrototype, JSObject>(exec, getJSFileReaderPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSFileReaderTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileReaderTable);
}
const ClassInfo JSFileReader::s_info = { "FileReader", 0, 0, getJSFileReaderTable };

JSFileReader::JSFileReader(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<FileReader> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSFileReader::~JSFileReader()
{
    impl()->invalidateJSEventListeners(this);
    forgetDOMObject(this, impl());
}

void JSFileReader::markChildren(MarkStack& markStack)
{
    Base::markChildren(markStack);
    impl()->markJSEventListeners(markStack);
}

JSObject* JSFileReader::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSFileReaderPrototype(globalObject, JSFileReaderPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSFileReader::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileReader, Base>(exec, getJSFileReaderTable(exec), this, propertyName, slot);
}

bool JSFileReader::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFileReader, Base>(exec, getJSFileReaderTable(exec), this, propertyName, descriptor);
}

JSValue jsFileReaderReadyState(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->readyState());
    return result;
}

JSValue jsFileReaderResult(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    JSValue result = jsOwnedStringOrNull(exec, imp->result());
    return result;
}

JSValue jsFileReaderError(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->error()));
    return result;
}

JSValue jsFileReaderOnloadstart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = imp->onloadstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsFileReaderOnprogress(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = imp->onprogress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsFileReaderOnload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = imp->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsFileReaderOnabort(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = imp->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsFileReaderOnerror(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsFileReaderOnloadend(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = imp->onloadend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsFileReaderConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFileReader* domObject = static_cast<JSFileReader*>(asObject(slotBase));
    return JSFileReader::getConstructor(exec, domObject->globalObject());
}
void JSFileReader::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSFileReader, Base>(exec, propertyName, value, getJSFileReaderTable(exec), this, slot);
}

void setJSFileReaderOnloadstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(static_cast<JSFileReader*>(thisObject)->impl());
    imp->setOnloadstart(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSFileReaderOnprogress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(static_cast<JSFileReader*>(thisObject)->impl());
    imp->setOnprogress(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSFileReaderOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(static_cast<JSFileReader*>(thisObject)->impl());
    imp->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSFileReaderOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(static_cast<JSFileReader*>(thisObject)->impl());
    imp->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSFileReaderOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(static_cast<JSFileReader*>(thisObject)->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSFileReaderOnloadend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    FileReader* imp = static_cast<FileReader*>(static_cast<JSFileReader*>(thisObject)->impl());
    imp->setOnloadend(createJSAttributeEventListener(exec, value, thisObject));
}

JSValue JSFileReader::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileReaderConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionReadAsBinaryString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(thisValue));
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    Blob* fileBlob = toBlob(exec->argument(0));

    imp->readAsBinaryString(fileBlob);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionReadAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(thisValue));
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    Blob* fileBlob = toBlob(exec->argument(0));

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {
        imp->readAsText(fileBlob);
        return JSValue::encode(jsUndefined());
    }

    const String& encoding = ustringToString(exec->argument(1).toString(exec));

    imp->readAsText(fileBlob, encoding);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionReadAsDataURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(thisValue));
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());
    File* file = toFile(exec->argument(0));

    imp->readAsDataURL(file);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionAbort(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = static_cast<JSFileReader*>(asObject(thisValue));
    FileReader* imp = static_cast<FileReader*>(castedThis->impl());

    imp->abort();
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsFileReaderEMPTY(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsFileReaderLOADING(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsFileReaderDONE(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, FileReader* object)
{
    return getDOMObjectWrapper<JSFileReader>(exec, globalObject, object);
}
FileReader* toFileReader(JSC::JSValue value)
{
    return value.inherits(&JSFileReader::s_info) ? static_cast<JSFileReader*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_READER)
