
#include <stdio.h>
#include "filefunc.h"
#include "qfiledialog.h"
#include <stdarg.h>

void  changeExtension(QFileInfo &fdest,const char *ext,bool Always)
{
  QString fn=fdest.baseName();
  QString fe=fdest.extension();
  fn+=".";
  if ((fe.isEmpty()) || (Always))
    {
      fn+=ext;
    }
  else
    {
     fn+=fe;
    }
 fdest.setFile(fdest.dir(TRUE),fn);
}


bool openForRead(QFile &fn,QDir StartWith,const char *ext)
{
  QFileDialog t;
  QString strt=t.getOpenFileName(StartWith.absPath(),ext);
  if (strt==NULL)
    {
      return FALSE;
    }
  fn.setName((const char *)strt);
  return(fn.open(IO_ReadOnly));
}

bool openForWrite(QFile &fn,QDir StartWith,const char *ext)
{
  QFileDialog t;
  QString strt=t.getSaveFileName(StartWith.absPath(),ext);
  fn.setName((const char *)strt);
  return(fn.open(IO_Raw| IO_WriteOnly|IO_Truncate));
}

bool getFileName(QFile &fn,QDir StartWith,const char *ext)
{ 
  QString f =QFileDialog::getSaveFileName(StartWith.absPath(),ext);
  if ( !f.isEmpty() )
    {
      fn.setName(f);
      return TRUE;
    }
  return FALSE;
}




void fileDirBaseName(QFileInfo &fdest,const QString fsrc)
{
  QFileInfo t(fsrc);
  QString fn=t.baseName();
  QDir d=t.dir();
  fdest.setFile(d,fn);
}

void fullFilename(QFileInfo &fdest,const QDir dsrc,const QString fsrc)
{
   fdest.setFile(dsrc,fsrc);
}










