/***************************************************************************
 *   Copyright (C) 2007 by Matvey Kozhev                                   *
 *   sikon@lucidfox.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ICONTHEME_H
#define ICONTHEME_H

#include "envmap.h"
#include <QObject>
#include <QMap>
#include <QVector>

#ifdef QT_GUI_LIB
#include <QPixmap>
#include <QSize>
#endif

struct IconDirData
{
    enum Type
    {
        Fixed = 0,
        Scalable = 1,
        Threshold = 2
    };
    
    QString path;
    unsigned size;
    Type type;
    unsigned maxsize;
    unsigned minsize;
    unsigned threshold;
};

struct IconThemeData
{
    QString name;
    QString dir;
    QStringList parents;
    QVector<IconDirData> subdirs;
};

/**
 @author Sikon <sikon@lucidfox.org>
*/
class IconTheme : public QObject
{
    Q_OBJECT
public:
    enum DefaultTheme
    {
        DefaultThemeAny = 0,
        DefaultThemeGNOME = 1,
        DefaultThemeKDE = 2,
    };

    IconTheme(const QString &themeName = QString());
    ~IconTheme();
    void loadDefaultTheme(DefaultTheme theme = DefaultThemeAny);
    void loadTheme(const QString& theme);

    const QString &themeName() const
    {
        return _themeName;
    }

    QString getIconPath(const QString& name, unsigned size = 22) const;
    void reload();
    
#ifdef QT_GUI_LIB
    QPixmap getPixmap(const QString& name, int size) const;
#endif
    
protected:
    QMap< QString, QString > cache() const
    {
        return _cache;
    }
    
    void addThemeData(const QString& name);
    QString findIcon(const QString& name, unsigned size) const;
    QString lookupIcon(const QString& name, unsigned size, const IconThemeData &data) const;
    bool dirMatchesSize(const IconDirData &dir, unsigned size) const;
    unsigned dirSizeDistance(const IconDirData& dir, unsigned size) const;
    QString lookupFallbackIcon(const QString& name) const;

private:
    QString _themeName;
    QMap<QString, QString> _cache;
    QList<IconThemeData> _list;
    EnvMap _envMap;
    QStringList _basedirs;
};

#endif
