/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.ColorPicker;
import king.GroupEditor;
import king.KingMain;
import king.KingPrefs;
import king.core.KGroup;
import king.core.KList;
import king.core.KPaint;
import king.core.KPoint;
import king.core.Kinemage;
import king.points.BallPoint;
import king.points.VectorPoint;

public class PointEditor
implements ChangeListener {
    KingMain kMain;
    GroupEditor groupEditor;
    JDialog ptDialog;
    JTextField ptID;
    JTextField ptComment;
    JTextField ptAspects;
    JTextField ptMasters;
    JTextField ptWidthRadius;
    JTextField ptX;
    JTextField ptY;
    JTextField ptZ;
    ColorPicker ptPicker;
    JCheckBox ptUnpickable;
    JLabel ptIndex;
    JButton split;
    boolean ptFirstShow = true;
    KPoint thePoint = null;
    KPaint ptOrigColor = null;
    int index = 0;

    public PointEditor(KingMain kingMain) {
        this.kMain = kingMain;
        this.groupEditor = new GroupEditor(this.kMain, this.kMain.getTopWindow());
        this.makePointDialog();
    }

    private void makePointDialog() {
        this.ptDialog = new JDialog(this.kMain.getTopWindow(), "Edit point", true);
        this.ptDialog.setDefaultCloseOperation(2);
        this.ptID = new JTextField(20);
        this.ptComment = new JTextField(20);
        this.ptAspects = new JTextField(8);
        this.ptMasters = new JTextField(8);
        this.ptWidthRadius = new JTextField(8);
        this.ptX = new JTextField(8);
        this.ptY = new JTextField(8);
        this.ptZ = new JTextField(8);
        this.ptUnpickable = new JCheckBox("Unpickable");
        this.ptIndex = new JLabel("Index is x/xxx");
        KingPrefs kingPrefs = this.kMain.getPrefs();
        int n = kingPrefs == null ? 20 : kingPrefs.getInt("colorSwatchSize");
        this.ptPicker = new ColorPicker(0, n);
        this.ptPicker.addChangeListener(this);
        this.split = new JButton(new ReflectiveAction("Split list before this", null, this, "onPointSplit"));
        JButton jButton = new JButton(new ReflectiveAction("OK", null, this, "onPointOK"));
        JButton jButton2 = new JButton(new ReflectiveAction("Cancel", null, this, "onPointCancel"));
        JButton jButton3 = new JButton(new ReflectiveAction("Edit group", null, this, "onEditGroup"));
        JButton jButton4 = new JButton(new ReflectiveAction("Edit subgroup", null, this, "onEditSubgroup"));
        JButton jButton5 = new JButton(new ReflectiveAction("Edit list", null, this, "onEditList"));
        TablePane tablePane = new TablePane();
        tablePane.hfill(true);
        tablePane.startSubtable();
        tablePane.add(new JLabel("Point ID"));
        tablePane.add((Component)this.ptID, 3, 1);
        tablePane.newRow();
        tablePane.add(new JLabel("Comment"));
        tablePane.add((Component)this.ptComment, 3, 1);
        tablePane.newRow();
        tablePane.skip();
        tablePane.add(this.ptUnpickable);
        tablePane.add((Component)this.ptPicker, 1, 10);
        tablePane.newRow();
        tablePane.add(new JLabel("Aspects"));
        tablePane.add(this.ptAspects);
        tablePane.newRow();
        tablePane.add(new JLabel("Pointmasters"));
        tablePane.add(this.ptMasters);
        tablePane.newRow();
        tablePane.add(new JLabel("Width/Radius"));
        tablePane.add(this.ptWidthRadius);
        tablePane.newRow();
        tablePane.skip();
        tablePane.add(new JLabel("0 => from list"));
        tablePane.newRow();
        tablePane.add(new JLabel("X coord"));
        tablePane.add(this.ptX);
        tablePane.newRow();
        tablePane.add(new JLabel("Y coord"));
        tablePane.add(this.ptY);
        tablePane.newRow();
        tablePane.add(new JLabel("Z coord"));
        tablePane.add(this.ptZ);
        tablePane.newRow();
        tablePane.add(this.ptIndex);
        tablePane.center().add(this.split);
        tablePane.newRow();
        tablePane.add(Box.createVerticalGlue(), 2, 1);
        tablePane.endSubtable();
        tablePane.newRow();
        tablePane.skip();
        tablePane.newRow();
        tablePane.startSubtable();
        tablePane.center();
        tablePane.add(jButton5);
        tablePane.add(jButton4);
        tablePane.add(jButton3);
        tablePane.endSubtable();
        tablePane.newRow();
        tablePane.add(TablePane.strut(0, 4));
        tablePane.newRow();
        tablePane.startSubtable();
        tablePane.center();
        tablePane.add(jButton);
        tablePane.add(jButton2);
        tablePane.endSubtable();
        this.ptDialog.setContentPane(tablePane);
    }

    public void editPoint(KPoint kPoint) {
        if (kPoint == null) {
            return;
        }
        KList kList = (KList)kPoint.getParent();
        if (kList == null) {
            return;
        }
        Kinemage kinemage = kPoint.getKinemage();
        if (kinemage == null) {
            return;
        }
        this.thePoint = kPoint;
        this.ptID.setText(kPoint.getName());
        String string = kPoint.getComment();
        if (string == null) {
            this.ptComment.setText("");
        } else {
            this.ptComment.setText(string);
        }
        this.ptAspects.setText(kPoint.getAspects());
        this.ptMasters.setText(kinemage.fromPmBitmask(kPoint.getPmMask()));
        this.ptX.setText(Float.toString((float)kPoint.getX()));
        this.ptY.setText(Float.toString((float)kPoint.getY()));
        this.ptZ.setText(Float.toString((float)kPoint.getZ()));
        this.ptUnpickable.setSelected(kPoint.isUnpickable());
        this.ptOrigColor = kPoint.getColor();
        this.ptPicker.setBackgroundMode(this.kMain.getCanvas().getEngine().backgroundMode);
        this.ptPicker.setExtras(this.kMain.getKinemage().getNewPaintMap().values());
        this.ptPicker.setSelection(this.ptOrigColor);
        if (kPoint instanceof VectorPoint) {
            this.ptWidthRadius.setEnabled(true);
            this.ptWidthRadius.setText(Integer.toString(kPoint.getWidth()));
        } else if (kPoint instanceof BallPoint) {
            this.ptWidthRadius.setEnabled(true);
            this.ptWidthRadius.setText(Float.toString(((BallPoint)kPoint).r0));
        } else {
            this.ptWidthRadius.setEnabled(false);
            this.ptWidthRadius.setText("n/a");
        }
        this.index = 0;
        Iterator iterator = kList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (kPoint == iterator.next()) {
                this.index = n;
            }
            ++n;
        }
        this.ptIndex.setText("Index is " + (this.index + 1) + "/" + n);
        if (this.index == 0) {
            this.split.setEnabled(false);
        } else {
            this.split.setEnabled(true);
        }
        this.ptDialog.pack();
        if (this.ptFirstShow) {
            this.ptDialog.setLocationRelativeTo(this.kMain.getTopWindow());
            this.ptFirstShow = false;
        }
        this.ptDialog.setVisible(true);
    }

    public void onPointOK(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        this.thePoint.setName(this.ptID.getText());
        String string = this.ptComment.getText().trim();
        if (string.length() == 0) {
            this.thePoint.setComment(null);
        } else {
            this.thePoint.setComment(string);
        }
        String string2 = this.ptAspects.getText().trim().toUpperCase();
        if (string2.length() > 0) {
            this.thePoint.setAspects(string2);
        } else {
            this.thePoint.setAspects(null);
        }
        if (kinemage != null) {
            this.thePoint.setPmMask(kinemage.toPmBitmask(this.ptMasters.getText().trim(), true, true));
        }
        this.thePoint.setUnpickable(this.ptUnpickable.isSelected());
        try {
            this.thePoint.setX(Float.parseFloat(this.ptX.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.thePoint.setY(Float.parseFloat(this.ptY.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.thePoint.setZ(Float.parseFloat(this.ptZ.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.ptWidthRadius.getText().trim().equals("")) {
            this.ptWidthRadius.setText("0");
        }
        try {
            if (this.thePoint instanceof VectorPoint) {
                int n = Integer.parseInt(this.ptWidthRadius.getText().trim());
                if (n > 7) {
                    n = 7;
                }
                if (n < 0) {
                    n = 0;
                }
                this.thePoint.setWidth(n);
            } else if (this.thePoint instanceof BallPoint) {
                float f;
                ((BallPoint)this.thePoint).r0 = f = Float.parseFloat(this.ptWidthRadius.getText().trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.ptDialog.dispose();
        this.thePoint = null;
        if (kinemage != null) {
            kinemage.setModified(true);
        }
    }

    public void onPointCancel(ActionEvent actionEvent) {
        this.thePoint.setColor(this.ptOrigColor);
        this.ptDialog.dispose();
        this.thePoint = null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Kinemage kinemage = this.thePoint.getKinemage();
        if (kinemage == null) {
            return;
        }
        this.thePoint.setColor(this.ptPicker.getSelection());
    }

    public void onPointSplit(ActionEvent actionEvent) {
        KList kList = (KList)this.thePoint.getParent();
        if (kList == null) {
            return;
        }
        KGroup kGroup = (KGroup)kList.getParent();
        if (kGroup == null) {
            return;
        }
        if (this.index < 1 || this.index >= kList.getChildren().size()) {
            return;
        }
        KList kList2 = kList.clone(true);
        ArrayList arrayList = kList.getChildren();
        ArrayList arrayList2 = new ArrayList(arrayList.subList(0, this.index + 1));
        arrayList.clear();
        arrayList.addAll(arrayList2);
        kList.fireKinChanged(256);
        ArrayList arrayList3 = kList2.getChildren();
        ArrayList arrayList4 = new ArrayList(arrayList3.subList(this.index, arrayList3.size()));
        ((KPoint)arrayList4.get(0)).setPrev(null);
        arrayList3.clear();
        arrayList3.addAll(arrayList4);
        kGroup.add(kList2);
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.setModified(true);
        }
    }

    public void onEditGroup(ActionEvent actionEvent) {
        KList kList = (KList)this.thePoint.getParent();
        if (kList == null) {
            return;
        }
        KGroup kGroup = (KGroup)kList.getParent();
        if (kGroup == null) {
            return;
        }
        KGroup kGroup2 = (KGroup)kGroup.getParent();
        if (kGroup2 == null) {
            return;
        }
        this.groupEditor.editGroup(kGroup2);
    }

    public void onEditSubgroup(ActionEvent actionEvent) {
        KList kList = (KList)this.thePoint.getParent();
        if (kList == null) {
            return;
        }
        KGroup kGroup = (KGroup)kList.getParent();
        if (kGroup == null) {
            return;
        }
        this.groupEditor.editSubgroup(kGroup);
    }

    public void onEditList(ActionEvent actionEvent) {
        KList kList = (KList)this.thePoint.getParent();
        if (kList == null) {
            return;
        }
        this.groupEditor.editList(kList);
    }
}

