/*
 * Decompiled with CFR 0.152.
 */
package driftwood.star;

import driftwood.data.UberMap;
import driftwood.data.UberSet;
import driftwood.star.DataCell;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataBlock
extends DataCell {
    DataCell globalBlock = null;
    Map saveFrames = new UberMap();

    public DataBlock(String string) {
        super(string);
    }

    public DataCell getSaveFrame(String string) {
        return (DataCell)this.saveFrames.get(string);
    }

    public Collection getSaveFrames() {
        return Collections.unmodifiableCollection(this.saveFrames.values());
    }

    public DataCell removeSaveFrame(String string) {
        return (DataCell)this.saveFrames.remove(string);
    }

    public void clearSaveFrames() {
        this.saveFrames.clear();
    }

    public DataCell addSaveFrame(DataCell dataCell) {
        return this.saveFrames.put(dataCell.getName(), dataCell);
    }

    public Set getItemNames() {
        if (this.globalBlock == null) {
            return super.getItemNames();
        }
        UberSet uberSet = new UberSet(super.getItemNames());
        uberSet.addAll(this.globalBlock.getItemNames());
        return Collections.unmodifiableSet(uberSet);
    }

    public List getItem(String string) {
        List list = super.getItem(string);
        if (list.isEmpty() && this.globalBlock != null) {
            list = this.globalBlock.getItem(string);
        }
        return list;
    }

    public String getSingleItem(String string) {
        String string2 = super.getSingleItem(string);
        if (string2 == null && this.globalBlock != null) {
            string2 = this.globalBlock.getSingleItem(string);
        }
        return string2;
    }

    public void setGlobalBlock(DataCell dataCell) {
        this.globalBlock = dataCell;
        this.keys.clear();
    }

    public DataCell getGlobalBlock() {
        return this.globalBlock;
    }
}

