/*
 * Decompiled with CFR 0.152.
 */
package driftwood.isosurface;

import driftwood.isosurface.CrystalVertexSource;
import driftwood.util.SoftLog;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class OMapVertexSource
extends CrystalVertexSource {
    DataInputStream in;
    byte[] data = null;
    double prod;
    double plus;
    boolean bytesTransposed;

    public OMapVertexSource(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public OMapVertexSource(InputStream inputStream, boolean bl) throws IOException {
        inputStream = new BufferedInputStream(inputStream);
        inputStream.mark(10);
        if (inputStream.read() == 31 && inputStream.read() == 139) {
            inputStream.reset();
            inputStream = new BufferedInputStream(new GZIPInputStream(inputStream));
        } else {
            inputStream.reset();
        }
        inputStream.mark(10);
        this.bytesTransposed = inputStream.read() != 58 || inputStream.read() != 45 || inputStream.read() != 41 || inputStream.read() != 32;
        inputStream.reset();
        this.in = new DataInputStream(inputStream);
        super.init(bl);
    }

    void readHeader() throws IOException {
        if (this.bytesTransposed) {
            int[] nArray = new int[256];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.in.readShort();
            }
            this.aMin = nArray[0];
            this.bMin = nArray[1];
            this.cMin = nArray[2];
            this.aCount = nArray[3];
            this.bCount = nArray[4];
            this.cCount = nArray[5];
            this.aMax = this.aMin + this.aCount - 1;
            this.bMax = this.bMin + this.bCount - 1;
            this.cMax = this.cMin + this.cCount - 1;
            this.aSteps = nArray[6];
            this.bSteps = nArray[7];
            this.cSteps = nArray[8];
            double d = nArray[15];
            double d2 = nArray[16];
            double d3 = nArray[17];
            double d4 = nArray[18];
            this.prod = d / d4;
            this.plus = d2;
            this.aLength = (double)nArray[9] / d3;
            this.bLength = (double)nArray[10] / d3;
            this.cLength = (double)nArray[11] / d3;
            this.alpha = (double)nArray[12] / d3;
            this.beta = (double)nArray[13] / d3;
            this.gamma = (double)nArray[14] / d3;
        } else {
            try {
                int n;
                char[] cArray = new char[512];
                for (n = 0; n < cArray.length; ++n) {
                    cArray[n] = (char)this.in.read();
                }
                for (n = 0; n < cArray.length && cArray[n] != '\f'; ++n) {
                }
                StringTokenizer stringTokenizer = new StringTokenizer(new String(cArray, 0, n));
                if (!stringTokenizer.nextToken().equals(":-)")) {
                    throw new IllegalArgumentException("Missing smiley");
                }
                if (!stringTokenizer.nextToken().equalsIgnoreCase("origin")) {
                    throw new IllegalArgumentException("Parameters out of order");
                }
                this.aMin = Integer.parseInt(stringTokenizer.nextToken());
                this.bMin = Integer.parseInt(stringTokenizer.nextToken());
                this.cMin = Integer.parseInt(stringTokenizer.nextToken());
                if (!stringTokenizer.nextToken().equalsIgnoreCase("extent")) {
                    throw new IllegalArgumentException("Parameters out of order");
                }
                this.aCount = Integer.parseInt(stringTokenizer.nextToken());
                this.bCount = Integer.parseInt(stringTokenizer.nextToken());
                this.cCount = Integer.parseInt(stringTokenizer.nextToken());
                this.aMax = this.aMin + this.aCount - 1;
                this.bMax = this.bMin + this.bCount - 1;
                this.cMax = this.cMin + this.cCount - 1;
                if (!stringTokenizer.nextToken().equalsIgnoreCase("grid")) {
                    throw new IllegalArgumentException("Parameters out of order");
                }
                this.aSteps = Integer.parseInt(stringTokenizer.nextToken());
                this.bSteps = Integer.parseInt(stringTokenizer.nextToken());
                this.cSteps = Integer.parseInt(stringTokenizer.nextToken());
                if (!stringTokenizer.nextToken().equalsIgnoreCase("cell")) {
                    throw new IllegalArgumentException("Parameters out of order");
                }
                this.aLength = Double.parseDouble(stringTokenizer.nextToken());
                this.bLength = Double.parseDouble(stringTokenizer.nextToken());
                this.cLength = Double.parseDouble(stringTokenizer.nextToken());
                this.alpha = Double.parseDouble(stringTokenizer.nextToken());
                this.beta = Double.parseDouble(stringTokenizer.nextToken());
                this.gamma = Double.parseDouble(stringTokenizer.nextToken());
                if (!stringTokenizer.nextToken().equalsIgnoreCase("prod")) {
                    throw new IllegalArgumentException("Parameters out of order");
                }
                this.prod = Double.parseDouble(stringTokenizer.nextToken());
                if (!stringTokenizer.nextToken().equalsIgnoreCase("plus")) {
                    throw new IllegalArgumentException("Parameters out of order");
                }
                this.plus = Double.parseDouble(stringTokenizer.nextToken());
                if (!stringTokenizer.nextToken().equalsIgnoreCase("sigma")) {
                    throw new IllegalArgumentException("Parameters out of order");
                }
                this.sigma = Double.parseDouble(stringTokenizer.nextToken());
                this.mean = 0.0;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Bad number: " + numberFormatException.getMessage());
            }
        }
    }

    void readData() throws IOException {
        try {
            this.data = new byte[this.aCount * this.bCount * this.cCount];
            if (this.bytesTransposed) {
                for (int i = 0; i < this.cCount; i += 8) {
                    for (int j = 0; j < this.bCount; j += 8) {
                        for (int k = 0; k < this.aCount; k += 8) {
                            this.readBrickSwapped(k, j, i);
                        }
                    }
                }
            } else {
                for (int i = 0; i < this.cCount; i += 8) {
                    for (int j = 0; j < this.bCount; j += 8) {
                        for (int k = 0; k < this.aCount; k += 8) {
                            this.readBrickNotSwapped(k, j, i);
                        }
                    }
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IllegalArgumentException("Not enough memory: probably not a DSN6 map");
        }
        double d = this.mean;
        double d2 = this.sigma;
        this.calcMeanAndSigma();
        SoftLog.err.println("calculated  : mean = " + this.mean + "; sigma = " + this.sigma);
        if (Math.abs(this.mean - d) < 0.05 && Math.abs((this.sigma - d2) / this.sigma) < 0.05) {
            this.mean = 0.0;
            this.sigma = d2;
            SoftLog.err.println("close enough: mean = " + this.mean + "; sigma = " + this.sigma);
        }
    }

    void readBrickSwapped(int n, int n2, int n3) throws IOException {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; k += 2) {
                    this.setValue(n + k + 1, n2 + j, n3 + i, this.in.read());
                    this.setValue(n + k, n2 + j, n3 + i, this.in.read());
                }
            }
        }
    }

    void readBrickNotSwapped(int n, int n2, int n3) throws IOException {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    this.setValue(n + k, n2 + j, n3 + i, this.in.read());
                }
            }
        }
    }

    public boolean hasData() {
        return this.data != null;
    }

    void calcMeanAndSigma() {
        int n;
        long l = 0L;
        for (n = 0; n < this.data.length; ++n) {
            l += (long)(this.data[n] & 0xFF);
        }
        this.mean = ((double)l / (double)this.data.length - this.plus) / this.prod;
        this.sigma = 0.0;
        for (n = 0; n < this.data.length; ++n) {
            double d = this.mean - ((double)(this.data[n] & 0xFF) - this.plus) / this.prod;
            this.sigma += d * d;
        }
        this.sigma = Math.sqrt(this.sigma / (double)this.data.length);
    }

    public double getValue(int n, int n2, int n3) {
        int n4 = this.data[n + n2 * this.aCount + n3 * this.aCount * this.bCount] & 0xFF;
        return ((double)n4 - this.plus) / this.prod;
    }

    void setValue(int n, int n2, int n3, int n4) throws EOFException {
        if (n4 == -1) {
            throw new EOFException("Premature end of file");
        }
        if (n < this.aCount && n2 < this.bCount && n3 < this.cCount) {
            this.data[n + n2 * this.aCount + n3 * this.aCount * this.bCount] = (byte)n4;
        }
    }

    public String toString() {
        return super.toString() + "\nprod = " + this.prod + "; plus = " + this.plus;
    }
}

