/*
 * Decompiled with CFR 0.152.
 */
package driftwood.isosurface;

import driftwood.isosurface.EdgePlotter;
import driftwood.isosurface.VertexEvaluator;
import driftwood.isosurface.VertexLocator;

public class MarchingCubes {
    static final int[][] SPARSE_VECTOR = MarchingCubes.createSparseVectorTable();
    static final int[][] TRIANGLE_STRIP = MarchingCubes.createTriangleStripTable();
    public static final Object MODE_TRIANGLE = "triangle strip isosurface";
    public static final Object MODE_MESH = "optimized wireframe mesh isosurface";
    VertexLocator locator;
    VertexEvaluator evaluator;
    EdgePlotter plotter;
    final int[][] mcubes;
    final Object mode;
    double vv0 = 0.0;
    double vv1 = 0.0;
    double vv2 = 0.0;
    double vv3 = 0.0;
    double vv4 = 0.0;
    double vv5 = 0.0;
    double vv6 = 0.0;
    double vv7 = 0.0;
    double[] cv0 = new double[]{0.0, 0.0, 0.0};
    double[] cv1 = new double[]{0.0, 0.0, 0.0};
    double[] cv2 = new double[]{0.0, 0.0, 0.0};
    double[] cv3 = new double[]{0.0, 0.0, 0.0};
    double[] cv4 = new double[]{0.0, 0.0, 0.0};
    double[] cv5 = new double[]{0.0, 0.0, 0.0};
    double[] cv6 = new double[]{0.0, 0.0, 0.0};
    double[] cv7 = new double[]{0.0, 0.0, 0.0};

    private static int[][] createSparseVectorTable() {
        int[][] nArrayArray = new int[256][];
        nArrayArray[0] = new int[0];
        nArrayArray[1] = new int[]{0, 3, 8, 0};
        nArrayArray[2] = new int[]{1, 0, 9};
        nArrayArray[3] = new int[]{1, 3, 8, 9};
        nArrayArray[4] = new int[]{1, 2};
        nArrayArray[5] = new int[]{1, 2, -1, 0, 3, 8, 0};
        nArrayArray[6] = new int[]{2, 0, 9};
        nArrayArray[7] = new int[]{9, 8, 10, -1, 2, 3, 8};
        nArrayArray[8] = new int[]{2, 3, 11};
        nArrayArray[9] = new int[]{11, 8, 0, 2};
        nArrayArray[10] = new int[]{2, 3, 11, -1, 1, 0, 9};
        nArrayArray[11] = new int[]{9, 8, 11, 9, -1, 1, 2};
        nArrayArray[12] = new int[]{1, 3, 11};
        nArrayArray[13] = new int[]{10, 8, 11, -1, 1, 0, 8};
        nArrayArray[14] = new int[]{0, 3, 11, 9, 0};
        nArrayArray[15] = new int[]{9, 8, 11};
        nArrayArray[16] = new int[]{4, 8, 7};
        nArrayArray[17] = new int[]{7, 3, 0, 4};
        nArrayArray[18] = new int[]{1, 0, 9, -1, 4, 8, 7};
        nArrayArray[19] = new int[]{1, 3, 7, 1, -1, 4, 9};
        nArrayArray[20] = new int[]{1, 2, -1, 4, 8, 7};
        nArrayArray[21] = new int[]{1, 2, -1, 7, 3, 0, 4};
        nArrayArray[22] = new int[]{2, 0, 9, -1, 4, 8, 7};
        nArrayArray[23] = new int[]{2, 3, 7, 9, 2, 7, -1, 4, 9};
        nArrayArray[24] = new int[]{2, 3, 11, -1, 4, 8, 7};
        nArrayArray[25] = new int[]{2, 0, 4, 2, -1, 7, 11};
        nArrayArray[26] = new int[]{1, 0, 9, -1, 11, 3, 2, -1, 7, 8, 4};
        nArrayArray[27] = new int[]{1, 2, 4, 9, -1, 7, 11};
        nArrayArray[28] = new int[]{1, 3, 11, -1, 4, 8, 7};
        nArrayArray[29] = new int[]{11, 7, 0, 10, 7, -1, 4, 0, 1};
        nArrayArray[30] = new int[]{0, 3, 11, 9, 0, -1, 4, 8, 7};
        nArrayArray[32] = new int[]{4, 9};
        nArrayArray[33] = new int[]{0, 3, 8, 0, -1, 4, 9};
        nArrayArray[34] = new int[]{1, 0, 4};
        nArrayArray[35] = new int[]{1, 3, 5, -1, 4, 8, 3};
        nArrayArray[36] = new int[]{1, 2, -1, 4, 9};
        nArrayArray[37] = new int[]{1, 2, -1, 4, 9, -1, 0, 3, 8, 0};
        nArrayArray[38] = new int[]{0, 2, 4, 0};
        nArrayArray[39] = new int[]{2, 4, 8, 3, 2};
        nArrayArray[40] = new int[]{2, 3, 11, -1, 4, 9};
        nArrayArray[41] = new int[]{2, 0, 8, 11, -1, 4, 9};
        nArrayArray[42] = new int[]{2, 3, 11, -1, 1, 0, 4};
        nArrayArray[43] = new int[]{4, 8, 11, -1, 1, 2, 5, 8, 2};
        nArrayArray[44] = new int[]{1, 3, 11, -1, 4, 9};
        nArrayArray[45] = new int[]{11, 8, 10, -1, 1, 0, 8, -1, 4, 9};
        nArrayArray[46] = new int[]{11, 3, 0, 4, 10, 3, 4};
        nArrayArray[48] = new int[]{7, 8, 9};
        nArrayArray[49] = new int[]{7, 3, 5, -1, 9, 0, 3};
        nArrayArray[50] = new int[]{0, 1, 7, 8, 0};
        nArrayArray[51] = new int[]{1, 3, 7};
        nArrayArray[52] = new int[]{1, 2, -1, 7, 8, 9};
        nArrayArray[53] = new int[]{7, 3, 5, -1, 9, 0, 3, -1, 1, 2};
        nArrayArray[54] = new int[]{2, 0, 8, 7, 10, 0, 7};
        nArrayArray[56] = new int[]{7, 8, 9, -1, 2, 3, 11};
        nArrayArray[57] = new int[]{11, 7, 9, 2, 7, -1, 9, 0, 2};
        nArrayArray[58] = new int[]{0, 1, 7, 8, 0, -1, 2, 3, 11};
        nArrayArray[60] = new int[]{7, 8, 9, -1, 1, 3, 11};
        nArrayArray[64] = new int[0];
        nArrayArray[65] = new int[]{0, 3, 8, 0};
        nArrayArray[66] = new int[]{1, 0, 9};
        nArrayArray[67] = new int[]{1, 3, 8, 9};
        nArrayArray[68] = new int[]{1, 2};
        nArrayArray[69] = new int[]{1, 2, -1, 0, 3, 8, 0};
        nArrayArray[70] = new int[]{2, 0, 6, -1, 0, 9};
        nArrayArray[71] = new int[]{2, 3, 8, 9, 6, 3, 9};
        nArrayArray[72] = new int[]{2, 3, 11};
        nArrayArray[73] = new int[]{2, 0, 8, 11};
        nArrayArray[74] = new int[]{1, 0, 9, -1, 2, 3, 11};
        nArrayArray[75] = new int[]{8, 9, 11, 8, -1, 1, 2};
        nArrayArray[76] = new int[]{1, 3, 5, -1, 3, 11};
        nArrayArray[77] = new int[]{11, 8, 0, 1, 6, 8, 1};
        nArrayArray[78] = new int[]{9, 0, 3, 11, 9};
        nArrayArray[80] = new int[]{4, 8, 7};
        nArrayArray[81] = new int[]{4, 0, 3, 7};
        nArrayArray[82] = new int[]{1, 0, 9, -1, 4, 8, 7};
        nArrayArray[83] = new int[]{1, 3, 7, 1, -1, 4, 9};
        nArrayArray[84] = new int[]{1, 2, -1, 4, 8, 7};
        nArrayArray[85] = new int[]{1, 2, -1, 4, 0, 3, 7};
        nArrayArray[86] = new int[]{2, 0, 6, -1, 0, 9, -1, 4, 8, 7};
        nArrayArray[88] = new int[]{2, 3, 11, -1, 4, 8, 7};
        nArrayArray[89] = new int[]{0, 2, 4, 0, -1, 7, 11};
        nArrayArray[90] = new int[]{4, 8, 7, -1, 2, 3, 11, -1, 1, 0, 9};
        nArrayArray[92] = new int[]{1, 3, 5, -1, 3, 11, -1, 4, 8, 7};
        nArrayArray[96] = new int[]{4, 9};
        nArrayArray[97] = new int[]{4, 9, -1, 0, 3, 8, 0};
        nArrayArray[98] = new int[]{4, 0, 6, -1, 0, 1};
        nArrayArray[99] = new int[]{1, 3, 8, 4, 10, 3, 4};
        nArrayArray[100] = new int[]{1, 2, 4, 9};
        nArrayArray[101] = new int[]{1, 2, 4, 9, -1, 0, 3, 8, 0};
        nArrayArray[102] = new int[]{2, 0, 4};
        nArrayArray[104] = new int[]{4, 9, -1, 2, 3, 11};
        nArrayArray[105] = new int[]{4, 9, -1, 2, 0, 8, 11};
        nArrayArray[106] = new int[]{4, 0, 6, -1, 0, 1, -1, 2, 3, 11};
        nArrayArray[108] = new int[]{9, 4, 11, 1, 4, -1, 11, 3, 1};
        nArrayArray[112] = new int[]{9, 8, 10, -1, 7, 8};
        nArrayArray[113] = new int[]{9, 0, 3, 7, 10, 0, 7, 10};
        nArrayArray[114] = new int[]{1, 0, 8, 7, 1};
        nArrayArray[116] = new int[]{9, 8, 7, -1, 2, 1, 8, 6, 1};
        nArrayArray[120] = new int[]{2, 3, 11, -1, 9, 8, 10, -1, 7, 8};
        nArrayArray[128] = new int[]{7, 11};
        nArrayArray[129] = new int[]{7, 11, -1, 0, 3, 8, 0};
        nArrayArray[130] = new int[]{7, 11, -1, 1, 0, 9};
        nArrayArray[131] = new int[]{1, 3, 8, 9, -1, 7, 11};
        nArrayArray[132] = new int[]{7, 11, -1, 1, 2};
        nArrayArray[133] = new int[]{7, 11, -1, 1, 2, -1, 0, 3, 8, 0};
        nArrayArray[134] = new int[]{2, 0, 9, -1, 11, 7};
        nArrayArray[136] = new int[]{2, 3, 7};
        nArrayArray[137] = new int[]{2, 0, 6, -1, 7, 8, 0};
        nArrayArray[138] = new int[]{2, 3, 7, -1, 1, 0, 9};
        nArrayArray[140] = new int[]{1, 3, 7, 1};
        nArrayArray[144] = new int[]{4, 8, 11};
        nArrayArray[145] = new int[]{4, 0, 6, -1, 0, 3, 11};
        nArrayArray[146] = new int[]{4, 8, 11, -1, 1, 0, 9};
        nArrayArray[148] = new int[]{4, 8, 11, -1, 1, 2};
        nArrayArray[152] = new int[]{2, 3, 8, 4, 2};
        nArrayArray[160] = new int[]{7, 11, -1, 4, 9};
        nArrayArray[161] = new int[]{7, 11, -1, 4, 9, -1, 0, 3, 8, 0};
        nArrayArray[162] = new int[]{1, 0, 4, -1, 7, 11};
        nArrayArray[164] = new int[]{1, 2, -1, 4, 9, -1, 7, 11};
        nArrayArray[168] = new int[]{2, 3, 7, -1, 4, 9};
        nArrayArray[176] = new int[]{8, 9, 11, 8};
        nArrayArray[192] = new int[]{7, 11};
        nArrayArray[193] = new int[]{7, 11, -1, 0, 3, 8, 0};
        nArrayArray[194] = new int[]{7, 11, -1, 1, 0, 9};
        nArrayArray[196] = new int[]{2, 1, 7, 11};
        nArrayArray[200] = new int[]{5, 3, 7, -1, 2, 3};
        nArrayArray[208] = new int[]{10, 8, 11, -1, 4, 8};
        nArrayArray[224] = new int[]{4, 9, 11, 7};
        for (int i = 0; i < 256; ++i) {
            if (nArrayArray[i] == null) {
                nArrayArray[i] = nArrayArray[i ^ 0xFF];
            }
            if (nArrayArray[i] != null) continue;
            throw new Error("Marching cubes data missing for lookup index #" + i);
        }
        return nArrayArray;
    }

    private static int[][] createTriangleStripTable() {
        int[][] nArrayArray = new int[256][];
        nArrayArray[0] = new int[0];
        nArrayArray[1] = new int[]{0, 8, 3};
        nArrayArray[2] = new int[]{9, 0, 1};
        nArrayArray[3] = new int[]{9, 8, 1, 3};
        nArrayArray[4] = new int[]{10, 1, 2};
        nArrayArray[5] = new int[]{0, 8, 3, -1, 2, 10, 1};
        nArrayArray[6] = new int[]{0, 2, 9, 10};
        nArrayArray[7] = new int[]{2, 3, 10, 8, 9};
        nArrayArray[8] = new int[]{3, 11, 2};
        nArrayArray[9] = new int[]{8, 11, 0, 2};
        nArrayArray[10] = new int[]{1, 9, 0, -1, 3, 11, 2};
        nArrayArray[11] = new int[]{1, 2, 9, 11, 8};
        nArrayArray[12] = new int[]{11, 10, 3, 1};
        nArrayArray[13] = new int[]{0, 1, 8, 10, 11};
        nArrayArray[14] = new int[]{3, 0, 11, 9, 10};
        nArrayArray[15] = new int[]{9, 10, 8, 11};
        nArrayArray[16] = new int[]{8, 4, 7};
        nArrayArray[17] = new int[]{7, 3, 4, 0};
        nArrayArray[18] = new int[]{4, 7, 8, -1, 0, 1, 9};
        nArrayArray[19] = new int[]{4, 9, 7, 1, 3};
        nArrayArray[20] = new int[]{7, 8, 4, -1, 10, 1, 2};
        nArrayArray[21] = new int[]{0, 4, 3, 7, -1, 2, 10, 1};
        nArrayArray[22] = new int[]{0, 2, 9, 10, -1, 4, 7, 8};
        nArrayArray[23] = new int[]{3, 2, 7, 9, 4, -1, 2, 10, 9};
        nArrayArray[24] = new int[]{8, 4, 7, -1, 11, 2, 3};
        nArrayArray[25] = new int[]{11, 7, 2, 4, 0};
        nArrayArray[26] = new int[]{11, 3, 2, -1, 0, 1, 9, -1, 7, 8, 4};
        nArrayArray[27] = new int[]{4, 7, 9, 11, 1, 2};
        nArrayArray[28] = new int[]{11, 10, 3, 1, -1, 8, 4, 7};
        nArrayArray[29] = new int[]{4, 0, 7, 10, 11, -1, 0, 10, 1};
        nArrayArray[30] = new int[]{8, 7, 4, -1, 3, 0, 11, 9, 10};
        nArrayArray[31] = new int[]{4, 7, 9, 11, 10};
        nArrayArray[32] = new int[]{5, 4, 9};
        nArrayArray[33] = new int[]{9, 5, 4, -1, 8, 3, 0};
        nArrayArray[34] = new int[]{4, 0, 5, 1};
        nArrayArray[35] = new int[]{8, 4, 3, 5, 1};
        nArrayArray[36] = new int[]{5, 4, 9, -1, 1, 2, 10};
        nArrayArray[37] = new int[]{2, 1, 10, -1, 9, 5, 4, -1, 3, 0, 8};
        nArrayArray[38] = new int[]{5, 10, 4, 2, 0};
        nArrayArray[39] = new int[]{2, 10, 3, 5, 8, 4};
        nArrayArray[40] = new int[]{2, 3, 11, -1, 5, 4, 9};
        nArrayArray[41] = new int[]{8, 11, 0, 2, -1, 9, 5, 4};
        nArrayArray[42] = new int[]{1, 5, 0, 4, -1, 3, 11, 2};
        nArrayArray[43] = new int[]{11, 8, 2, 5, 1, -1, 8, 5, 4};
        nArrayArray[44] = new int[]{1, 3, 10, 11, -1, 5, 4, 9};
        nArrayArray[45] = new int[]{9, 4, 5, -1, 0, 1, 8, 10, 11};
        nArrayArray[46] = new int[]{0, 3, 4, 10, 5, -1, 3, 11, 10};
        nArrayArray[47] = new int[]{5, 4, 10, 8, 11};
        nArrayArray[48] = new int[]{8, 9, 7, 5};
        nArrayArray[49] = new int[]{9, 0, 5, 3, 7};
        nArrayArray[50] = new int[]{0, 8, 1, 7, 5};
        nArrayArray[51] = new int[]{1, 3, 5, 7};
        nArrayArray[52] = new int[]{5, 7, 9, 8, -1, 1, 2, 10};
        nArrayArray[53] = new int[]{1, 10, 2, -1, 9, 0, 5, 3, 7};
        nArrayArray[54] = new int[]{2, 0, 10, 7, 5, -1, 0, 7, 8};
        nArrayArray[55] = new int[]{2, 10, 3, 5, 7};
        nArrayArray[56] = new int[]{8, 9, 7, 5, -1, 11, 2, 3};
        nArrayArray[57] = new int[]{0, 9, 2, 7, 11, -1, 9, 5, 7};
        nArrayArray[58] = new int[]{3, 2, 11, -1, 0, 8, 1, 7, 5};
        nArrayArray[59] = new int[]{11, 2, 7, 1, 5};
        nArrayArray[60] = new int[]{10, 1, 11, 3, -1, 5, 9, 7, 8};
        nArrayArray[61] = new int[]{10, 11, 5, 7, -1, 9, 0, 1};
        nArrayArray[62] = new int[]{7, 5, 11, 10, -1, 3, 0, 8};
        nArrayArray[63] = new int[]{10, 11, 5, 7};
        nArrayArray[64] = new int[]{6, 5, 10};
        nArrayArray[65] = new int[]{0, 8, 3, -1, 10, 6, 5};
        nArrayArray[66] = new int[]{10, 6, 5, -1, 9, 0, 1};
        nArrayArray[67] = new int[]{9, 8, 1, 3, -1, 10, 6, 5};
        nArrayArray[68] = new int[]{2, 6, 1, 5};
        nArrayArray[69] = new int[]{2, 6, 1, 5, -1, 0, 8, 3};
        nArrayArray[70] = new int[]{9, 5, 0, 6, 2};
        nArrayArray[71] = new int[]{8, 9, 3, 6, 2, -1, 9, 6, 5};
        nArrayArray[72] = new int[]{2, 3, 11, -1, 6, 5, 10};
        nArrayArray[73] = new int[]{2, 0, 11, 8, -1, 6, 5, 10};
        nArrayArray[74] = new int[]{3, 2, 11, -1, 10, 6, 5, -1, 0, 1, 9};
        nArrayArray[75] = new int[]{10, 5, 6, -1, 1, 2, 9, 11, 8};
        nArrayArray[76] = new int[]{6, 11, 5, 3, 1};
        nArrayArray[77] = new int[]{1, 0, 5, 11, 6, -1, 0, 8, 11};
        nArrayArray[78] = new int[]{6, 5, 11, 9, 3, 0};
        nArrayArray[79] = new int[]{6, 5, 11, 9, 8};
        nArrayArray[80] = new int[]{5, 10, 6, -1, 7, 8, 4};
        nArrayArray[81] = new int[]{7, 3, 4, 0, -1, 5, 10, 6};
        nArrayArray[82] = new int[]{7, 4, 8, -1, 9, 0, 1, -1, 6, 5, 10};
        nArrayArray[83] = new int[]{5, 6, 10, -1, 4, 9, 7, 1, 3};
        nArrayArray[84] = new int[]{5, 1, 6, 2, -1, 7, 8, 4};
        nArrayArray[85] = new int[]{4, 7, 0, 3, -1, 5, 6, 1, 2};
        nArrayArray[86] = new int[]{4, 8, 7, -1, 9, 5, 0, 6, 2};
        nArrayArray[87] = new int[]{6, 2, 7, 3, -1, 4, 9, 5};
        nArrayArray[88] = new int[]{5, 6, 10, -1, 11, 2, 3, -1, 4, 7, 8};
        nArrayArray[89] = new int[]{6, 10, 5, -1, 11, 7, 2, 4, 0};
        nArrayArray[90] = new int[]{9, 0, 1, -1, 11, 3, 2, -1, 5, 10, 6, -1, 8, 7, 4};
        nArrayArray[91] = new int[]{11, 6, 7, -1, 5, 4, 9, -1, 2, 10, 1};
        nArrayArray[92] = new int[]{7, 4, 8, -1, 6, 11, 5, 3, 1};
        nArrayArray[93] = new int[]{4, 0, 5, 1, -1, 6, 11, 7};
        nArrayArray[94] = new int[]{3, 8, 0, -1, 4, 9, 5, -1, 11, 7, 6};
        nArrayArray[95] = new int[]{6, 11, 7, -1, 4, 9, 5};
        nArrayArray[96] = new int[]{9, 10, 4, 6};
        nArrayArray[97] = new int[]{9, 10, 4, 6, -1, 8, 3, 0};
        nArrayArray[98] = new int[]{10, 1, 6, 0, 4};
        nArrayArray[99] = new int[]{4, 8, 6, 1, 10, -1, 8, 3, 1};
        nArrayArray[100] = new int[]{1, 9, 2, 4, 6};
        nArrayArray[101] = new int[]{0, 3, 8, -1, 1, 9, 2, 4, 6};
        nArrayArray[102] = new int[]{2, 0, 6, 4};
        nArrayArray[103] = new int[]{8, 3, 4, 2, 6};
        nArrayArray[104] = new int[]{6, 4, 10, 9, -1, 2, 3, 11};
        nArrayArray[105] = new int[]{0, 8, 2, 11, -1, 9, 4, 10, 6};
        nArrayArray[106] = new int[]{2, 11, 3, -1, 10, 1, 6, 0, 4};
        nArrayArray[107] = new int[]{11, 8, 6, 4, -1, 10, 1, 2};
        nArrayArray[108] = new int[]{4, 6, 9, 3, 1, -1, 6, 3, 11};
        nArrayArray[109] = new int[]{4, 6, 8, 11, -1, 0, 1, 9};
        nArrayArray[110] = new int[]{3, 11, 0, 6, 4};
        nArrayArray[111] = new int[]{11, 8, 6, 4};
        nArrayArray[112] = new int[]{7, 6, 8, 10, 9};
        nArrayArray[113] = new int[]{3, 7, 0, 10, 9, -1, 7, 10, 6};
        nArrayArray[114] = new int[]{0, 1, 8, 10, 7, 6};
        nArrayArray[115] = new int[]{10, 6, 1, 7, 3};
        nArrayArray[116] = new int[]{6, 7, 2, 9, 1, -1, 7, 8, 9};
        nArrayArray[117] = new int[]{3, 7, 2, 6, -1, 1, 9, 0};
        nArrayArray[118] = new int[]{7, 8, 6, 0, 2};
        nArrayArray[119] = new int[]{6, 2, 7, 3};
        nArrayArray[120] = new int[]{11, 3, 2, -1, 7, 6, 8, 10, 9};
        nArrayArray[121] = new int[]{10, 9, 2, 0, -1, 11, 7, 6};
        nArrayArray[122] = new int[]{7, 11, 6, -1, 2, 10, 1, -1, 8, 3, 0};
        nArrayArray[123] = new int[]{11, 7, 6, -1, 10, 1, 2};
        nArrayArray[124] = new int[]{3, 1, 8, 9, -1, 7, 6, 11};
        nArrayArray[125] = new int[]{11, 7, 6, -1, 1, 9, 0};
        nArrayArray[126] = new int[]{7, 6, 11, -1, 3, 0, 8};
        nArrayArray[127] = new int[]{7, 6, 11};
        for (int i = 0; i < 256; ++i) {
            if (nArrayArray[i] == null) {
                nArrayArray[i] = nArrayArray[i ^ 0xFF];
            }
            if (nArrayArray[i] != null) continue;
            throw new Error("Marching cubes data missing for lookup index #" + i);
        }
        return nArrayArray;
    }

    public MarchingCubes(VertexLocator vertexLocator, VertexEvaluator vertexEvaluator, EdgePlotter edgePlotter, Object object) {
        this.locator = vertexLocator;
        this.evaluator = vertexEvaluator;
        this.plotter = edgePlotter;
        this.mode = object;
        if (object == MODE_TRIANGLE) {
            this.mcubes = TRIANGLE_STRIP;
        } else if (object == MODE_MESH) {
            this.mcubes = SPARSE_VECTOR;
        } else {
            throw new IllegalArgumentException("Illegal mode: " + object);
        }
    }

    public void march(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        this.plotter.startIsosurface(d);
        for (int i = n; i < n4; ++i) {
            for (int j = n2; j < n5; ++j) {
                for (int k = n3; k < n6; ++k) {
                    this.evalCell(i, j, k, d);
                }
            }
        }
        this.plotter.endIsosurface(d);
    }

    void evalCell(int n, int n2, int n3, double d) {
        this.plotter.startCell(n, n2, n3);
        this.vv0 = this.evaluator.evaluateVertex(n, n2, n3);
        this.vv1 = this.evaluator.evaluateVertex(n + 1, n2, n3);
        this.vv2 = this.evaluator.evaluateVertex(n + 1, n2 + 1, n3);
        this.vv3 = this.evaluator.evaluateVertex(n, n2 + 1, n3);
        this.vv4 = this.evaluator.evaluateVertex(n, n2, n3 + 1);
        this.vv5 = this.evaluator.evaluateVertex(n + 1, n2, n3 + 1);
        this.vv6 = this.evaluator.evaluateVertex(n + 1, n2 + 1, n3 + 1);
        this.vv7 = this.evaluator.evaluateVertex(n, n2 + 1, n3 + 1);
        if (Double.isNaN(this.vv0) || Double.isNaN(this.vv1) || Double.isNaN(this.vv2) || Double.isNaN(this.vv3) || Double.isNaN(this.vv4) || Double.isNaN(this.vv5) || Double.isNaN(this.vv6) || Double.isNaN(this.vv7)) {
            return;
        }
        int n4 = 0;
        if (this.vv0 > d) {
            n4 |= 1;
        }
        if (this.vv1 > d) {
            n4 |= 2;
        }
        if (this.vv2 > d) {
            n4 |= 4;
        }
        if (this.vv3 > d) {
            n4 |= 8;
        }
        if (this.vv4 > d) {
            n4 |= 0x10;
        }
        if (this.vv5 > d) {
            n4 |= 0x20;
        }
        if (this.vv6 > d) {
            n4 |= 0x40;
        }
        if (this.vv7 > d) {
            n4 |= 0x80;
        }
        if (n4 == 0 || n4 == 255) {
            this.plotter.endCell(n, n2, n3);
            return;
        }
        this.locator.locateVertex(n, n2, n3, this.cv0);
        this.locator.locateVertex(n + 1, n2, n3, this.cv1);
        this.locator.locateVertex(n + 1, n2 + 1, n3, this.cv2);
        this.locator.locateVertex(n, n2 + 1, n3, this.cv3);
        this.locator.locateVertex(n, n2, n3 + 1, this.cv4);
        this.locator.locateVertex(n + 1, n2, n3 + 1, this.cv5);
        this.locator.locateVertex(n + 1, n2 + 1, n3 + 1, this.cv6);
        this.locator.locateVertex(n, n2 + 1, n3 + 1, this.cv7);
        int[] nArray = this.mcubes[n4];
        int n5 = 0;
        int n6 = nArray.length;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        boolean bl = false;
        for (n5 = 0; n5 < n6; ++n5) {
            if (nArray[n5] == -1) {
                bl = false;
                continue;
            }
            this.getEdge(nArray[n5], d, dArray);
            this.plotter.plotEdge(dArray[0], dArray[1], dArray[2], bl);
            bl = true;
        }
        this.plotter.endCell(n, n2, n3);
    }

    void getEdge(int n, double d, double[] dArray) {
        switch (n) {
            case 0: {
                double d2 = (this.vv1 - d) / (this.vv1 - this.vv0);
                double d3 = 1.0 - d2;
                dArray[0] = d2 * this.cv0[0] + d3 * this.cv1[0];
                dArray[1] = d2 * this.cv0[1] + d3 * this.cv1[1];
                dArray[2] = d2 * this.cv0[2] + d3 * this.cv1[2];
                break;
            }
            case 1: {
                double d4 = (this.vv1 - d) / (this.vv1 - this.vv2);
                double d5 = 1.0 - d4;
                dArray[0] = d4 * this.cv2[0] + d5 * this.cv1[0];
                dArray[1] = d4 * this.cv2[1] + d5 * this.cv1[1];
                dArray[2] = d4 * this.cv2[2] + d5 * this.cv1[2];
                break;
            }
            case 2: {
                double d6 = (this.vv3 - d) / (this.vv3 - this.vv2);
                double d7 = 1.0 - d6;
                dArray[0] = d6 * this.cv2[0] + d7 * this.cv3[0];
                dArray[1] = d6 * this.cv2[1] + d7 * this.cv3[1];
                dArray[2] = d6 * this.cv2[2] + d7 * this.cv3[2];
                break;
            }
            case 3: {
                double d8 = (this.vv3 - d) / (this.vv3 - this.vv0);
                double d9 = 1.0 - d8;
                dArray[0] = d8 * this.cv0[0] + d9 * this.cv3[0];
                dArray[1] = d8 * this.cv0[1] + d9 * this.cv3[1];
                dArray[2] = d8 * this.cv0[2] + d9 * this.cv3[2];
                break;
            }
            case 4: {
                double d10 = (this.vv5 - d) / (this.vv5 - this.vv4);
                double d11 = 1.0 - d10;
                dArray[0] = d10 * this.cv4[0] + d11 * this.cv5[0];
                dArray[1] = d10 * this.cv4[1] + d11 * this.cv5[1];
                dArray[2] = d10 * this.cv4[2] + d11 * this.cv5[2];
                break;
            }
            case 5: {
                double d12 = (this.vv6 - d) / (this.vv6 - this.vv5);
                double d13 = 1.0 - d12;
                dArray[0] = d12 * this.cv5[0] + d13 * this.cv6[0];
                dArray[1] = d12 * this.cv5[1] + d13 * this.cv6[1];
                dArray[2] = d12 * this.cv5[2] + d13 * this.cv6[2];
                break;
            }
            case 6: {
                double d14 = (this.vv6 - d) / (this.vv6 - this.vv7);
                double d15 = 1.0 - d14;
                dArray[0] = d14 * this.cv7[0] + d15 * this.cv6[0];
                dArray[1] = d14 * this.cv7[1] + d15 * this.cv6[1];
                dArray[2] = d14 * this.cv7[2] + d15 * this.cv6[2];
                break;
            }
            case 7: {
                double d16 = (this.vv4 - d) / (this.vv4 - this.vv7);
                double d17 = 1.0 - d16;
                dArray[0] = d16 * this.cv7[0] + d17 * this.cv4[0];
                dArray[1] = d16 * this.cv7[1] + d17 * this.cv4[1];
                dArray[2] = d16 * this.cv7[2] + d17 * this.cv4[2];
                break;
            }
            case 8: {
                double d18 = (this.vv4 - d) / (this.vv4 - this.vv0);
                double d19 = 1.0 - d18;
                dArray[0] = d18 * this.cv0[0] + d19 * this.cv4[0];
                dArray[1] = d18 * this.cv0[1] + d19 * this.cv4[1];
                dArray[2] = d18 * this.cv0[2] + d19 * this.cv4[2];
                break;
            }
            case 9: {
                double d20 = (this.vv1 - d) / (this.vv1 - this.vv5);
                double d21 = 1.0 - d20;
                dArray[0] = d20 * this.cv5[0] + d21 * this.cv1[0];
                dArray[1] = d20 * this.cv5[1] + d21 * this.cv1[1];
                dArray[2] = d20 * this.cv5[2] + d21 * this.cv1[2];
                break;
            }
            case 10: {
                double d22 = (this.vv6 - d) / (this.vv6 - this.vv2);
                double d23 = 1.0 - d22;
                dArray[0] = d22 * this.cv2[0] + d23 * this.cv6[0];
                dArray[1] = d22 * this.cv2[1] + d23 * this.cv6[1];
                dArray[2] = d22 * this.cv2[2] + d23 * this.cv6[2];
                break;
            }
            case 11: {
                double d24 = (this.vv7 - d) / (this.vv7 - this.vv3);
                double d25 = 1.0 - d24;
                dArray[0] = d24 * this.cv3[0] + d25 * this.cv7[0];
                dArray[1] = d24 * this.cv3[1] + d25 * this.cv7[1];
                dArray[2] = d24 * this.cv3[2] + d25 * this.cv7[2];
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a legal edge index from 0 to 11");
            }
        }
    }

    public Object getMode() {
        return this.mode;
    }
}

