/*
 * Decompiled with CFR 0.152.
 */
package driftwood.gui;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane;
import driftwood.gui.TextCutCopyPasteMenu;
import driftwood.util.SoftLog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class LogViewer
extends JDialog {
    SoftLog log;
    JTextArea text;

    public LogViewer(Frame frame, String string, SoftLog softLog) {
        super(frame, string, true);
        this.init(softLog);
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public LogViewer(Dialog dialog, String string, SoftLog softLog) {
        super(dialog, string, true);
        this.init(softLog);
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }

    private void init(SoftLog softLog) {
        this.log = softLog;
        this.buildGUI();
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    protected void buildGUI() {
        TablePane tablePane = new TablePane();
        this.setContentPane(tablePane);
        this.text = new JTextArea(this.log.getString(), 25, 60);
        this.text.setLineWrap(false);
        new TextCutCopyPasteMenu(this.text);
        JButton jButton = new JButton(new ReflectiveAction("Clear", null, this, "onClear"));
        JButton jButton2 = new JButton(new ReflectiveAction("Save to disk...", null, this, "onSave"));
        JScrollPane jScrollPane = new JScrollPane(this.text);
        tablePane.hfill(true).vfill(true);
        tablePane.add((Component)jScrollPane, 2, 1);
        tablePane.newRow();
        tablePane.hfill(false).vfill(false).weights(0.0, 0.0);
        tablePane.left().add(jButton);
        tablePane.right().add(jButton2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(1);
        actionMap.put("close-window", new ReflectiveAction("", null, this, "onClose"));
        inputMap.put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "close-window");
    }

    public void onClose(ActionEvent actionEvent) {
        this.dispose();
    }

    public void onClear(ActionEvent actionEvent) {
        this.text.setText(null);
        this.log.clear();
    }

    public void onSave(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        File file = new File("errorlog.txt");
        jFileChooser.setSelectedFile(file);
        if (0 == jFileChooser.showSaveDialog(this)) {
            file = jFileChooser.getSelectedFile();
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                printWriter.println(this.text.getText());
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }
}

