/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "payeeview.h"
#include "editpayee.h"
#include "calcpayee.h"
#include "transactionwindow.h"

#include <kbanking.h>

#include <qevent.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qmessagebox.h>
#include <qlayout.h>

#include <gwenhywfar/debug.h>

#ifdef WIN32
# define strcasecmp stricmp
#endif

#define BUTTON_WIDTH 110


PayeeView::PayeeView(KBanking *kb,
                     QWidget* parent,
                     const char* name,
                     WFlags fl)
:PayeeViewUi(parent, name, fl), _app(kb) {
  assert(kb);

  // Manually create and add layout here because the .ui-generated
  // QGroupBox doesn't have one.
  payeeBox->setColumnLayout(0, Qt::Vertical );
  QBoxLayout *payeeBoxLayout = new QHBoxLayout(payeeBox->layout() );
  payeeBoxLayout->setAlignment( Qt::AlignTop );

  _payeeList=new PayeeListView(payeeBox, name);
  payeeBoxLayout->addWidget(_payeeList);

  _payeeList->setSelectionMode(QListView::Single);

  QObject::connect(kb->flagStaff(),
                   SIGNAL(signalPayeesUpdated()),
                   this, SLOT(slotUpdated()));

  QObject::connect(detailsButton, SIGNAL(clicked()),
                   this, SLOT(slotDetails()));
  QObject::connect(transactionButton, SIGNAL(clicked()),
                   this, SLOT(slotTransactions()));

  QObject::connect(newButton, SIGNAL(clicked()),
                   this, SLOT(slotNew()));
  QObject::connect(editButton, SIGNAL(clicked()),
                   this, SLOT(slotEdit()));
  QObject::connect(removeButton, SIGNAL(clicked()),
                   this, SLOT(slotRemove()));

  QObject::connect(calcButton, SIGNAL(clicked()),
                   this, SLOT(slotCalc()));
  QObject::connect(calcAllButton, SIGNAL(clicked()),
                   this, SLOT(slotCalcAll()));

}



PayeeView::~PayeeView(){
}



bool PayeeView::init(){
  GWEN_DB_NODE *dbConfig=NULL;
  int rv;
  std::string path;

  path="gui/views/payeeview/dynamic";
  rv=_app->loadAppSubConfig(path.c_str(),
			    &dbConfig,
			    0);
  if (rv<0) {
    DBG_INFO(0, "here (%d)", rv);
  }
  else {
    int i, j;
    const char *p;

    p=GWEN_DB_GetCharValue(dbConfig, "sortOrder", 0, "ascending");
    if (p) {
      if (strcasecmp(p, "ascending")==0)
        _payeeList->setSortOrder(Qt::Ascending);
      else
        if (strcasecmp(p, "descending")==0)
          _payeeList->setSortOrder(Qt::Descending);
    }
    i=GWEN_DB_GetIntValue(dbConfig, "sortColumn", 0, -1);
    if (i!=-1)
      _payeeList->setSortColumn(i);

    /* found settings */
    for (i=0; i<_payeeList->columns(); i++) {
      _payeeList->setColumnWidthMode(i, QListView::Manual);
      j=GWEN_DB_GetIntValue(dbConfig, "columns", i, -1);
      if (j!=-1)
        _payeeList->setColumnWidth(i, j);
    } /* for */
    GWEN_DB_Group_free(dbConfig);
  } /* if settings */

  _payeeList->addPayees(_app->getPayees());
  update();

  return true;
}



bool PayeeView::fini(){
  int i, j;
  GWEN_DB_NODE *dbConfig;
  std::string path;
  int rv;

  path="gui/views/payeeview/dynamic";
  dbConfig=GWEN_DB_Group_new("config");
  assert(dbConfig);

  switch(_payeeList->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "descending");
    break;
  default:
    break;
  }
  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                      "sortColumn", _payeeList->sortColumn());

  for (i=0; i<_payeeList->columns(); i++) {
    j=_payeeList->columnWidth(i);
    GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                        "columns", j);
  } /* for */

  rv=_app->saveAppSubConfig(path.c_str(),
			    dbConfig,
			    0);
  GWEN_DB_Group_free(dbConfig);
  if (rv<0) {
    DBG_INFO(0, "here (%d)", rv);
    return false;
  }

  return true;
}



void PayeeView::slotDetails(){
  Payee *p;

  std::list<Payee*> pl;
  pl=_payeeList->getSelectedPayees();
  if (pl.empty())
    return;
  p=pl.front();

  EditPayee ep(_app, p, true, this);
  ep.exec();
}



void PayeeView::slotNew(){
  Payee *p;

  p=new Payee();
  EditPayee ep(_app, p, false, this);
  if (ep.exec()!=QDialog::Accepted) {
    delete p;
  }
  else {
    if (!_app->addPayee(p)) {
      DBG_ERROR(0, "Could not add payee");
      delete p;
    }
    else {
      update();
    }
  }
}



void PayeeView::slotEdit(){
  Payee *p;

  std::list<Payee*> pl;
  pl=_payeeList->getSelectedPayees();
  if (pl.empty())
    return;
  p=pl.front();

  EditPayee ep(_app, p, false, this);
  if (ep.exec()==QDialog::Accepted)
    update();
}



void PayeeView::slotRemove(){
  Payee *p;

  std::list<Payee*> pl;
  pl=_payeeList->getSelectedPayees();
  if (pl.empty()) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No payee selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }
  p=pl.front();

  int res = QMessageBox::warning(this,
                           tr("Delete Payee"),
                           tr("<qt>"
                              "Do you really want to remove "
                              "the selected payee?"
                              "</qt>"),
                           QMessageBox::Yes,QMessageBox::No);
  if (res != 0 && res != QMessageBox::Yes)
    return;
  if (_app->removePayee(p)) {
    delete p;
    update();
  }

}



void PayeeView::slotCalc(){
  Payee *p;
  AB_VALUE *inValue;
  AB_VALUE *outValue;

  std::list<Payee*> pl;
  pl=_payeeList->getSelectedPayees();
  if (pl.empty()) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No payee selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }
  p=pl.front();

  inValue=AB_Value_new();
  outValue=AB_Value_new();

  CalculatePayee cp(_app, p, inValue, outValue);
  cp.show();
  if (cp.calculate()) {
    p->resetValues();
    p->addInValue(inValue);
    p->addOutValue(outValue);
    _app->flagStaff()->payeesUpdated();
  }
  AB_Value_free(outValue);
  AB_Value_free(inValue);

}



void PayeeView::slotCalcAll(){
  CalculatePayee cp(_app);
  cp.show();
  cp.calculateAll();
}



void PayeeView::slotTransactions() {
  Payee *p;
  std::list<Payee*> pl;

  pl=_payeeList->getSelectedPayees();
  if (pl.empty()) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No payee selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }
  p=pl.front();

  std::list<RefPointer<Transaction> > l;
  CalculatePayee cp(_app, p);
  cp.show();
  if (cp.getTransactions(l)) {
    TransactionWindow *tv;

    tv=new TransactionWindow(_app, l,
                             "PayeeTransactions",
                             0,
                             "TransactionWindow",
                             Qt::WDestructiveClose);
    tv->setCaption(tr("Transactions"));
    if (!tv->init()) {
      QMessageBox::critical(this,
                            tr("Internal Error"),
                            tr("Could not initialize transaction view."),
                            tr("Dismiss"), QString::null);
      delete tv;
      return;
    }
    tv->show();
  }

}






void PayeeView::update() {
  _payeeList->clear();
  _payeeList->addPayees(_app->getPayees());
}



void PayeeView::slotUpdated() {
  update();
}








