/*
#
# NJP.cpp
#
# Duane Maxwell
# (c) Copyright Linspire. Inc, 2005
#
# This is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# Thisis distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
*/

#ifndef __NJBCPP__
#define __NJBCPP__

#define LIBNJB_VERSION_2

#include "NJB.h"
#include <string.h>

char *NJBFrame::CODEC_MP3 = NJB_CODEC_MP3;
char *NJBFrame::CODEC_WMA = NJB_CODEC_WMA;
char *NJBFrame::CODEC_WAV = NJB_CODEC_WAV;

char *NJBFrame::SIZE 	= FR_SIZE; 	/**< Filesize metadata frame */
char *NJBFrame::LENGTH	= FR_LENGTH;	/**< Length metadata frame (in seconds) */
char *NJBFrame::CODEC	= FR_CODEC;	/**< Codec metadata frame */
char *NJBFrame::TITLE	= FR_TITLE;	/**< Title metadata frame */
char *NJBFrame::ALBUM	= FR_ALBUM;	/**< Album metadata frame */
char *NJBFrame::GENRE 	= FR_GENRE;	/**< Genre metadata frame */
char *NJBFrame::ARTIST	= FR_ARTIST;	/**< Artist metadata frame */
char *NJBFrame::TRACK	= FR_TRACK;	/**< Track number metadata frame */
char *NJBFrame::FNAME	= FR_FNAME;	/**< File name metadata frame */
char *NJBFrame::YEAR	= FR_YEAR;	/**< Year metadata frame */
char *NJBFrame::PROTECTED = FR_PROTECTED;	/**< Copy protected track metadata frame */
char *NJBFrame::BITRATE	=  FR_BITRATE;	/**< Bitrate metadata frame */
char *NJBFrame::COMMENT	= FR_COMMENT;	/**< Comment metadata frame */
char *NJBFrame::FOLDER	= FR_FOLDER;	/**< Folder name metadata frame */

NJBFrame::NJBFrame(njb_songid_frame_t *f) { frame = f; };
NJBFrame::NJBFrame(const char *label,const char *value) { frame = NJB_Songid_Frame_New_String(label,value);};
//NJBFrame::NJBFrame(const char *label,u_int16_t value) { frame = NJB_Songid_Frame_New_Uint16(label,value); };
NJBFrame::NJBFrame(const char *label,u_int32_t value) {
	if (strcmp(FR_LENGTH,label)==0 ||
	   strcmp(FR_TRACK,label)==0 ||
	   strcmp(FR_YEAR,label)==0 ||
	   strcmp(FR_PROTECTED,label)==0)
	   	frame = NJB_Songid_Frame_New_Uint16(label,value);
	else
		frame = NJB_Songid_Frame_New_Uint32(label,value);
};
NJBFrame::~NJBFrame() { };
void NJBFrame::Destroy(void) { NJB_Songid_Frame_Destroy(frame); };
char *NJBFrame::GetLabel(void) { return frame->label; };
int NJBFrame::GetType(void) { return frame->type; };
char *NJBFrame::GetStringValue(void) { return frame->data.strval; };
u_int8_t NJBFrame::GetInt8Value(void) { return frame->data.u_int8_val; };
u_int16_t NJBFrame::GetInt16Value(void) { return frame->data.u_int16_val; };
u_int32_t NJBFrame::GetInt32Value(void) { return frame->data.u_int32_val; };
u_int64_t NJBFrame::GetInt64Value(void) { return frame->data.u_int64_val; };
NJBFrame *NJBFrame::Next(void) { if (frame->next) return new NJBFrame(frame->next); else return NULL; };


NJBSong::NJBSong(void) { song = NJB_Songid_New(); };
NJBSong::NJBSong(njb_songid_t *s) { song = s; };
NJBSong::~NJBSong() { };
void NJBSong::Destroy(void) { NJB_Songid_Destroy(song); }
void NJBSong::AddFrame(NJBFrame *frame) { NJB_Songid_Addframe(song,frame->frame);};
void NJBSong::ResetGetFrame(void) { NJB_Songid_Reset_Getframe(song); };
NJBFrame *NJBSong::GetFrame(void) {
	njb_songid_frame_t *frame = NJB_Songid_Getframe(song);
	if (frame) return new NJBFrame(frame); else return NULL;
};
NJBFrame *NJBSong::FindFrame(const char *label) { return new NJBFrame(NJB_Songid_Findframe(song,label)); };
u_int32_t NJBSong::GetTrackID(void) { return song->trid; };
NJBSong *NJBSong::Next(void) { if (song->next) return new NJBSong(song->next); else return NULL; };

NJBPlaylistTrack::NJBPlaylistTrack(njb_playlist_track_t *t) { track = t; };
NJBPlaylistTrack::NJBPlaylistTrack(int trackID) { track = NJB_Playlist_Track_New(trackID); };
NJBPlaylistTrack::~NJBPlaylistTrack() { }
void NJBPlaylistTrack::Destroy(void) { NJB_Playlist_Track_Destroy(track); };
u_int32_t NJBPlaylistTrack::GetTrackID(void) { return track->trackid; };
NJBPlaylistTrack *NJBPlaylistTrack::Next(void) { if (track->next) return new NJBPlaylistTrack(track->next); else return NULL; };
NJBPlaylistTrack *NJBPlaylistTrack::Previous(void) { if (track->prev) return new NJBPlaylistTrack(track->prev); else return NULL; };


NJBPlaylist::NJBPlaylist(njb_playlist_t *p) { playlist = p; ResetGetTrack(); };
NJBPlaylist::NJBPlaylist() { playlist = NJB_Playlist_New(); ResetGetTrack(); };
NJBPlaylist::~NJBPlaylist() {  };
void NJBPlaylist::Destroy(void) { NJB_Playlist_Destroy(playlist); };
void NJBPlaylist::AddTrack(NJBPlaylistTrack *track,unsigned int position) { NJB_Playlist_Addtrack(playlist,track->track,position); }
void NJBPlaylist::DeleteTrack(unsigned int position) { NJB_Playlist_Deltrack(playlist,position); };
char *NJBPlaylist::GetName(void) { return playlist->name; };
u_int32_t NJBPlaylist::GetNumTracks(void) { return playlist->ntracks; };
u_int32_t NJBPlaylist::GetID(void) { return playlist->plid; };
void NJBPlaylist::ResetGetTrack(void) { NJB_Playlist_Reset_Gettrack(playlist); };
NJBPlaylistTrack *NJBPlaylist::GetTrack(void) {
	njb_playlist_track_t *track = NJB_Playlist_Gettrack(playlist);
	if (track) return new NJBPlaylistTrack(track); else return NULL;
};
int NJBPlaylist::SetName(const char *name) { return NJB_Playlist_Set_Name(playlist,name); };

NJBDatafileTag::NJBDatafileTag() {};
NJBDatafileTag::NJBDatafileTag(njb_datafile_t *d) { datafile = d; };
NJBDatafileTag::~NJBDatafileTag() { }
void NJBDatafileTag::Destroy(void) { NJB_Datafile_Destroy(datafile); };

NJBEAXType::NJBEAXType() { };
NJBEAXType::NJBEAXType(njb_eax_t *e) { eax = e; };
NJBEAXType::~NJBEAXType() { }
void NJBEAXType::Destroy(void) { NJB_Destroy_EAX_Type(eax); };


NJBTime::NJBTime() { };
NJBTime::NJBTime(njb_time_t *t) { time = t; };
NJBTime::~NJBTime() { }
void NJBTime::Destroy(void) { NJB_Destroy_Time(time); };
void NJBTime::Time(int *year,int *month,int *day,int *weekday,int *hours,int *minutes,int *seconds) {
	*year = time->year;
	*month = time->month;
	*day = time->day;
	*weekday = time->weekday;
	*hours = time->hours;
	*minutes = time->minutes;
	*seconds = time->seconds;
};

NJBDevice::NJBDevice(void) {
	njb_t njbs[NJB_MAX_DEVICES];
	int count;
	NJB_Discover(njbs,NJB_MAX_DEVICES,&count);
	njb = &njbs[0];
};
NJBDevice::NJBDevice(njb_t *n) { njb = n; };
int NJBDevice::Open(void) { return NJB_Open(njb); };
void NJBDevice::Close(void) { NJB_Close(njb); };
int NJBDevice::Capture(void) { return NJB_Capture(njb); };
int NJBDevice::Release(void) { return NJB_Release(njb); };
void NJBDevice::Ping(void) { NJB_Ping(njb); };
int NJBDevice::GetType(void) { return njb->device_type; };
int NJBDevice::GetUpdated(void) { return njb->updated; };
char *NJBDevice::GetSDMI(void) {
	return "";
}
#ifdef LIBNJB_VERSION_2
void NJBDevice::GetFWRevision(int *major, int *minor, int *revision) {
        u_int8_t mj,mn,re;
        NJB_Get_Firmware_Revision(njb,&mj,&mn,&re);
        *major = mj;
        *minor = mn;
        *revision = re;
}

void NJBDevice::GetHWRevision(int *major, int *minor, int *revision) {
        u_int8_t mj,mn,re;
        NJB_Get_Hardware_Revision(njb,&mj,&mn,&re);
        *major = mj;
        *minor = mn;
        *revision = re;
}

char *NJBDevice::GetProductName() {
        return (char *)NJB_Get_Device_Name(njb,njb->device_type);
}

int NJBDevice::GetPower() {
        return NJB_Get_Battery_Level(njb);
}
#else
void NJBDevice::GetFWRevision(int *major,int *minor, int *revision) {
	*major = njb->njbid->fwMajor;
	*minor = njb->njbid->fwMinor;
	*revision = njb->njbid->fwRel;
}
void NJBDevice::GetHWRevision(int *major,int *minor, int *revision) {
	*major = njb->njbid->hwMajor;
	*minor = njb->njbid->hwMinor;
	*revision = njb->njbid->hwRel;
}
char *NJBDevice::GetProductName() { return njb->njbid->productName; };
int NJBDevice::GetPower() { return njb->njbid->power; };
#endif

int NJBDevice::GetDiskUsage(u_int64_t *btotal, u_int64_t *bfree) { return NJB_Get_Disk_Usage(njb,btotal,bfree); };
char *NJBDevice::GetOwnerString(void) { return NJB_Get_Owner_String(njb); };
int NJBDevice::SetOwnerString(char *ownerName) { return NJB_Set_Owner_String(njb,ownerName); };
int NJBDevice::GetBitmapDimensions(int *x,int *y,int *bytes) { return NJB_Get_Bitmap_Dimensions(njb,x,y,bytes); }
int NJBDevice::SetBitMap(unsigned char *bitmap) { return NJB_Set_Bitmap(njb,bitmap); };
void NJBDevice::GetExtendedTags(int extended) { NJB_Get_Extended_Tags(njb,extended); };

void NJBDevice::ResetGetTrackTag(void) { NJB_Reset_Get_Track_Tag(njb); };
NJBSong *NJBDevice::GetTrackTag(void) {
	njb_songid_t *song = NJB_Get_Track_Tag(njb);
	if (song) return new NJBSong(song); else return NULL;
};
int NJBDevice::ReplaceTrackTag(u_int32_t trackID, NJBSong *song) { return NJB_Replace_Track_Tag(njb,trackID,song->song); };
int NJBDevice::GetTrack(u_int32_t trackID,u_int32_t size,const char *path) {
	return NJB_Get_Track(njb,trackID,size,path,0,0);
};
int NJBDevice::GetTrack(u_int32_t trackid, u_int32_t size,const char *path, NJB_Xfer_Callback *callback, void *data) {
	return NJB_Get_Track(njb,trackid,size,path,callback,data);
}
int NJBDevice::GetTrackFile(u_int32_t trackID,u_int32_t size,int fd) {
	return NJB_Get_Track_fd(njb,trackID,size,fd,0,0);
};
int NJBDevice::GetTrackFile(u_int32_t trackID,u_int32_t size,int fd,NJB_Xfer_Callback *callback, void *data) {
	return NJB_Get_Track_fd(njb,trackID,size,fd,callback,data);
};
int NJBDevice::SendTrack(const char *path,NJBSong *song,unsigned int *trackID) {
	return NJB_Send_Track(njb,path,song->song,0,0,trackID);
};
int NJBDevice::SendTrack(const char *path,NJBSong *song,NJB_Xfer_Callback *callback, void *data,unsigned int *trackID) {
	return NJB_Send_Track (njb,path, song->song, callback, data, trackID);
}
int NJBDevice::DeleteTrack(u_int32_t trackID) { return NJB_Delete_Track(njb,trackID); };

void NJBDevice::ResetGetPlaylist(void) { NJB_Reset_Get_Playlist(njb); };
NJBPlaylist *NJBDevice::GetPlaylist(void) {
	njb_playlist_t *playlist = NJB_Get_Playlist(njb);
	if (playlist) return new NJBPlaylist(playlist); else return NULL;
};
int NJBDevice::DeletePlaylist(u_int32_t playlistID) { return NJB_Delete_Playlist(njb,playlistID); };
int NJBDevice::UpdatePlaylist(NJBPlaylist *playlist) { return NJB_Update_Playlist(njb,playlist->playlist); };

void NJBDevice::ResetGetDatafileTag(void) { NJB_Reset_Get_Datafile_Tag(njb); };
NJBDatafileTag *NJBDevice::GetDatafileTag(void) {
	njb_datafile_t *file = NJB_Get_Datafile_Tag(njb);
	if (file) return new NJBDatafileTag(file); else return NULL;
};
int NJBDevice::SendDatafile(const char *path, const char *name, const char *folder,unsigned int *fileID)
	{ return NJB_Send_File(njb,path,name,folder,0,0,fileID); };
int NJBDevice::DeleteDatafile(u_int32_t fileID) { return NJB_Delete_Datafile(njb,fileID); };
int NJBDevice::CreateFolder(const char *name, unsigned int *folderID) { return NJB_Create_Folder(njb,name,folderID); };

void NJBDevice::ResetGetEAXType(void) { NJB_Reset_Get_EAX_Type(njb); };
NJBEAXType *NJBDevice::GetEAXType(void) {
	njb_eax_t *eax = NJB_Get_EAX_Type(njb);
	if (eax) return new NJBEAXType(eax); else return NULL;
};
void NJBDevice::AdjustEAX(u_int16_t eaxID,u_int16_t patchIndex, int16_t scaleValue) { NJB_Adjust_EAX(njb,eaxID,patchIndex,scaleValue); };

NJBTime NJBDevice::GetTime(void) { return NJBTime(NJB_Get_Time(njb)); };

int NJBDevice::PlayTrack(u_int32_t trackID) { return NJB_Play_Track(njb,trackID); };
int NJBDevice::QueueTrack(u_int32_t trackID) { return NJB_Queue_Track(njb,trackID); };
int NJBDevice::StopPlay(void) { return NJB_Stop_Play(njb); };
int NJBDevice::PausePlay(void) { return NJB_Pause_Play(njb); };
int NJBDevice::ResumePlay(void) { return NJB_Resume_Play(njb); };
int NJBDevice::SeekTrack(u_int32_t position) { return NJB_Seek_Track(njb,position); };
int NJBDevice::ElapsedTime(u_int16_t *elapsed, int *change) { return NJB_Elapsed_Time(njb,elapsed,change); };

int NJBDevice::ErrorPending(void) { return NJB_Error_Pending(njb); };
void NJBDevice::ResetError(void) { NJB_Error_Reset_Geterror(njb); };
char *NJBDevice::GetError(void) { return (char *)NJB_Error_Geterror(njb); }

#endif
