package org.apache.lucene.xmlparser.builders;

import java.util.ArrayList;

import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.xmlparser.DOMUtils;
import org.apache.lucene.xmlparser.ParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
public class SpanNearBuilder extends SpanBuilderBase
{
	SpanQueryBuilder factory;
	public SpanNearBuilder(SpanQueryBuilder factory)
	{
		this.factory=factory;
	}
	
	public SpanQuery getSpanQuery(Element e) throws ParserException
	{
 		String slopString=DOMUtils.getAttributeOrFail(e,"slop");
  		int slop=Integer.parseInt(slopString);
		boolean inOrder=DOMUtils.getAttribute(e,"inOrder",false);
		ArrayList spans=new ArrayList();
		for (Node kid = e.getFirstChild(); kid != null; kid = kid.getNextSibling())
		{
				if (kid.getNodeType() == Node.ELEMENT_NODE) 
				{
					spans.add(factory.getSpanQuery((Element) kid));
				}
		}
		SpanQuery[] spanQueries=(SpanQuery[]) spans.toArray(new SpanQuery[spans.size()]);
		SpanNearQuery snq=new SpanNearQuery(spanQueries,slop,inOrder);
		return snq;
	}

}
