# -*- coding: latin-1 -*-
# Traitement de certaines tables africaines.
# Copyright  1999, 2000, 2002 Progiciels Bourbeau-Pinard inc.
# Franois Pinard <pinard@iro.umontreal.ca>, 1997.  */

import recode

declares = [
    ('BPI-102', 'AFRFUL-102-BPI_OCIL', 'bambara', 'bra', 'ewondo', 'fulfulde'),
    ('BPI-104', 'AFRLIN-104-BPI_OCIL', 'lingala', 'lin', 'sango', 'wolof'),
    'BPI-106',
    'BPI-108',
    'BPI-110',
    'BPI-112',
    ]

# Bambara, Ewondo, Fulfulde.

class BPI_102(recode.GenericStep):
    internal_coding = 'BPI-102'
    external_coding = recode.UNICODE_STRING
    data = [
        (161, u'\u0181'),
        (162, u'\u018A'),
        (163, u'\u0194'),
        (164, u'\u0198'),
        (165, u'\u01A4'),
        (166, u'\u01AC'),
        (167, u'\u01A9'),
        (168, u'\u019D'),
        (169, u'\u014A'),
        (170, u'\u0189'),
        (172, u'\u0191'),
        (174, u'\u01B3'),
        (175, u'\u0193'),
        (177, u'\u0253'),
        (178, u'\u0257'),
        (179, u'\u0263'),
        (180, u'\u0199'),
        (181, u'\u01A5'),
        (182, u'\u01AD'),
        (183, u'\u0283'),
        (184, u'\u0272'),
        (185, u'\u014B'),
        (186, u'\u0256'),
        (188, u'\u0192'),
        (189, u'\u0294'),
        (190, u'\u01B4'),
        (191, u'\u0260'),
        (197, u'\u018E'),
        (208, u'\u0190'),
        (215, u'\u0152'),
        (216, u'\u0186'),
        (221, u'\u018E\u0301'),
        (222, u'\u0186\u0301'),
        (223, u'\u01B2'),
        (229, u'\u01DD'),
        (240, u'\u025B'),
        (247, u'\u0153'),
        (248, u'\u0254'),
        (253, u'\u01DD\u0301'),
        (254, u'\u0254\u0301'),
        (255, u'\u028B'),
        ]

# Linguala, Sango, Wolof.

class BPI_104(recode.GenericStep):
    internal_coding = 'BPI-104'
    external_coding = recode.UNICODE_STRING
    data = [
        (161, u'\u0190\u0300'),
        (162, u'\u0190\u0301'),
        (163, u'\u0190\u0302'),
        (164, u'\u0190\u030C'),
        (165, u'\u0186\u0300'),
        (166, u'\u0186\u0301'),
        (167, u'\u0186\u0302'),
        (168, u'\u019D'),
        (169, u'\u014A'),
        (170, u'\u004E\u0302'),
        (172, u'\u004E\u0308'),
        (174, u'\u01B3'),
        (175, u'\u0186\u030C'),
        (177, u'\u025B\u0300'),
        (178, u'\u025B\u0301'),
        (179, u'\u025B\u0302'),
        (180, u'\u025B\u030C'),
        (181, u'\u0254\u0300'),
        (182, u'\u0254\u0301'),
        (183, u'\u0254\u0302'),
        (184, u'\u0272'),
        (185, u'\u014B'),
        (186, u'\u006E\u0302'),
        (188, u'\u006E\u0308'),
        (189, u'\u0294'),
        (190, u'\u01B4'),
        (191, u'\u0254\u030C'),
        (195, u'\u01CD'),
        (197, u'\u018E'),
        (208, u'\u0190'),
        (213, u'\u01D1'),
        (215, u'\u0152'),
        (216, u'\u0186'),
        (221, u'\u011A'),
        (222, u'\u01CF'),
        (223, u'\u01D3'),
        (227, u'\u01CE'),
        (229, u'\u01DD'),
        (240, u'\u025B'),
        (245, u'\u01D2'),
        (247, u'\u0153'),
        (248, u'\u0254'),
        (253, u'\u011B'),
        (254, u'\u01D0'),
        (255, u'\u01D4'),
        ]

# Mali:  Bambara, Bobo, Bozo, Dogon, Fulfulde, Fuuta-jalon, Minyanka, Soninke.
# Niger: Fulfulde, Hausa.
# Sngal: Joola, Mande, Pulaar (fulfulde), Sereer, Sooninke, Wolof.

class BPI_106(recode.GenericStep):
    internal_coding = 'BPI-106'
    external_coding = recode.UNICODE_STRING
    data = [
        (161, u'\u01A4'),
        (162, u'\u01AC'),
        (163, u'\u0198'),
        (164, u'\u0181'),
        (165, u'\u018A'),
        (166, u'\u0160'),
        (167, u'\u0194'),
        (168, u'\u0161'),
        (169, u'\u019D'),
        (170, u'\u014A'),
        (172, u'\u0294'),
        (173, u'\u00AD'),
        (174, u'\u0191'),
        (175, u'\u0187'),
        (177, u'\u01A5'),
        (178, u'\u01AD'),
        (179, u'\u0199'),
        (180, u'\u0253'),
        (181, u'\u0257'),
        (184, u'\u0263'),
        (185, u'\u0272'),
        (186, u'\u014B'),
        (188, u'\u0152'),
        (189, u'\u0153'),
        (190, u'\u0192'),
        (191, u'\u0188'),
        (195, u'\u01AE'),
        (196, u'\u01B3'),
        (197, u'\u0190'),
        (208, u'\u0189'),
        (213, u'\u018E'),
        (214, u'\u0193'),
        (216, u'\u0186'),
        (221, u'\u01B2'),
        (222, u'\u01A9'),
        (223, u'\u01B7'),
        (227, u'\u0288'),
        (228, u'\u01B4'),
        (229, u'\u025B'),
        (240, u'\u0256'),
        (245, u'\u01DD'),
        (246, u'\u0260'),
        (248, u'\u0254'),
        (253, u'\u028B'),
        (254, u'\u0283'),
        (255, u'\u0292'),
        ]

# Ewondo, Lingla, Munukutuba (Kikongo), Sang.

class BPI_108(recode.GenericStep):
    internal_coding = 'BPI-108'
    external_coding = recode.UNICODE_STRING
    data = [
        (161, u'\u0190\u0300'),
        (162, u'\u0190\u0301'),
        (163, u'\u0190\u0302'),
        (164, u'\u0190\u030C'),
        (165, u'\u0186\u0300'),
        (166, u'\u0186\u0301'),
        (167, u'\u0186\u0302'),
        (168, u'\u0254\u0301'),
        (169, u'\u019D'),
        (170, u'\u014A'),
        (172, u'\u01B3'),
        (174, u'\u0254\u0302'),
        (175, u'\u0186\u030C'),
        (177, u'\u025B\u0300'),
        (178, u'\u025B\u0301'),
        (179, u'\u025B\u0302'),
        (180, u'\u025B\u030C'),
        (181, u'\u0254\u0300'),
        (183, u'\u01B4'),
        (184, u'\u018E\u0301'),
        (185, u'\u0272'),
        (186, u'\u014B'),
        (188, u'\u0152'),
        (189, u'\u0153'),
        (190, u'\u01DD\u0301'),
        (191, u'\u0254\u030C'),
        (195, u'\u01CD'),
        (197, u'\u018E'),
        (208, u'\u0190'),
        (213, u'\u01D1'),
        (216, u'\u0186'),
        (221, u'\u011A'),
        (222, u'\u01CF'),
        (223, u'\u01D3'),
        (227, u'\u01CE'),
        (229, u'\u01DD'),
        (240, u'\u025B'),
        (245, u'\u01D2'),
        (248, u'\u0254'),
        (253, u'\u011B'),
        (254, u'\u01D0'),
        (255, u'\u01D4'),
        ]

# Djerma, Zarma, Songhoy, Songhai-koroboro.

class BPI_110(recode.GenericStep):
    internal_coding = 'BPI-110'
    external_coding = recode.UNICODE_STRING
    data = [
        (161, u'\u0190\u0300'),
        (162, u'\u0190\u0301'),
        (163, u'\u0190\u0302'),
        (164, u'\u0190\u030C'),
        (165, u'\u0186\u0300'),
        (166, u'\u0186\u0301'),
        (167, u'\u0186\u0302'),
        (168, u'\u0254\u0301'),
        (169, u'\u019D'),
        (170, u'\u014A'),
        (172, u'\u0160'),
        (174, u'\u0254\u0302'),
        (175, u'\u0186\u030C'),
        (177, u'\u025B\u0300'),
        (178, u'\u025B\u0301'),
        (179, u'\u025B\u0302'),
        (180, u'\u025B\u030C'),
        (181, u'\u0254\u0300'),
        (183, u'\u0161'),
        (184, u'\u0128'),
        (185, u'\u0272'),
        (186, u'\u014B'),
        (188, u'\u0152'),
        (189, u'\u0153'),
        (190, u'\u0129'),
        (191, u'\u0254\u030C'),
        (196, u'\u01CD'),
        (197, u'\u1EBC'),
        (208, u'\u0190'),
        (209, u'\u0168'),
        (214, u'\u01D1'),
        (216, u'\u0186'),
        (221, u'\u011A'),
        (222, u'\u01CF'),
        (223, u'\u01D3'),
        (228, u'\u01CE'),
        (229, u'\u1EBD'),
        (240, u'\u025B'),
        (241, u'\u0169'),
        (246, u'\u01D2'),
        (248, u'\u0254'),
        (253, u'\u011B'),
        (254, u'\u01D0'),
        (255, u'\u01D4'),
        ]

# Tamasheq, Tamajeq

class BPI_112(recode.GenericStep):
    internal_coding = 'BPI-112'
    external_coding = recode.UNICODE_STRING
    data = [
        (161, u'\u01A4'),
        (162, u'\u1E6C'),
        (163, u'\u0198'),
        (164, u'\u1E04'),
        (165, u'\u1E0C'),
        (166, u'\u0160'),
        (167, u'\u0194'),
        (168, u'\u0161'),
        (169, u'\u019D'),
        (170, u'\u014A'),
        (172, u'\u0295'),
        (174, u'\u1E24'),
        (175, u'\u1E36'),
        (177, u'\u01A5'),
        (178, u'\u1E6D'),
        (179, u'\u0199'),
        (180, u'\u1E05'),
        (181, u'\u1E0D'),
        (184, u'\u0263'),
        (185, u'\u0272'),
        (186, u'\u014B'),
        (188, u'\u0152'),
        (189, u'\u0153'),
        (190, u'\u1E25'),
        (191, u'\u1E37'),
        (195, u'\u0102'),
        (196, u'\u018E'),
        (197, u'\u0190'),
        (208, u'\u0189'),
        (213, u'\u1E62'),
        (214, u'\u1E92'),
        (216, u'\u0186'),
        (221, u'\u017D'),
        (222, u'\u01A9'),
        (223, u'\u01B7'),
        (227, u'\u0103'),
        (228, u'\u01DD'),
        (229, u'\u025B'),
        (240, u'\u0256'),
        (245, u'\u1E63'),
        (246, u'\u1E93'),
        (248, u'\u0254'),
        (253, u'\u017E'),
        (254, u'\u0283'),
        (255, u'\u0292'),
        ]
