#!/usr/bin/python
# -*- coding: utf-8 -*-

#  Copyright © 2009, 2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gtk

from .debug import *


test_int = 0
#@debug_func
def debug_keys(unused_widget, event, application):
    global test_int
    
    #debug(event)
    #if event.state & gdk.SHIFT_MASK:
    #    shifted = 1

    if event.keyval == gtk.keysyms.p:
        import code
        globals_ = globals()
        globals_['application'] = application
        console = code.InteractiveConsole(locals=globals_)
        console.push('import pythonstartup')
        console.interact()
        console.push('del pythonstartup')
        return True
    elif event.keyval == gtk.keysyms.t:
        application.on_colour_select(None)
        return True
    elif event.keyval == gtk.keysyms.d:
        #XXX
        cubestate = application.current_movement.current_cube_state
        cubestate.dump()
        return True
    elif event.keyval == gtk.keysyms.o:
        dump_objects(application)
        return True
    elif gtk.keysyms._0 <= event.keyval <= gtk.keysyms._9:
        context1 = application.statusbar.get_context_id("test1")
        context2 = application.statusbar.get_context_id("test2")
        if event.keyval == gtk.keysyms._1:
            test_int += 1
            mesg_id = application.statusbar.push(context1, 'Test %d' % test_int)
        elif event.keyval == gtk.keysyms._2:
            mesg_id = application.statusbar.pop(context1)
        elif event.keyval == gtk.keysyms._3:
            test_int += 1
            mesg_id = application.statusbar.push(context2, 'Test %d' % test_int)
        elif event.keyval == gtk.keysyms._4:
            mesg_id = application.statusbar.pop(context2)
        debug('- context', context1, context2, 'mesg_id', mesg_id or '-', 'value', test_int)
        return True
    #debug('debug_keys not handled')
    return False

def dump_objects(application):
    widgets1 = []
    
    # find all objects in GtkBuilder UI file
    for o in application.ui_xml.get_objects():
        if hasattr(o, 'get_name'):
            widgets1.append(o)
    
    # find all object in the main window
    widgets2 = [application.window]
    menu_up = {}
    for o in widgets2:
        if hasattr(o, 'get_children'):
            widgets2 += o.get_children()
        if hasattr(o, 'get_submenu'):
            m = o.get_submenu()
            if m:
                menu_up[m] = o
                widgets2.append(m)
    
    # compute names from widgets
    widgets = {}
    for w in widgets1 + widgets2:
        if hasattr(w, 'get_name'):
            n = w.get_name()
        else:
            n = None
        if hasattr(w, 'get_accessible'):
            a = w.get_accessible().get_name()
        else:
            a = None
        if a:
            if isinstance(w, gtk.MenuItem):
                if w.get_parent() in menu_up:
                    pw = menu_up[w.get_parent()]
                    pn, pa = widgets[pw]
                    a = pa + ';mnu' + a
                else:
                    a = 'mnu' + a
            elif isinstance(w, gtk.SpinButton):
                a = 'sbtn' + a
            elif isinstance(w, gtk.Button):
                a = 'btn' + a
                if n == 'GtkButton':
                    n = w.get_parent().get_name()
            elif isinstance(w, gtk.Entry):
                a = 'txt' + a
            elif isinstance(w, gtk.TreeView):
                a = 'ttbl' + a
            elif isinstance(w, gtk.Toolbar):
                a = 'tbar' + a
            elif isinstance(w, gtk.Statusbar):
                a = 'stat' + a
            elif isinstance(w, gtk.Dialog):
                a = 'dlg' + a
            elif isinstance(w, gtk.Window):
                pass
            else:
                a = '???' + a
            a = a.replace(' ','')
        widgets[w] = (n, a)
        
    wnames = sorted((n, a, w) for w, (n, a) in widgets.items())
    
    print '--- Objects ---'
    for n, a, w in wnames:
        pwid = id(w.get_parent()) if hasattr(w,'get_parent') else '     ---'
        print id(w), pwid, n, a
    print '--- Objects UI ---'
    for n, a, w in wnames:
        if '_' in n and n.replace('_','').isalnum():
            if a:
                print '%s = %r' % (n.upper(), a)
        
    
    
    
    
    
