#-*- coding:utf-8 -*-

#  Pybik -- A 3 dimensional magic cube game.
#  Copyright © 2009, 2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Ported from GNUbik
# Original filename: menus.c
# Original copyright and license:
#/*
#    GNUbik -- A 3 dimensional magic cube game.
#    Copyright (C) 2003, 2004  John Darrington
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License,  or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#*/


import gtk

from . import config
from .confstore import confstore


_preferencesdialog = None
def preferencesdialog(application):
    global _preferencesdialog
    if _preferencesdialog is None:
        _preferencesdialog = PreferencesDialog(application)
    _preferencesdialog.run()
    
class PreferencesDialog (object):
    def __init__(self, application):
        self.app = application
        self.dialog = application.ui_xml.get_object('dialog_preferences')
        
        self.application = application
        self.permit_callbacks = False
        
        self.button_size = application.ui_xml.get_object('button_size')
        self.button_size.set_value(confstore.dimension)
        self.button_size.connect("changed", self.on_size_changed)
        
        self.hscale_animspeed = application.ui_xml.get_object('hscale_animspeed')
        self.hscale_animspeed.set_value(confstore.frameQty)
        self.hscale_animspeed.connect("value-changed", self.on_hscale_animspeed_value_changed)
        
        self.button_lighting = application.ui_xml.get_object('button_lighting')
        self.button_lighting.set_active(confstore.lighting)
        self.button_lighting.connect("toggled", self.on_set_lighting)
        
        self.permit_callbacks = True
        confstore.callbacks.append(self.on_confstore_changed)
        
    def run(self):
        self.dialog.run()
        self.confirm_preferences()
        #self.dialog.destroy ()
        self.dialog.hide()
        
    def on_confstore_changed(self, key, *unused_subkeys):
        self.permit_callbacks = False
        if key == 'dimension':
            self.button_size.set_value(confstore.dimension)
        elif key == 'frameQty':
            self.hscale_animspeed.set_value(confstore.frameQty)
        elif key == 'lighting':
            self.button_lighting.set_active(confstore.lighting)
        self.permit_callbacks = True
        
    def on_yesnoresp(self, dialog, resp):
        if resp == gtk.RESPONSE_YES:
            self.application.request_new_game(None, confstore.dimension)
        dialog.destroy()

    # Close the preferences window,  and update all the necessary values
    def confirm_preferences(self):
        if confstore.dimension != self.application.current_movement.current_cube_state.dimension:
            dialog = gtk.MessageDialog(self.app.window,
                         gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                         gtk.MESSAGE_QUESTION, gtk.BUTTONS_YES_NO,
                         _("The Dimension of the cube has changed.\nStart cube with new settings?"))
            dialog.connect("response", self.on_yesnoresp)
            dialog.show_all()

    def on_size_changed(self, editable):
        if self.permit_callbacks:
            str_ = editable.get_chars(0, -1)
            confstore.dimension = int(str_ or 1)

    def on_hscale_animspeed_value_changed(self, widget):
        if self.permit_callbacks:
            confstore.frameQty = int(widget.get_value())

    def on_set_lighting(self, toggle_button):
        if self.permit_callbacks:
            confstore.lighting = toggle_button.get_active()
        

def show_about(toplevel):
    about = gtk.AboutDialog()
    about.set_transient_for(toplevel)
    about.set_name(config.get_appname())
    about.set_version(config.VERSION)
    about.set_copyright(config.COPYRIGHT)
    about.set_license('\n\n'.join(config.get_license()))
    about.set_wrap_license(True)
    about.set_comments(config.get_description())
    about.set_authors(config.AUTHORS)
    about.set_website(config.WEBSITE)
    about.set_website_label(config.get_website_label())
    about.set_logo_icon_name("pybik")
    #about.set_translator_credits(_("translator-credits"))
    about.connect("response", lambda d, r: d.destroy())
    about.show()

