#-*- coding:utf-8 -*-

#  Pybik -- A 3 dimensional magic cube game.
#  Copyright © 2009, 2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Ported from GNUbik
# Original filename: colour-sel.c
# Original copyright and license:
#/*
#  GNUbik -- A 3 dimensional magic cube game.
#  Copyright (C) 2003  John Darrington
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License,  or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#*/


import gobject
import gtk
from gtk import gdk

from .debug import *
from . import textures
from .confstore import confstore, UNDEFINED, COLORED, IMAGED, TILED, MOSAIC


BOX_PADDING = 10


@debug_func
def open_ColorSelectDialog(toplevel):
    if ColorSelectDialog.this_dlg:
        ColorSelectDialog.this_dlg.reinit(toplevel)
    else:
        ColorSelectDialog(toplevel)


class ColorSelectDialog (object):
    this_dlg = None
    
    def __init__(self, toplevel):
        assert self.this_dlg == None
        ColorSelectDialog.this_dlg = self
        
        self.dialog = toplevel.ui_xml.get_object('dialog_edit_colors')
        self.dialog.connect ("response", lambda w, r: w.hide())
        self.dialog.connect ("delete-event", lambda *a: True)
        
        self.active_face = None
        self.create_face_selector(toplevel)
        
        self.button_color = toplevel.ui_xml.get_object('colorbutton_face')
        self.button_color.connect ("color-set", self.on_button_color_set)
        
        self.create_pattern_selector(toplevel)
        
        self.button_image = toplevel.ui_xml.get_object('filechooserbutton_image')
        self.button_image.connect ("file-set", self.on_button_image_file_set)
        self.button_image_tile = toplevel.ui_xml.get_object('radiobutton_tile')
        self.button_image_mosaic = toplevel.ui_xml.get_object('radiobutton_mosaic')
        self.button_image_tile.connect ("toggled", self.on_button_image_distr_toggled, TILED)
        self.button_image_mosaic.connect ("toggled", self.on_button_image_distr_toggled, MOSAIC)
        self.button_image_group = gtk.RadioButton.get_group (self.button_image_mosaic)
        
        self.permit_callbacks = True
        
        #self.dialog.show_all()
        confstore.callbacks.append(self.on_confstore_changed)
        self.reinit(toplevel)

    def reinit(self, unused_toplevel):
        assert self.this_dlg
        self.dialog.show_all()
        i = self.active_face[0]
        self.treeview_faces.set_cursor(i)
        
    def create_face_selector(self, toplevel):
        self.liststore_faces = gtk.ListStore(
                        gobject.TYPE_INT,       # 0 FaceNum
                        gobject.TYPE_STRING,    # 1 FaceName
                        gdk.Pixbuf,             # 2 Swatch
                    )
        face_names = [_('Up'), _('Down'), _('Left'), _('Right'), _('Front'), _('Back')]
        for i in xrange(6):
            self.liststore_faces.append((i, face_names[i], None,))
        
        self.treeview_faces = toplevel.ui_xml.get_object('treeview_faces')
        self.treeview_faces.set_model(self.liststore_faces)
        
        #column = gtk.TreeViewColumn(_('Face'), gtk.CellRendererPixbuf(), pixbuf=2)
        #column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        #column.set_fixed_width(SWATCH_WIDTH_SMALLEST)
        #self.treeview_faces.append_column(column)
        pass
        column = gtk.TreeViewColumn(_('Face'), gtk.CellRendererText(), text=1)
        column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        column.set_fixed_width(50)
        self.treeview_faces.append_column(column)
        self.treeview_faces.connect("cursor-changed", self.on_treeview_faces_cursor_changed)
        
    def create_pattern_selector(self, toplevel):
        liststore = gtk.ListStore(  gobject.TYPE_INT, gobject.TYPE_INT, gdk.Pixbuf, gobject.TYPE_STRING)
        #data = ''.join(chr(255)*8 for c in textures.stock_pattern[0].data)
        #data = [((ord(c)>>(_i%8))&1)*255 for _i,c in enumerate(data)]
        #data = ''.join(chr(c)*3+chr(255) for c in data)
        #pixbuf = gdk.pixbuf_new_from_data(data, gdk.COLORSPACE_RGB, True, 8, 
        #                        textures.checkImageWidth, textures.checkImageHeight, 
        #                        textures.checkImageWidth*4)
        pass
        liststore.append((-1, 3, None, _('plain')))
        for i in xrange(6):
            data = ''.join(chr(c)*8 for c in textures.stock_pattern[i].data)
            data = [((ord(c)>>(_i%8))&1)*255 for _i, c in enumerate(data)]
            data = ''.join(chr(c)*3+chr(255) for c in data)
            pixbuf = gdk.pixbuf_new_from_data(data, gdk.COLORSPACE_RGB, True, 8, 
                                    textures.checkImageWidth, textures.checkImageHeight, 
                                    textures.checkImageWidth*4)
            liststore.append((i, 1, pixbuf, None))
            
        self.combobox_pattern = toplevel.ui_xml.get_object('combobox_pattern')
        
        cr1 = gtk.CellRendererPixbuf()
        self.combobox_pattern.pack_end(cr1)
        cr2 = gtk.CellRendererText()
        self.combobox_pattern.pack_end(cr2)
        
        self.combobox_pattern.set_model(liststore)
        self.combobox_pattern.set_attributes(cr1, pixbuf=2)
        self.combobox_pattern.set_attributes(cr2, text=3)
        self.combobox_pattern.set_column_span_column(1)
        self.combobox_pattern.connect ("changed", self.on_combobox_pattern_changed)
        self.combobox_pattern.set_tooltip_text("Click here to use a pattern on the cube surface")
        
        
    @debug_func
    def on_treeview_faces_cursor_changed(self, widget):
        path = widget.get_cursor()[0]
        assert path
        self.active_face = widget.get_model()[path]
        face_num = path[0]
        
        self.permit_callbacks = False
        self.button_color.set_color(gdk.Color(confstore.colors[face_num].color))
        self.combobox_pattern.set_active(confstore.colors[face_num].pattern+1)
        image_file = confstore.colors[face_num].imagefile
        if image_file:
            self.button_image.set_filename(image_file)
        else:
            self.button_image.unselect_all()
        distr_mode = confstore.colors[face_num].imagemode
        self.button_image_tile.set_active(distr_mode==TILED)
        self.button_image_mosaic.set_active(distr_mode==MOSAIC)
        self.permit_callbacks = True
        

    def on_confstore_changed(self, key, *subkeys):
        self.permit_callbacks = False
        if key == 'colors':
            i = int(subkeys[0])
            if subkeys[1] == 'color':
                self.button_color.set_color(gdk.Color(confstore.colors[i].color))
            elif subkeys[1] == 'pattern':
                #self.button_color.set_value(confstore.colors[i].pattern)
                pattern = confstore.colors[i].pattern
                self.combobox_pattern.set_active(pattern+1)
            elif subkeys[1] == 'imagefile':
                image_file = confstore.colors[i].imagefile
                if image_file:
                    self.button_image.set_filename(image_file)
                else:
                    self.button_image.unselect_all()
            elif subkeys[1] == 'imagemode':
                imagemode = confstore.colors[i].imagemode
                self.button_image_tile.set_active(imagemode==TILED)
                self.button_image_mosaic.set_active(imagemode==MOSAIC)
        self.permit_callbacks = True
    
    def on_button_color_set(self, button):
        if self.permit_callbacks:
            color = button.get_color()
            confstore.set_color(self.active_face[0], color)
    
    @debug_func
    def on_combobox_pattern_changed(self, widget):
        if self.permit_callbacks:
            active_iter = widget.get_active_iter()
            if active_iter:
                pattern = widget.get_model()[active_iter][0]
                i = self.active_face[0]
                confstore.colors[i].pattern = pattern
                confstore.colors[i].facetype = COLORED
    
    def on_button_image_file_set(self, widget):
        if self.permit_callbacks:
            filename = widget.get_filename()
            confstore.set_image_filename(self.active_face[0], filename)
    
    def on_button_image_distr_toggled(self, b, distr):
        if self.permit_callbacks:
            if  not gtk.ToggleButton.get_active (b):
                return
            i = self.active_face[0]
            confstore.colors[i].imagemode = distr
            confstore.colors[i].facetype = IMAGED
    
    def get_pixbuf_for_swatch(self, i, size):
        if confstore.colors[i].facetype == COLORED:
            #FIXME
            return None
        elif confstore.colors[i].facetype == IMAGED:
            width, height = size, size
            pixbuf = textures.create_pixbuf_from_file(confstore.colors[i].imagefile)
            assert pixbuf
            scaled_pixbuf = pixbuf.scale_simple(width, height, gdk.INTERP_NEAREST)
            assert scaled_pixbuf
            return scaled_pixbuf
        else:
            #FIXME
            #assert False, 'not_reached'
            return None

    def redraw_swatches(self):
        #for i in xrange(6):
            #self.draw_swatch (self.swatches[i], None, i)
            #FIXME update pixbufs in liststore
            pass

