#-*- coding:utf-8 -*-

#  Copyright © 2009-2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Ported from GNUbik
# Original filename: rand.scm
# Original copyright and license:
#;;   Copyright (c) 2004 Dale Mellor
#;;
#;;   This program is free software; you can redistribute it and/or modify
#;;   it under the terms of the GNU General Public License as published by
#;;   the Free Software Foundation; either version 3 of the License, or
#;;   (at your option) any later version.
#;;
#;;   This program is distributed in the hope that it will be useful,
#;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
#;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#;;   GNU General Public License for more details.
#;;
#;;   You should have received a copy of the GNU General Public License
#;;   along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Procedure which generates a list of lists of three random items, and sends it
# to gnubik-rotate-animated. The three random components are the face number
# (0, 1 or 2), the slice number (-(size-1), ..., size-3, size-1), and the
# direction to turn the slice (0 or 1).
def randomize(num):
    size = plugin_cube_state().dimension
    moves = [(random(3), random(size), random(2)) for i in xrange(num)]
    plugin_rotate_animated(moves)


# Invoke the above procedure from a good few menu items for the convenience of
# the user.
def items1(n):
    return '/'.join((_('Randomize'),
                    ngettext('{count} Move animated',
                             '{count} Moves animated', n).format(count=n)))
def items2(n):
    return '/'.join((_('Randomize'),
                    ngettext('{count} Move',
                             '{count} Moves', n).format(count=n)))
scripts = [ (items1(1), lambda: randomize(1)),
            (items1(2), lambda: randomize(2)),
            (items1(3), lambda: randomize(3)),
            (items1(4), lambda: randomize(4)),
            (items1(5), lambda: randomize(5)),
            (items1(6), lambda: randomize(6)),
            (items1(7), lambda: randomize(7)),
            (items1(8), lambda: randomize(8)),
            
            (items2( 50), lambda: (randomize(50),  plugin_run_moves())),
            (items2(100), lambda: (randomize(100), plugin_run_moves())),
            (items2(200), lambda: (randomize(200), plugin_run_moves())),
        ]

