use strict;
use PSP::Samples::AddressBook;

use vars qw($title @problems $addressbook_fname $addressbook 
	    %pf_box $phone_type_map $phone_type_order);
BEGIN {
 $phone_type_map =
  { "" => "",
    H => "Home",
    M => "Mobile",
    P => "Pager",
    W => "Work" };
 $phone_type_order = ['',qw(H M P W)];
}

sub clear_globals {
  undef $addressbook;
}

sub setup {
  my ($pile,$page_name) = @_;

  clear_globals();

  $addressbook_fname = $ENV{PSP_TOP}."/var/addresses.dat";
  $addressbook = new PSP::Samples::AddressBook($addressbook_fname);
  
  return;
}

sub cleanup {
  my ($pile) = @_;
  clear_globals();
}
