/*
 * PROLL: Stripped down HME/Cheerio driver from Linux kernel.
 *        We dropped such things as module support, Quattro support, etc.
 *
 * sunhme.c: Sparc HME/BigMac 10/100baseT half/full duplex auto switching,
 *           auto carrier detecting ethernet driver.  Also known as the
 *           "Happy Meal Ethernet" found on SunSwift SBUS cards.
 *
 * Copyright (C) 1996, 1998 David S. Miller (davem@caipfs.rutgers.edu)
 */

/* #include <linux/pci.h> */
#define PCI_VENDOR_ID           0x00    /* 16 bits */
#define PCI_DEVICE_ID           0x02    /* 16 bits */
#define PCI_COMMAND             0x04    /* 16 bits */
#define  PCI_COMMAND_IO         0x1     /* Enable response in I/O space */
#define  PCI_COMMAND_MEMORY     0x2     /* Enable response in Memory space */
#define  PCI_COMMAND_MASTER     0x4     /* Enable bus mastering */
#define  PCI_COMMAND_SPECIAL    0x8     /* Enable response to special cycles */
#define  PCI_COMMAND_INVALIDATE 0x10    /* Use memory write and invalidate */
#define  PCI_COMMAND_VGA_PALETTE 0x20   /* Enable palette snooping */
#define  PCI_COMMAND_PARITY     0x40    /* Enable parity checking */
#define  PCI_COMMAND_WAIT       0x80    /* Enable address/data stepping */
#define  PCI_COMMAND_SERR       0x100   /* Enable SERR */
#define  PCI_COMMAND_FAST_BACK  0x200   /* Enable back-to-back writes */
#define PCI_LATENCY_TIMER       0x0d    /* 8 bits */
#define PCI_BASE_ADDRESS_0      0x10    /* 32 bits */

#define PCI_VENDOR_ID_SUN               0x108e
#define PCI_DEVICE_ID_SUN_EBUS          0x1000
#define PCI_DEVICE_ID_SUN_HAPPYMEAL     0x1001

/* #include <linux/types.h> */
typedef unsigned char   __u8;
typedef unsigned short __u16;
typedef unsigned int   __u32;

#ifndef NULL
#define NULL ((void *)0)
#endif

//#include <linux/errno.h>
#define EAGAIN	11

#include <asi.h>		/* For pgtsrmmu.h */
#include <timer.h>

#define u8 __u8
#define u16 __u16
#define u32 __u32
#include <ethtool.h>

#include <general.h>
#include <romlib.h>
#include <net.h>		/* ETH_ALEN */
#include <netpriv.h>		/* alloc_skb() */
#include <pgtsrmmu.h>		/* PAGE_SIZE */
#include <system.h>

#include "phys_jk.h"

#ifndef GFP_KERNEL
#define GFP_KERNEL   0x01
#endif
#ifndef GFP_ATOMIC
#define GFP_ATOMIC   0x02
#endif
#ifndef GFP_DMA
#define GFP_DMA      0x10
#endif

/* XXX Shit */
unsigned long test_and_set_bit(unsigned long nr, void *addr)
{
	unsigned long flags;
	register unsigned long ret;
	register unsigned long mask;
	register unsigned long *ADDR;

	ADDR = ((unsigned long *) addr) + (nr >> 5);
	mask = 1 << (nr & 31);
	save_and_cli(flags);
	ret = *ADDR & mask;
	*ADDR |= mask;
	restore_flags(flags);
	return ret != 0;
}

static __inline__ unsigned  flip_dword (unsigned d) {
	return ((d&0xff)<<24) | (((d>>8)&0xff)<<16) | (((d>>16)&0xff)<<8)| ((d>>24)&0xff);
}

/* ----- sunhme.h start ----- */
/* Happy Meal global registers. */
struct hmeal_gregs {
	volatile unsigned int sw_reset;      /* Software Reset  */
	volatile unsigned int cfg;           /* Config Register */
	volatile unsigned int _padding[62];  /* Unused          */
	volatile unsigned int stat;          /* Status          */
	volatile unsigned int imask;         /* Interrupt Mask  */
};

/* Global reset register. */
#define GREG_RESET_ETX         0x01
#define GREG_RESET_ERX         0x02
#define GREG_RESET_ALL         0x03

/* Global config register. */
#define GREG_CFG_BURSTMSK      0x03
#define GREG_CFG_BURST16       0x00
#define GREG_CFG_BURST32       0x01
#define GREG_CFG_BURST64       0x02
#define GREG_CFG_64BIT         0x04
#define GREG_CFG_PARITY        0x08
#define GREG_CFG_RESV          0x10

/* Global status register. */
#define GREG_STAT_GOTFRAME     0x00000001 /* Received a frame                         */
#define GREG_STAT_RCNTEXP      0x00000002 /* Receive frame counter expired            */
#define GREG_STAT_ACNTEXP      0x00000004 /* Align-error counter expired              */
#define GREG_STAT_CCNTEXP      0x00000008 /* CRC-error counter expired                */
#define GREG_STAT_LCNTEXP      0x00000010 /* Length-error counter expired             */
#define GREG_STAT_RFIFOVF      0x00000020 /* Receive FIFO overflow                    */
#define GREG_STAT_CVCNTEXP     0x00000040 /* Code-violation counter expired           */
#define GREG_STAT_STSTERR      0x00000080 /* Test error in XIF for SQE                */
#define GREG_STAT_SENTFRAME    0x00000100 /* Transmitted a frame                      */
#define GREG_STAT_TFIFO_UND    0x00000200 /* Transmit FIFO underrun                   */
#define GREG_STAT_MAXPKTERR    0x00000400 /* Max-packet size error                    */
#define GREG_STAT_NCNTEXP      0x00000800 /* Normal-collision counter expired         */
#define GREG_STAT_ECNTEXP      0x00001000 /* Excess-collision counter expired         */
#define GREG_STAT_LCCNTEXP     0x00002000 /* Late-collision counter expired           */
#define GREG_STAT_FCNTEXP      0x00004000 /* First-collision counter expired          */
#define GREG_STAT_DTIMEXP      0x00008000 /* Defer-timer expired                      */
#define GREG_STAT_RXTOHOST     0x00010000 /* Moved from receive-FIFO to host memory   */
#define GREG_STAT_NORXD        0x00020000 /* No more receive descriptors              */
#define GREG_STAT_RXERR        0x00040000 /* Error during receive dma                 */
#define GREG_STAT_RXLATERR     0x00080000 /* Late error during receive dma            */
#define GREG_STAT_RXPERR       0x00100000 /* Parity error during receive dma          */
#define GREG_STAT_RXTERR       0x00200000 /* Tag error during receive dma             */
#define GREG_STAT_EOPERR       0x00400000 /* Transmit descriptor did not have EOP set */
#define GREG_STAT_MIFIRQ       0x00800000 /* MIF is signaling an interrupt condition  */
#define GREG_STAT_HOSTTOTX     0x01000000 /* Moved from host memory to transmit-FIFO  */
#define GREG_STAT_TXALL        0x02000000 /* Transmitted all packets in the tx-fifo   */
#define GREG_STAT_TXEACK       0x04000000 /* Error during transmit dma                */
#define GREG_STAT_TXLERR       0x08000000 /* Late error during transmit dma           */
#define GREG_STAT_TXPERR       0x10000000 /* Parity error during transmit dma         */
#define GREG_STAT_TXTERR       0x20000000 /* Tag error during transmit dma            */
#define GREG_STAT_SLVERR       0x40000000 /* PIO access got an error                  */
#define GREG_STAT_SLVPERR      0x80000000 /* PIO access got a parity error            */

/* All interesting error conditions. */
#define GREG_STAT_ERRORS       0xfc7efefc

/* Global interrupt mask register. */
#define GREG_IMASK_GOTFRAME    0x00000001 /* Received a frame                         */
#define GREG_IMASK_RCNTEXP     0x00000002 /* Receive frame counter expired            */
#define GREG_IMASK_ACNTEXP     0x00000004 /* Align-error counter expired              */
#define GREG_IMASK_CCNTEXP     0x00000008 /* CRC-error counter expired                */
#define GREG_IMASK_LCNTEXP     0x00000010 /* Length-error counter expired             */
#define GREG_IMASK_RFIFOVF     0x00000020 /* Receive FIFO overflow                    */
#define GREG_IMASK_CVCNTEXP    0x00000040 /* Code-violation counter expired           */
#define GREG_IMASK_STSTERR     0x00000080 /* Test error in XIF for SQE                */
#define GREG_IMASK_SENTFRAME   0x00000100 /* Transmitted a frame                      */
#define GREG_IMASK_TFIFO_UND   0x00000200 /* Transmit FIFO underrun                   */
#define GREG_IMASK_MAXPKTERR   0x00000400 /* Max-packet size error                    */
#define GREG_IMASK_NCNTEXP     0x00000800 /* Normal-collision counter expired         */
#define GREG_IMASK_ECNTEXP     0x00001000 /* Excess-collision counter expired         */
#define GREG_IMASK_LCCNTEXP    0x00002000 /* Late-collision counter expired           */
#define GREG_IMASK_FCNTEXP     0x00004000 /* First-collision counter expired          */
#define GREG_IMASK_DTIMEXP     0x00008000 /* Defer-timer expired                      */
#define GREG_IMASK_RXTOHOST    0x00010000 /* Moved from receive-FIFO to host memory   */
#define GREG_IMASK_NORXD       0x00020000 /* No more receive descriptors              */
#define GREG_IMASK_RXERR       0x00040000 /* Error during receive dma                 */
#define GREG_IMASK_RXLATERR    0x00080000 /* Late error during receive dma            */
#define GREG_IMASK_RXPERR      0x00100000 /* Parity error during receive dma          */
#define GREG_IMASK_RXTERR      0x00200000 /* Tag error during receive dma             */
#define GREG_IMASK_EOPERR      0x00400000 /* Transmit descriptor did not have EOP set */
#define GREG_IMASK_MIFIRQ      0x00800000 /* MIF is signaling an interrupt condition  */
#define GREG_IMASK_HOSTTOTX    0x01000000 /* Moved from host memory to transmit-FIFO  */
#define GREG_IMASK_TXALL       0x02000000 /* Transmitted all packets in the tx-fifo   */
#define GREG_IMASK_TXEACK      0x04000000 /* Error during transmit dma                */
#define GREG_IMASK_TXLERR      0x08000000 /* Late error during transmit dma           */
#define GREG_IMASK_TXPERR      0x10000000 /* Parity error during transmit dma         */
#define GREG_IMASK_TXTERR      0x20000000 /* Tag error during transmit dma            */
#define GREG_IMASK_SLVERR      0x40000000 /* PIO access got an error                  */
#define GREG_IMASK_SLVPERR     0x80000000 /* PIO access got a parity error            */

/* Happy Meal external transmitter registers. */
struct hmeal_etxregs {
	volatile unsigned int tx_pnding;     /* Transmit pending/wakeup register */
	volatile unsigned int cfg;           /* Transmit config register         */
	volatile unsigned int tx_ring;       /* Transmit ring pointer            */
	volatile unsigned int tx_bbase;      /* Transmit buffer base             */
	volatile unsigned int tx_bdisp;      /* Transmit buffer displacement     */
	volatile unsigned int tx_fifo_wptr;  /* FIFO write ptr                   */
	volatile unsigned int tx_fifo_swptr; /* FIFO write ptr (shadow register) */
	volatile unsigned int tx_fifo_rptr;  /* FIFO read ptr                    */
	volatile unsigned int tx_fifo_srptr; /* FIFO read ptr (shadow register)  */
	volatile unsigned int tx_fifo_pcnt;  /* FIFO packet counter              */
	volatile unsigned int smachine;      /* Transmitter state machine        */
	volatile unsigned int tx_rsize;      /* Ring descriptor size             */
	volatile unsigned int tx_bptr;       /* Transmit data buffer ptr         */
};

/* ETX transmit pending register. */
#define ETX_TP_DMAWAKEUP         0x00000001 /* Restart transmit dma             */

/* ETX config register. */
#define ETX_CFG_DMAENABLE        0x00000001 /* Enable transmit dma              */
#define ETX_CFG_FIFOTHRESH       0x000003fe /* Transmit FIFO threshold          */
#define ETX_CFG_IRQDAFTER        0x00000400 /* Interrupt after TX-FIFO drained  */
#define ETX_CFG_IRQDBEFORE       0x00000000 /* Interrupt before TX-FIFO drained */

#define ETX_RSIZE_SHIFT          4

/* Happy Meal external receiver registers. */
struct hmeal_erxregs {
	volatile unsigned int cfg;           /* Receiver config register         */
	volatile unsigned int rx_ring;       /* Receiver ring ptr                */
	volatile unsigned int rx_bptr;       /* Receiver buffer ptr              */
	volatile unsigned int rx_fifo_wptr;  /* FIFO write ptr                   */
	volatile unsigned int rx_fifo_swptr; /* FIFO write ptr (shadow register) */
	volatile unsigned int rx_fifo_rptr;  /* FIFO read ptr                    */
	volatile unsigned int rx_fifo_srptr; /* FIFO read ptr (shadow register)  */
	volatile unsigned int smachine;      /* Receiver state machine           */
};

/* ERX config register. */
#define ERX_CFG_DMAENABLE    0x00000001 /* Enable receive DMA        */
#define ERX_CFG_RESV1        0x00000006 /* Unused...                 */
#define ERX_CFG_BYTEOFFSET   0x00000038 /* Receive first byte offset */
#define ERX_CFG_RESV2        0x000001c0 /* Unused...                 */
#define ERX_CFG_SIZE32       0x00000000 /* Receive ring size == 32   */
#define ERX_CFG_SIZE64       0x00000200 /* Receive ring size == 64   */
#define ERX_CFG_SIZE128      0x00000400 /* Receive ring size == 128  */
#define ERX_CFG_SIZE256      0x00000600 /* Receive ring size == 256  */
#define ERX_CFG_RESV3        0x0000f800 /* Unused...                 */
#define ERX_CFG_CSUMSTART    0x007f0000 /* Offset of checksum start  */

/* I'd like a Big Mac, small fries, small coke, and SparcLinux please. */
struct hmeal_bigmacregs {
	volatile unsigned int xif_cfg;          /* XIF config register                */
	volatile unsigned int _unused[129];     /* Reserved...                        */
	volatile unsigned int tx_swreset;       /* Transmitter software reset         */
	volatile unsigned int tx_cfg;           /* Transmitter config register        */
	volatile unsigned int ipkt_gap1;        /* Inter-packet gap 1                 */
	volatile unsigned int ipkt_gap2;        /* Inter-packet gap 2                 */
	volatile unsigned int attempt_limit;    /* Transmit attempt limit             */
	volatile unsigned int stime;            /* Transmit slot time                 */
	volatile unsigned int preamble_len;     /* Size of transmit preamble          */
	volatile unsigned int preamble_pattern; /* Pattern for transmit preamble      */
	volatile unsigned int tx_sframe_delim;  /* Transmit delimiter                 */
	volatile unsigned int jsize;            /* Jam size                           */
	volatile unsigned int tx_pkt_max;       /* Transmit max pkt size              */
	volatile unsigned int tx_pkt_min;       /* Transmit min pkt size              */
	volatile unsigned int peak_attempt;     /* Count of transmit peak attempts    */
	volatile unsigned int dt_ctr;           /* Transmit defer timer               */
	volatile unsigned int nc_ctr;           /* Transmit normal-collision counter  */
	volatile unsigned int fc_ctr;           /* Transmit first-collision counter   */
	volatile unsigned int ex_ctr;           /* Transmit excess-collision counter  */
	volatile unsigned int lt_ctr;           /* Transmit late-collision counter    */
	volatile unsigned int rand_seed;        /* Transmit random number seed        */
	volatile unsigned int tx_smachine;      /* Transmit state machine             */
	volatile unsigned int _unused2[44];     /* Reserved                           */
	volatile unsigned int rx_swreset;       /* Receiver software reset            */
	volatile unsigned int rx_cfg;           /* Receiver config register           */
	volatile unsigned int rx_pkt_max;       /* Receive max pkt size               */
	volatile unsigned int rx_pkt_min;       /* Receive min pkt size               */
	volatile unsigned int mac_addr2;        /* Ether address register 2           */
	volatile unsigned int mac_addr1;        /* Ether address register 1           */
	volatile unsigned int mac_addr0;        /* Ether address register 0           */
	volatile unsigned int fr_ctr;           /* Receive frame receive counter      */
	volatile unsigned int gle_ctr;          /* Receive giant-length error counter */
	volatile unsigned int unale_ctr;        /* Receive unaligned error counter    */
	volatile unsigned int rcrce_ctr;        /* Receive CRC error counter          */
	volatile unsigned int rx_smachine;      /* Receiver state machine             */
	volatile unsigned int rx_cvalid;        /* Receiver code violation            */
	volatile unsigned int _unused3;         /* Reserved...                        */
	volatile unsigned int htable3;          /* Hash table 3                       */
	volatile unsigned int htable2;          /* Hash table 2                       */
	volatile unsigned int htable1;          /* Hash table 1                       */
	volatile unsigned int htable0;          /* Hash table 0                       */
	volatile unsigned int afilter2;         /* Address filter 2                   */
	volatile unsigned int afilter1;         /* Address filter 1                   */
	volatile unsigned int afilter0;         /* Address filter 0                   */
	volatile unsigned int afilter_mask;     /* Address filter mask                */

};

/* BigMac XIF config register. */
#define BIGMAC_XCFG_ODENABLE  0x00000001 /* Output driver enable         */
#define BIGMAC_XCFG_XLBACK    0x00000002 /* Loopback-mode XIF enable     */
#define BIGMAC_XCFG_MLBACK    0x00000004 /* Loopback-mode MII enable     */
#define BIGMAC_XCFG_MIIDISAB  0x00000008 /* MII receive buffer disable   */
#define BIGMAC_XCFG_SQENABLE  0x00000010 /* SQE test enable              */
#define BIGMAC_XCFG_SQETWIN   0x000003e0 /* SQE time window              */
#define BIGMAC_XCFG_LANCE     0x00000010 /* Lance mode enable            */
#define BIGMAC_XCFG_LIPG0     0x000003e0 /* Lance mode IPG0              */

/* BigMac transmit config register. */
#define BIGMAC_TXCFG_ENABLE   0x00000001 /* Enable the transmitter       */
#define BIGMAC_TXCFG_SMODE    0x00000020 /* Enable slow transmit mode    */
#define BIGMAC_TXCFG_CIGN     0x00000040 /* Ignore transmit collisions   */
#define BIGMAC_TXCFG_FCSOFF   0x00000080 /* Do not emit FCS              */
#define BIGMAC_TXCFG_DBACKOFF 0x00000100 /* Disable backoff              */
#define BIGMAC_TXCFG_FULLDPLX 0x00000200 /* Enable full-duplex           */
#define BIGMAC_TXCFG_DGIVEUP  0x00000400 /* Don't give up on transmits   */

/* BigMac receive config register. */
#define BIGMAC_RXCFG_ENABLE   0x00000001 /* Enable the receiver             */
#define BIGMAC_RXCFG_PSTRIP   0x00000020 /* Pad byte strip enable           */
#define BIGMAC_RXCFG_PMISC    0x00000040 /* Enable promiscous mode          */
#define BIGMAC_RXCFG_DERR     0x00000080 /* Disable error checking          */
#define BIGMAC_RXCFG_DCRCS    0x00000100 /* Disable CRC stripping           */
#define BIGMAC_RXCFG_ME       0x00000200 /* Receive packets addressed to me */
#define BIGMAC_RXCFG_PGRP     0x00000400 /* Enable promisc group mode       */
#define BIGMAC_RXCFG_HENABLE  0x00000800 /* Enable the hash filter          */
#define BIGMAC_RXCFG_AENABLE  0x00001000 /* Enable the address filter       */

/* These are the "Management Interface" (ie. MIF) registers of the transceiver. */
struct hmeal_tcvregs {
	volatile unsigned int bb_clock; /* Bit bang clock register          */
	volatile unsigned int bb_data;  /* Bit bang data register           */
	volatile unsigned int bb_oenab; /* Bit bang output enable           */
	volatile unsigned int frame;    /* Frame control/data register      */
	volatile unsigned int cfg;      /* MIF config register              */
	volatile unsigned int int_mask; /* MIF interrupt mask               */
	volatile unsigned int status;   /* MIF status                       */
	volatile unsigned int smachine; /* MIF state machine                */
};

/* Frame commands. */
#define FRAME_WRITE           0x50020000
#define FRAME_READ            0x60020000

/* Transceiver config register */
#define TCV_CFG_PSELECT       0x00000001 /* Select PHY                      */
#define TCV_CFG_PENABLE       0x00000002 /* Enable MIF polling              */
#define TCV_CFG_BENABLE       0x00000004 /* Enable the "bit banger" oh baby */
#define TCV_CFG_PREGADDR      0x000000f8 /* Address of poll register        */
#define TCV_CFG_MDIO0         0x00000100 /* MDIO zero, data/attached        */
#define TCV_CFG_MDIO1         0x00000200 /* MDIO one,  data/attached        */
#define TCV_CFG_PDADDR        0x00007c00 /* Device PHY address polling      */

/* Here are some PHY addresses. */
#define TCV_PADDR_ETX         0          /* Internal transceiver            */
#define TCV_PADDR_ITX         1          /* External transceiver            */

/* Transceiver status register */
#define TCV_STAT_BASIC        0xffff0000 /* The "basic" part                */
#define TCV_STAT_NORMAL       0x0000ffff /* The "non-basic" part            */

/* Inside the Happy Meal transceiver is the physical layer, they use an
 * implementations for National Semiconductor, part number DP83840VCE.
 * You can retrieve the data sheets and programming docs for this beast
 * from http://www.national.com/
 *
 * The DP83840 is capable of both 10 and 100Mbps ethernet, in both
 * half and full duplex mode.  It also supports auto negotiation.
 *
 * But.... THIS THING IS A PAIN IN THE ASS TO PROGRAM!
 * Debugging eeprom burnt code is more fun than programming this chip!
 */

/* First, the DP83840 register numbers. */
#define DP83840_BMCR            0x00        /* Basic mode control register */
#define DP83840_BMSR            0x01        /* Basic mode status register  */
#define DP83840_PHYSID1         0x02        /* PHYS ID 1                   */
#define DP83840_PHYSID2         0x03        /* PHYS ID 2                   */
#define DP83840_ADVERTISE       0x04        /* Advertisement control reg   */
#define DP83840_LPA             0x05        /* Link partner ability reg    */
#define DP83840_EXPANSION       0x06        /* Expansion register          */
#define DP83840_DCOUNTER        0x12        /* Disconnect counter          */
#define DP83840_FCSCOUNTER      0x13        /* False carrier counter       */
#define DP83840_NWAYTEST        0x14        /* N-way auto-neg test reg     */
#define DP83840_RERRCOUNTER     0x15        /* Receive error counter       */
#define DP83840_SREVISION       0x16        /* Silicon revision            */
#define DP83840_CSCONFIG        0x17        /* CS configuration            */
#define DP83840_LBRERROR        0x18        /* Lpback, rx, bypass error    */
#define DP83840_PHYADDR         0x19        /* PHY address                 */
#define DP83840_RESERVED        0x1a        /* Unused...                   */
#define DP83840_TPISTATUS       0x1b        /* TPI status for 10mbps       */
#define DP83840_NCONFIG         0x1c        /* Network interface config    */

/* Basic mode control register. */
#define BMCR_RESV               0x007f  /* Unused...                   */
#define BMCR_CTST               0x0080  /* Collision test              */
#define BMCR_FULLDPLX           0x0100  /* Full duplex                 */
#define BMCR_ANRESTART          0x0200  /* Auto negotiation restart    */
#define BMCR_ISOLATE            0x0400  /* Disconnect DP83840 from MII */
#define BMCR_PDOWN              0x0800  /* Powerdown the DP83840       */
#define BMCR_ANENABLE           0x1000  /* Enable auto negotiation     */
#define BMCR_SPEED100           0x2000  /* Select 100Mbps              */
#define BMCR_LOOPBACK           0x4000  /* TXD loopback bits           */
#define BMCR_RESET              0x8000  /* Reset the DP83840           */

/* Basic mode status register. */
#define BMSR_ERCAP              0x0001  /* Ext-reg capability          */
#define BMSR_JCD                0x0002  /* Jabber detected             */
#define BMSR_LSTATUS            0x0004  /* Link status                 */
#define BMSR_ANEGCAPABLE        0x0008  /* Able to do auto-negotiation */
#define BMSR_RFAULT             0x0010  /* Remote fault detected       */
#define BMSR_ANEGCOMPLETE       0x0020  /* Auto-negotiation complete   */
#define BMSR_RESV               0x07c0  /* Unused...                   */
#define BMSR_10HALF             0x0800  /* Can do 10mbps, half-duplex  */
#define BMSR_10FULL             0x1000  /* Can do 10mbps, full-duplex  */
#define BMSR_100HALF            0x2000  /* Can do 100mbps, half-duplex */
#define BMSR_100FULL            0x4000  /* Can do 100mbps, full-duplex */
#define BMSR_100BASE4           0x8000  /* Can do 100mbps, 4k packets  */

/* Advertisement control register. */
#define ADVERTISE_SLCT          0x001f  /* Selector bits               */
#define ADVERTISE_CSMA          0x0001  /* Only selector supported     */
#define ADVERTISE_10HALF        0x0020  /* Try for 10mbps half-duplex  */
#define ADVERTISE_10FULL        0x0040  /* Try for 10mbps full-duplex  */
#define ADVERTISE_100HALF       0x0080  /* Try for 100mbps half-duplex */
#define ADVERTISE_100FULL       0x0100  /* Try for 100mbps full-duplex */
#define ADVERTISE_100BASE4      0x0200  /* Try for 100mbps 4k packets  */
#define ADVERTISE_RESV          0x1c00  /* Unused...                   */
#define ADVERTISE_RFAULT        0x2000  /* Say we can detect faults    */
#define ADVERTISE_LPACK         0x4000  /* Ack link partners response  */
#define ADVERTISE_NPAGE         0x8000  /* Next page bit               */

#define ADVERTISE_ALL (ADVERTISE_10HALF | ADVERTISE_10FULL | \
                       ADVERTISE_100HALF | ADVERTISE_100FULL)

/* Link partner ability register. */
#define LPA_SLCT                0x001f  /* Same as advertise selector  */
#define LPA_10HALF              0x0020  /* Can do 10mbps half-duplex   */
#define LPA_10FULL              0x0040  /* Can do 10mbps full-duplex   */
#define LPA_100HALF             0x0080  /* Can do 100mbps half-duplex  */
#define LPA_100FULL             0x0100  /* Can do 100mbps full-duplex  */
#define LPA_100BASE4            0x0200  /* Can do 100mbps 4k packets   */
#define LPA_RESV                0x1c00  /* Unused...                   */
#define LPA_RFAULT              0x2000  /* Link partner faulted        */
#define LPA_LPACK               0x4000  /* Link partner acked us       */
#define LPA_NPAGE               0x8000  /* Next page bit               */

/* Expansion register for auto-negotiation. */
#define EXPANSION_NWAY          0x0001  /* Can do N-way auto-nego      */
#define EXPANSION_LCWP          0x0002  /* Got new RX page code word   */
#define EXPANSION_ENABLENPAGE   0x0004  /* This enables npage words    */
#define EXPANSION_NPCAPABLE     0x0008  /* Link partner supports npage */
#define EXPANSION_MFAULTS       0x0010  /* Multiple faults detected    */
#define EXPANSION_RESV          0xffe0  /* Unused...                   */

/* N-way test register. */
#define NWAYTEST_RESV1          0x00ff  /* Unused...                   */
#define NWAYTEST_LOOPBACK       0x0100  /* Enable loopback for N-way   */
#define NWAYTEST_RESV2          0xfe00  /* Unused...                   */

/* The Carrier Sense config register. */
#define CSCONFIG_RESV1          0x0001  /* Unused...                   */
#define CSCONFIG_LED4           0x0002  /* Pin for full-dplx LED4      */
#define CSCONFIG_LED1           0x0004  /* Pin for conn-status LED1    */
#define CSCONFIG_RESV2          0x0008  /* Unused...                   */
#define CSCONFIG_TCVDISAB       0x0010  /* Turns off the transceiver   */
#define CSCONFIG_DFBYPASS       0x0020  /* Bypass disconnect function  */
#define CSCONFIG_GLFORCE        0x0040  /* Good link force for 100mbps */
#define CSCONFIG_CLKTRISTATE    0x0080  /* Tristate 25m clock          */
#define CSCONFIG_RESV3          0x0700  /* Unused...                   */
#define CSCONFIG_ENCODE         0x0800  /* 1=MLT-3, 0=binary           */
#define CSCONFIG_RENABLE        0x1000  /* Repeater mode enable        */
#define CSCONFIG_TCDISABLE      0x2000  /* Disable timeout counter     */
#define CSCONFIG_RESV4          0x4000  /* Unused...                   */
#define CSCONFIG_NDISABLE       0x8000  /* Disable NRZI                */

/* Loopback, receive, bypass error register. */
#define LBRERROR_EBUFFER        0x0001  /* Show elasticity buf errors  */
#define LBRERROR_PACKET         0x0002  /* Show packet errors          */
#define LBRERROR_LINK           0x0004  /* Show link errors            */
#define LBRERROR_END            0x0008  /* Show premature end errors   */
#define LBRERROR_CODE           0x0010  /* Show code errors            */
#define LBRERROR_RESV1          0x00e0  /* Unused...                   */
#define LBRERROR_LBACK          0x0300  /* Remote and twister loopback */
#define LBRERROR_10TX           0x0400  /* Transceiver loopback 10mbps */
#define LBRERROR_ENDEC          0x0800  /* ENDEC loopback 10mbps       */
#define LBRERROR_ALIGN          0x1000  /* Bypass symbol alignment     */
#define LBRERROR_SCRAMBLER      0x2000  /* Bypass (de)scrambler        */
#define LBRERROR_ENCODER        0x4000  /* Bypass 4B5B/5B4B encoders   */
#define LBRERROR_BEBUF          0x8000  /* Bypass elasticity buffers   */

/* Physical address register. */
#define PHYADDR_ADDRESS         0x001f  /* The address itself          */
#define PHYADDR_DISCONNECT      0x0020  /* Disconnect status           */
#define PHYADDR_10MBPS          0x0040  /* 1=10mbps, 0=100mbps         */
#define PHYADDR_RESV            0xff80  /* Unused...                   */

/* TPI status register for 10mbps. */
#define TPISTATUS_RESV1         0x01ff  /* Unused...                   */
#define TPISTATUS_SERIAL        0x0200  /* Enable 10mbps serial mode   */
#define TPISTATUS_RESV2         0xfc00  /* Unused...                   */

/* Network interface config register. */
#define NCONFIG_JENABLE         0x0001  /* Jabber enable               */
#define NCONFIG_RESV1           0x0002  /* Unused...                   */
#define NCONFIG_SQUELCH         0x0004  /* Use low squelch             */
#define NCONFIG_UTP             0x0008  /* 1=UTP, 0=STP                */
#define NCONFIG_HBEAT           0x0010  /* Heart-beat enable           */
#define NCONFIG_LDISABLE        0x0020  /* Disable the link            */
#define NCONFIG_RESV2           0xffc0  /* Unused...                   */

/* Happy Meal descriptor rings and such.
 * All descriptor rings must be aligned on a 2K boundry.
 * All receive buffers must be 64 byte aligned.
 */
struct happy_meal_rxd {
	unsigned int rx_flags;
	unsigned int rx_addr;
};

#define RXFLAG_OWN         0x80000000 /* 1 = hardware, 0 = software */
#define RXFLAG_OVERFLOW    0x40000000 /* 1 = buffer overflow        */
#define RXFLAG_SIZE        0x3fff0000 /* Size of the buffer         */
#define RXFLAG_CSUM        0x0000ffff /* HW computed checksum       */

struct happy_meal_txd {
	unsigned int tx_flags;
	unsigned int tx_addr;
};

#define TXFLAG_OWN         0x80000000 /* 1 = hardware, 0 = software */
#define TXFLAG_SOP         0x40000000 /* 1 = start of packet        */
#define TXFLAG_EOP         0x20000000 /* 1 = end of packet          */
#define TXFLAG_CSENABLE    0x10000000 /* 1 = enable hw-checksums    */
#define TXFLAG_CSLOCATION  0x0ff00000 /* Where to stick the csum    */
#define TXFLAG_CSBUFBEGIN  0x000fc000 /* Where to begin checksum    */
#define TXFLAG_SIZE        0x00003fff /* Size of the packet         */

#define TX_RING_SIZE       32      /* Must be >16 and <255, multiple of 16  */
#define RX_RING_SIZE       32      /* see ERX_CFG_SIZE* for possible values */

#define TX_RING_MAXSIZE    256
#define RX_RING_MAXSIZE    256

/* 34 byte offset for checksum computation.  This works because ip_input() will clear out
 * the skb->csum and skb->ip_summed fields and recompute the csum if IP options are
 * present in the header.  34 == (ethernet header len) + sizeof(struct iphdr)
 */
#define ERX_CFG_DEFAULT(off) (ERX_CFG_DMAENABLE|((off)<<3)|ERX_CFG_SIZE32|(0x22<<16))

#define NEXT_RX(num)       (((num) + 1) & (RX_RING_SIZE - 1))
#define NEXT_TX(num)       (((num) + 1) & (TX_RING_SIZE - 1))
#define PREV_RX(num)       (((num) - 1) & (RX_RING_SIZE - 1))
#define PREV_TX(num)       (((num) - 1) & (TX_RING_SIZE - 1))

#define TX_BUFFS_AVAIL(hp)                                    \
        (((hp)->tx_old <= (hp)->tx_new) ?                     \
	  (hp)->tx_old + (TX_RING_SIZE - 1) - (hp)->tx_new :  \
			    (hp)->tx_old - (hp)->tx_new - 1)

#define RX_OFFSET          2
#define RX_BUF_ALLOC_SIZE  (ETH_FRAME_LEN + RX_OFFSET)

#define RX_COPY_THRESHOLD  256

struct hmeal_init_block {
	struct happy_meal_rxd happy_meal_rxd[RX_RING_MAXSIZE];
	struct happy_meal_txd happy_meal_txd[TX_RING_MAXSIZE];
};

#define hblock_offset(mem, elem) \
((__u32)((unsigned long)(&(((struct hmeal_init_block *)0)->mem[elem]))))

/* Now software state stuff. */
enum happy_transceiver {
	external = 0,
	internal = 1,
	none     = 2,
};

/* Timer state engine. */
enum happy_timer_state {
	arbwait  = 0,  /* Waiting for auto negotiation to complete.          */
	lupwait  = 1,  /* Auto-neg complete, awaiting link-up status.        */
	ltrywait = 2,  /* Forcing try of all modes, from fastest to slowest. */
	asleep   = 3,  /* Time inactive.                                     */
};

/* Happy happy, joy joy! */
struct happy_meal {
	int active;

	unsigned int irq;
	char hmename[5];

	struct hmeal_gregs       *gregs;          /* Happy meal global registers       */
	struct hmeal_etxregs     *etxregs;        /* External transmitter regs         */
	struct hmeal_erxregs     *erxregs;        /* External receiver regs            */
	struct hmeal_bigmacregs  *bigmacregs;     /* I said NO SOLARIS with my bigmac! */
	struct hmeal_tcvregs     *tcvregs;        /* MIF transceiver regs              */

	struct hmeal_init_block  *happy_block;    /* RX and TX descriptors (CPU addr)  */
	__u32                     hblock_dvma;    /* DVMA visible address happy block  */

	struct sk_buff           *rx_skbs[RX_RING_SIZE];
	struct sk_buff           *tx_skbs[TX_RING_SIZE];

	int rx_new, tx_new, rx_old, tx_old;

	unsigned int              happy_flags;	/* Driver state flags         */
	enum happy_transceiver    tcvr_type;      /* Kind of transceiver in use        */
	unsigned int              paddr;          /* PHY address for transceiver       */
	unsigned short            hm_revision;    /* Happy meal revision               */
	unsigned short            sw_bmcr;        /* SW copy of BMCR                   */
	unsigned short            sw_bmsr;        /* SW copy of BMSR                   */
	unsigned short            sw_physid1;     /* SW copy of PHYSID1                */
	unsigned short            sw_physid2;     /* SW copy of PHYSID2                */
	unsigned short            sw_advertise;   /* SW copy of ADVERTISE              */
	unsigned short            sw_lpa;         /* SW copy of LPA                    */
	unsigned short            sw_expansion;   /* SW copy of EXPANSION              */
	unsigned short            sw_csconfig;    /* SW copy of CSCONFIG               */
	unsigned int              auto_speed;     /* Auto-nego link speed              */
        unsigned int              forced_speed;   /* Force mode link speed             */
	unsigned int              poll_data;      /* MIF poll data                     */
	unsigned int              poll_flag;      /* MIF poll flag                     */
	unsigned int              linkcheck;      /* Have we checked the link yet?     */
	unsigned int              lnkup;          /* Is the link up as far as we know? */
	unsigned int              lnkdown;        /* Trying to force the link down?    */
	unsigned int              lnkcnt;         /* Counter for link-up attempts.     */
	struct timer_list         happy_timer;    /* To watch the link when coming up. */
	enum happy_timer_state    timer_state;    /* State of the auto-neg timer.      */
	unsigned int              timer_ticks;    /* Number of clicks at each state.   */

	struct device             edev;           /* Backpointer              */
};

/* Here are the happy flags. */
#define HFLAG_POLL                0x00000001    /* We are doing MIF polling   */
#define HFLAG_FENABLE             0x00000002    /* The MII frame is enabled   */
#define HFLAG_LANCE               0x00000004    /* We are using lance-mode    */
#define HFLAG_RXENABLE            0x00000008    /* Receiver is enabled        */
#define HFLAG_AUTO                0x00000010    /* Using auto-negotiation, 0 = force */
#define HFLAG_FULL                0x00000020    /* Full duplex enable         */
#define HFLAG_MACFULL             0x00000040    /* Using full duplex in the MAC      */
#define HFLAG_POLLENABLE          0x00000080    /* Actually try MIF polling   */
#define HFLAG_RXCV                0x00000100    /* XXX RXCV ENABLE            */
#define HFLAG_INIT                0x00000200    /* Init called at least once  */
#define HFLAG_LINKUP              0x00000400    /* 1 = Link is up             */
#define HFLAG_PCI                 0x00000800	/* PCI based Happy Meal       */
/* #define HFLAG_QUATTRO	  0x00001000 */	/* On QFE/Quattro card        */

#define HFLAG_20_21  (HFLAG_POLLENABLE | HFLAG_FENABLE)
#define HFLAG_NOT_A0 (HFLAG_POLLENABLE | HFLAG_FENABLE | HFLAG_LANCE | HFLAG_RXCV)

/* Used to be -
 * Register/DMA access stuff, used to cope with differences between
 * PCI and SBUS happy meals.
 */
#define hme_read32(bp, reg)         ld_bp_swap((unsigned long)reg)
#define hme_write32(bp, reg, val)   st_bp_swap((unsigned long)reg, val)

#ifdef __sparc_v9__
extern inline void pcihme_write_rxd(struct happy_meal_rxd *rp,
				    unsigned int flags,
				    unsigned int addr)
{
	__asm__ __volatile__("
	stwa	%3, [%0] %2
	stwa	%4, [%1] %2
"	: /* no outputs */
	: "r" (&rp->rx_addr), "r" (&rp->rx_flags),
	  "i" (ASI_PL), "r" (addr), "r" (flags));
}

extern inline void pcihme_write_txd(struct happy_meal_txd *tp,
				    unsigned int flags,
				    unsigned int addr)
{
	__asm__ __volatile__("
	stwa	%3, [%0] %2
	stwa	%4, [%1] %2
"	: /* no outputs */
	: "r" (&tp->tx_addr), "r" (&tp->tx_flags),
	  "i" (ASI_PL), "r" (addr), "r" (flags));
}

#else

extern void pcihme_write_rxd(struct happy_meal_rxd *rp,
				    unsigned int flags,
				    unsigned int addr)
{
	rp->rx_addr = flip_dword(addr);
	rp->rx_flags = flip_dword(flags);
}

extern void pcihme_write_txd(struct happy_meal_txd *tp,
				    unsigned int flags,
				    unsigned int addr)
{
	tp->tx_addr = flip_dword(addr);
	tp->tx_flags = flip_dword(flags);
}

#endif  /* def __sparc_v9__ */

/* ----- sunhme.h end ----- */

#undef HMEDEBUG
#undef SXDEBUG
#undef RXDEBUG
#undef TXDEBUG
#undef TXLOGGING

#ifdef TXLOGGING
struct hme_tx_logent {
	unsigned int tstamp;
	int tx_new, tx_old;
	unsigned int action;
#define TXLOG_ACTION_IRQ	0x01
#define TXLOG_ACTION_TXMIT	0x02
#define TXLOG_ACTION_TBUSY	0x04
#define TXLOG_ACTION_NBUFS	0x08
	unsigned int status;
};
#define TX_LOG_LEN	128
static struct hme_tx_logent tx_log[TX_LOG_LEN];
static int txlog_cur_entry = 0;
static __inline__ void tx_add_log(struct happy_meal *hp, unsigned int a, unsigned int s)
{
	struct hme_tx_logent *tlp;
	unsigned long flags;

	save_and_cli(flags);
	tlp = &tx_log[txlog_cur_entry];
	tlp->tstamp = (unsigned int)jiffies;
	tlp->tx_new = hp->tx_new;
	tlp->tx_old = hp->tx_old;
	tlp->action = a;
	tlp->status = s;
	txlog_cur_entry = (txlog_cur_entry + 1) & (TX_LOG_LEN - 1);
	restore_flags(flags);
}
static __inline__ void tx_dump_log(void)
{
	int i, this;

	this = txlog_cur_entry;
	for(i = 0; i < TX_LOG_LEN; i++) {
		printk("TXLOG[%d]: j[%x] tx[N(%d)O(%d)] action[%x] stat[%x]\n", i,
		       tx_log[this].tstamp,
		       tx_log[this].tx_new, tx_log[this].tx_old,
		       tx_log[this].action, tx_log[this].status);
		this = (this + 1) & (TX_LOG_LEN - 1);
	}
}
static __inline__ void tx_dump_ring(struct happy_meal *hp)
{
	struct hmeal_init_block *hb = hp->happy_block;
	struct happy_meal_txd *tp = &hb->happy_meal_txd[0];
	int i;

	for(i = 0; i < TX_RING_SIZE; i+=4) {
		printk("TXD[%d..%d]: [%x:%x] [%x:%x] [%x:%x] [%x:%x]\n",
		       i, i + 4,
		       le32_to_cpu(tp[i].tx_flags), le32_to_cpu(tp[i].tx_addr),
		       le32_to_cpu(tp[i + 1].tx_flags), le32_to_cpu(tp[i + 1].tx_addr),
		       le32_to_cpu(tp[i + 2].tx_flags), le32_to_cpu(tp[i + 2].tx_addr),
		       le32_to_cpu(tp[i + 3].tx_flags), le32_to_cpu(tp[i + 3].tx_addr));
	}
}
#else
#define tx_add_log(hp, a, s)		do { } while(0)
#define tx_dump_log()			do { } while(0)
#define tx_dump_ring(hp)		do { } while(0)
#endif

#ifdef HMEDEBUG
#define HMD(x)  printk x
#else
#define HMD(x)
#endif

/* #define AUTO_SWITCH_DEBUG */

#ifdef AUTO_SWITCH_DEBUG
#define ASD(x)  printk x
#else
#define ASD(x)
#endif

/*
 * XXX Turn this into PROM node when needed.
 */
struct hme_info {
	/*
	 * Properties
	 */
	unsigned char hm_rev;
	__u32 physaddr[3];
	int tpe;        /* 0 = auto; 1 = AUI; 2 = TPE; XXX */
	int intr;
	unsigned long pci_bus;
	unsigned int pci_func;
	/*
	 * Non-properties
	 */
	/* struct le_dma *ledma; */
};

#define DEFAULT_IPG0      16 /* For lance-mode only */
#define DEFAULT_IPG1       8 /* For all modes */
#define DEFAULT_IPG2       4 /* For all modes */
#define DEFAULT_JAMSIZE    4 /* Toe jam */

/*
 * XXX This belongs to pcic.c
 */

#define CONFIG_CMD(bus, device_fn, where) (0x80000000 | (((unsigned int)bus) << 16) | (((unsigned int)device_fn) << 8) | (where & ~3))

unsigned hme_pci_read_config_dword(struct hme_info *info, unsigned char where) {
	unsigned int bus = info->pci_bus, devfn = info->pci_func;
	unsigned long flags;
	unsigned int value;

	save_and_cli(flags);
	st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(bus,devfn,where));
	value = ld_bp_swap(PHYS_JK_PCI_CFD + (where & 4));
	restore_flags(flags);
	return value;
}

unsigned hme_pci_read_config_byte(struct hme_info *info, unsigned char where) {
	unsigned int v;
	v = hme_pci_read_config_dword (info, where&~3);
	v = 0xff & (v >> (8*(where & 3)));
	return v;
}

unsigned hme_pci_read_config_word(struct hme_info *info, unsigned char where) {
	unsigned int v;
	v = hme_pci_read_config_dword (info, where&~3);
	v = 0xffff & (v >> (8*(where & 3)));
	return v;
}

void hme_pci_write_config_dword (struct hme_info *info,
	unsigned char where, unsigned int value)
{
	unsigned int bus = info->pci_bus, devfn = info->pci_func;
	unsigned long flags;

	save_and_cli(flags);
	st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(bus,devfn,where));
	st_bp_swap(PHYS_JK_PCI_CFD + (where & 4), value);
	restore_flags(flags);
}

void hme_pci_write_config_byte (struct hme_info *info,
			       unsigned char where, unsigned char value)
{
	unsigned int v;

	v = hme_pci_read_config_dword (info, where&~3);
	v = (v & ~(0xff << (8*(where&3)))) | 
	    ((0xff&(unsigned)value) << (8*(where&3)));
	hme_pci_write_config_dword (info, where&~3, v);
}

void hme_pci_write_config_word (struct hme_info *info,
			       unsigned char where, unsigned short value)
{
	unsigned int v;

	v = hme_pci_read_config_dword(info, where&~3);
	v = (v & ~(0xffff << (8*(where&3)))) | 
	    ((0xffff&(unsigned)value) << (8*(where&3)));
	hme_pci_write_config_dword(info, where&~3, v);
}

/*
 */
struct hme_info hme_node0;
struct happy_meal hme_arena[1];

/* Oh yes, the MIF BitBang is mighty fun to program.  BitBucket is more like it. */
#define BB_PUT_BIT(hp, tregs, bit)						\
do {	hme_write32(hp, &(tregs)->bb_data, (bit));				\
	hme_write32(hp, &(tregs)->bb_clock, 0);					\
	hme_write32(hp, &(tregs)->bb_clock, 1);					\
} while(0)

#define BB_GET_BIT(hp, tregs, internal)						\
({										\
	hme_write32(hp, &(tregs)->bb_clock, 0);					\
	hme_write32(hp, &(tregs)->bb_clock, 1);					\
	if(internal)								\
		hme_read32(hp, &(tregs)->cfg) & TCV_CFG_MDIO0;			\
	else									\
		hme_read32(hp, &(tregs)->cfg) & TCV_CFG_MDIO1;			\
})

#define BB_GET_BIT2(hp, tregs, internal)					\
({										\
	int retval;								\
	hme_write32(hp, &(tregs)->bb_clock, 0);					\
	udelay(1);								\
	if(internal)								\
		retval = hme_read32(hp, &(tregs)->cfg) & TCV_CFG_MDIO0;		\
	else									\
		retval = hme_read32(hp, &(tregs)->cfg) & TCV_CFG_MDIO1;		\
	hme_write32(hp, &(tregs)->bb_clock, 1);					\
	retval;									\
})

#define TCVR_FAILURE      0x80000000     /* Impossible MIF read value */

static inline int happy_meal_bb_read(struct happy_meal *hp,
				     struct hmeal_tcvregs *tregs, int reg)
{
	volatile int unused;
	unsigned long tmp;
	int retval = 0;
	int i;

	ASD(("happy_meal_bb_read: reg=%d ", reg));

	/* Enable the MIF BitBang outputs. */
	hme_write32(hp, &tregs->bb_oenab, 1);

	/* Force BitBang into the idle state. */
	for(i = 0; i < 32; i++)
		BB_PUT_BIT(hp, tregs, 1);

	/* Give it the read sequence. */
	BB_PUT_BIT(hp, tregs, 0);
	BB_PUT_BIT(hp, tregs, 1);
	BB_PUT_BIT(hp, tregs, 1);
	BB_PUT_BIT(hp, tregs, 0);

	/* Give it the PHY address. */
	tmp = hp->paddr & 0xff;
	for(i = 4; i >= 0; i--)
		BB_PUT_BIT(hp, tregs, ((tmp >> i) & 1));

	/* Tell it what register we want to read. */
	tmp = (reg & 0xff);
	for(i = 4; i >= 0; i--)
		BB_PUT_BIT(hp, tregs, ((tmp >> i) & 1));

	/* Close down the MIF BitBang outputs. */
	hme_write32(hp, &tregs->bb_oenab, 0);

	/* Now read in the value. */
	unused = BB_GET_BIT2(hp, tregs, (hp->tcvr_type == internal));
	for(i = 15; i >= 0; i--)
		retval |= BB_GET_BIT2(hp, tregs, (hp->tcvr_type == internal));
	unused = BB_GET_BIT2(hp, tregs, (hp->tcvr_type == internal));
	unused = BB_GET_BIT2(hp, tregs, (hp->tcvr_type == internal));
	unused = BB_GET_BIT2(hp, tregs, (hp->tcvr_type == internal));
	ASD(("value=%x\n", retval));
	return retval;
}

static inline void happy_meal_bb_write(struct happy_meal *hp,
				       struct hmeal_tcvregs *tregs, int reg,
				       unsigned short value)
{
	unsigned long tmp;
	int i;

	ASD(("happy_meal_bb_write: reg=%d value=%x\n", reg, value));

	/* Enable the MIF BitBang outputs. */
	hme_write32(hp, &tregs->bb_oenab, 1);

	/* Force BitBang into the idle state. */
	for(i = 0; i < 32; i++)
		BB_PUT_BIT(hp, tregs, 1);

	/* Give it write sequence. */
	BB_PUT_BIT(hp, tregs, 0);
	BB_PUT_BIT(hp, tregs, 1);
	BB_PUT_BIT(hp, tregs, 0);
	BB_PUT_BIT(hp, tregs, 1);

	/* Give it the PHY address. */
	tmp = (hp->paddr & 0xff);
	for(i = 4; i >= 0; i--)
		BB_PUT_BIT(hp, tregs, ((tmp >> i) & 1));

	/* Tell it what register we will be writing. */
	tmp = (reg & 0xff);
	for(i = 4; i >= 0; i--)
		BB_PUT_BIT(hp, tregs, ((tmp >> i) & 1));

	/* Tell it to become ready for the bits. */
	BB_PUT_BIT(hp, tregs, 1);
	BB_PUT_BIT(hp, tregs, 0);

	for(i = 15; i >= 0; i--)
		BB_PUT_BIT(hp, tregs, ((value >> i) & 1));

	/* Close down the MIF BitBang outputs. */
	hme_write32(hp, &tregs->bb_oenab, 0);
}

#define TCVR_READ_TRIES   16

static inline int happy_meal_tcvr_read(struct happy_meal *hp,
				       struct hmeal_tcvregs *tregs, int reg)
{
	int tries = TCVR_READ_TRIES;
	int retval;

	ASD(("happy_meal_tcvr_read: reg=0x%02x ", reg));
	if(hp->tcvr_type == none) {
		ASD(("no transceiver, value=TCVR_FAILURE\n"));
		return TCVR_FAILURE;
	}

	if(!(hp->happy_flags & HFLAG_FENABLE)) {
		ASD(("doing bit bang\n"));
		return happy_meal_bb_read(hp, tregs, reg);
	}

	hme_write32(hp, &tregs->frame,
		    (FRAME_READ | (hp->paddr << 23) | ((reg & 0xff) << 18)));
	while(!(hme_read32(hp, &tregs->frame) & 0x10000) && --tries)
		udelay(20);
	if(!tries) {
		printk("happy meal: Aieee, transceiver MIF read bolixed\n");
		return TCVR_FAILURE;
	}
	retval = hme_read32(hp, &tregs->frame) & 0xffff;
	ASD(("value=%04x\n", retval));
	return retval;
}

#define TCVR_WRITE_TRIES  16

static inline void happy_meal_tcvr_write(struct happy_meal *hp,
					 struct hmeal_tcvregs *tregs, int reg,
					 unsigned short value)
{
	int tries = TCVR_WRITE_TRIES;
	
	ASD(("happy_meal_tcvr_write: reg=0x%02x value=%04x\n", reg, value));

	/* Welcome to Sun Microsystems, can I take your order please? */
	if(!hp->happy_flags & HFLAG_FENABLE)
		return happy_meal_bb_write(hp, tregs, reg, value);

	/* Would you like fries with that? */
	hme_write32(hp, &tregs->frame,
		    (FRAME_WRITE | (hp->paddr << 23) |
		     ((reg & 0xff) << 18) | (value & 0xffff)));
	while(!(hme_read32(hp, &tregs->frame) & 0x10000) && --tries)
		udelay(20);

	/* Anything else? */
	if(!tries)
		printk("happy meal: Aieee, transceiver MIF write bolixed\n");

	/* Fifty-two cents is your change, have a nice day. */
}

/* Auto negotiation.  The scheme is very simple.  We have a timer routine
 * that keeps watching the auto negotiation process as it progresses.
 * The DP83840 is first told to start doing it's thing, we set up the time
 * and place the timer state machine in it's initial state.
 *
 * Here the timer peeks at the DP83840 status registers at each click to see
 * if the auto negotiation has completed, we assume here that the DP83840 PHY
 * will time out at some point and just tell us what (didn't) happen.  For
 * complete coverage we only allow so many of the ticks at this level to run,
 * when this has expired we print a warning message and try another strategy.
 * This "other" strategy is to force the interface into various speed/duplex
 * configurations and we stop when we see a link-up condition before the
 * maximum number of "peek" ticks have occurred.
 *
 * Once a valid link status has been detected we configure the BigMAC and
 * the rest of the Happy Meal to speak the most efficient protocol we could
 * get a clean link for.  The priority for link configurations, highest first
 * is:
 *                 100 Base-T Full Duplex
 *                 100 Base-T Half Duplex
 *                 10 Base-T Full Duplex
 *                 10 Base-T Half Duplex
 *
 * We start a new timer now, after a successful auto negotiation status has
 * been detected.  This timer just waits for the link-up bit to get set in
 * the BMCR of the DP83840.  When this occurs we print a kernel log message
 * describing the link type in use and the fact that it is up.
 *
 * If a fatal error of some sort is signalled and detected in the interrupt
 * service routine, and the chip is reset, or the link is ifconfig'd down
 * and then back up, this entire process repeats itself all over again.
 */
static int try_next_permutation(struct happy_meal *hp, struct hmeal_tcvregs *tregs)
{
	hp->sw_bmcr = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);

	/* Downgrade from full to half duplex.  Only possible
	 * via ethtool.
	 */
	if(hp->sw_bmcr & BMCR_FULLDPLX) {
		hp->sw_bmcr &= ~(BMCR_FULLDPLX);
		happy_meal_tcvr_write(hp, tregs, DP83840_BMCR, hp->sw_bmcr);
		return 0;
	}

	/* Downgrade from 100 to 10. */
	if(hp->sw_bmcr & BMCR_SPEED100) {
		hp->sw_bmcr &= ~(BMCR_SPEED100);
		happy_meal_tcvr_write(hp, tregs, DP83840_BMCR, hp->sw_bmcr);
		return 0;
	}

	/* We've tried everything. */
	return -1;
}

static void display_link_mode(struct happy_meal *hp, struct hmeal_tcvregs *tregs)
{
	printk("%s: Link is up using ", hp->hmename);
	if(hp->tcvr_type == external)
		printk("external ");
	else
		printk("internal ");
	printk("transceiver at ");
	hp->sw_lpa = happy_meal_tcvr_read(hp, tregs, DP83840_LPA);
	if(hp->sw_lpa & (LPA_100HALF | LPA_100FULL)) {
		if(hp->sw_lpa & LPA_100FULL)
			printk("100Mb/s, Full Duplex.\n");
		else
			printk("100Mb/s, Half Duplex.\n");
	} else {
		if(hp->sw_lpa & LPA_10FULL)
			printk("10Mb/s, Full Duplex.\n");
		else
			printk("10Mb/s, Half Duplex.\n");
	}
}

static void display_forced_link_mode(struct happy_meal *hp, struct hmeal_tcvregs *tregs)
{
	printk("%s: Link has been forced up using ", hp->hmename);
	if(hp->tcvr_type == external)
		printk("external ");
	else
		printk("internal ");
	printk("transceiver at ");
	hp->sw_bmcr = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);
	if(hp->sw_bmcr & BMCR_SPEED100)
		printk("100Mb/s, ");
	else
		printk("10Mb/s, ");
	if(hp->sw_bmcr & BMCR_FULLDPLX)
		printk("Full Duplex.\n");
	else
		printk("Half Duplex.\n");
}

static int set_happy_link_modes(struct happy_meal *hp, struct hmeal_tcvregs *tregs)
{
	int full;

	/* All we care about is making sure the bigmac tx_cfg has a
	 * proper duplex setting.
	 */
	if(hp->timer_state == arbwait) {
		hp->sw_lpa = happy_meal_tcvr_read(hp, tregs, DP83840_LPA);
		if(!(hp->sw_lpa & (LPA_10HALF | LPA_10FULL | LPA_100HALF | LPA_100FULL)))
			goto no_response;
		if(hp->sw_lpa & LPA_100FULL)
			full = 1;
		else if(hp->sw_lpa & LPA_100HALF)
			full = 0;
		else if(hp->sw_lpa & LPA_10FULL)
			full = 1;
		else
			full = 0;
	} else {
		/* Forcing a link mode. */
		hp->sw_bmcr = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);
		if(hp->sw_bmcr & BMCR_FULLDPLX)
			full = 1;
		else
			full = 0;
	}

	/* Before changing other bits in the tx_cfg register, and in
	 * general any of other the TX config registers too, you
	 * must:
	 * 1) Clear Enable
	 * 2) Poll with reads until that bit reads back as zero
	 * 3) Make TX configuration changes
	 * 4) Set Enable once more
	 */
	hme_write32(hp, &hp->bigmacregs->tx_cfg,
		    hme_read32(hp, &hp->bigmacregs->tx_cfg) &
		    ~(BIGMAC_TXCFG_ENABLE));
	while(hme_read32(hp, &hp->bigmacregs->tx_cfg) & BIGMAC_TXCFG_ENABLE)
		barrier();
	if(full) {
		hp->happy_flags |= HFLAG_FULL;
		hme_write32(hp, &hp->bigmacregs->tx_cfg,
			    hme_read32(hp, &hp->bigmacregs->tx_cfg) |
			    BIGMAC_TXCFG_FULLDPLX);
	} else {
		hp->happy_flags &= ~(HFLAG_FULL);
		hme_write32(hp, &hp->bigmacregs->tx_cfg,
			    hme_read32(hp, &hp->bigmacregs->tx_cfg) &
			    ~(BIGMAC_TXCFG_FULLDPLX));
	}
	hme_write32(hp, &hp->bigmacregs->tx_cfg,
		    hme_read32(hp, &hp->bigmacregs->tx_cfg) |
		    BIGMAC_TXCFG_ENABLE);
	return 0;
no_response:
	return 1;
}

static int happy_meal_init(struct happy_meal *hp, int from_irq);

static void happy_meal_timer(unsigned long data)
{
	struct happy_meal *hp = (struct happy_meal *) data;
	struct hmeal_tcvregs *tregs = hp->tcvregs;
	int restart_timer = 0;

	hp->timer_ticks++;
	switch(hp->timer_state) {
	case arbwait:
		/* Only allow for 5 ticks, thats 10 seconds and much too
		 * long to wait for arbitration to complete.
		 */
		if(hp->timer_ticks >= 10) {
			/* Enter force mode. */
	do_force_mode:
			hp->sw_bmcr = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);
			printk("%s: Auto-Negotiation unsuccessful, trying force link mode\n",
			       hp->hmename);
			hp->sw_bmcr = BMCR_SPEED100;
			happy_meal_tcvr_write(hp, tregs, DP83840_BMCR, hp->sw_bmcr);

			/* OK, seems we need do disable the transceiver for the first
			 * tick to make sure we get an accurate link state at the
			 * second tick.
			 */
			hp->sw_csconfig = happy_meal_tcvr_read(hp, tregs, DP83840_CSCONFIG);
			hp->sw_csconfig &= ~(CSCONFIG_TCVDISAB);
			happy_meal_tcvr_write(hp, tregs, DP83840_CSCONFIG, hp->sw_csconfig);

			hp->timer_state = ltrywait;
			hp->timer_ticks = 0;
			restart_timer = 1;
		} else {
			/* Anything interesting happen? */
			hp->sw_bmsr = happy_meal_tcvr_read(hp, tregs, DP83840_BMSR);
			if(hp->sw_bmsr & BMSR_ANEGCOMPLETE) {
				int ret;

				/* Just what we've been waiting for... */
				ret = set_happy_link_modes(hp, tregs);
				if(ret) {
					/* Ooops, something bad happened, go to force
					 * mode.
					 *
					 * XXX Broken hubs which don't support 802.3u
					 * XXX auto-negotiation make this happen as well.
					 */
					goto do_force_mode;
				}

				/* Success, at least so far, advance our state engine. */
				hp->timer_state = lupwait;
				restart_timer = 1;
			} else {
				restart_timer = 1;
			}
		}
		break;

	case lupwait:
		/* Auto negotiation was successful and we are awaiting a
		 * link up status.  I have decided to let this timer run
		 * forever until some sort of error is signalled, reporting
		 * a message to the user at 10 second intervals.
		 */
		hp->sw_bmsr = happy_meal_tcvr_read(hp, tregs, DP83840_BMSR);
		if(hp->sw_bmsr & BMSR_LSTATUS) {
			/* Wheee, it's up, display the link mode in use and put
			 * the timer to sleep.
			 */
			display_link_mode(hp, tregs);
			hp->timer_state = asleep;
			restart_timer = 0;
		} else {
			if(hp->timer_ticks >= 10) {
				printk("%s: Auto negotiation successful, link still "
				       "not completely up.\n", hp->hmename);
				hp->timer_ticks = 0;
				restart_timer = 1;
			} else {
				restart_timer = 1;
			}
		}
		break;

	case ltrywait:
		/* Making the timeout here too long can make it take
		 * annoyingly long to attempt all of the link mode
		 * permutations, but then again this is essentially
		 * error recovery code for the most part.
		 */
		hp->sw_bmsr = happy_meal_tcvr_read(hp, tregs, DP83840_BMSR);
		hp->sw_csconfig = happy_meal_tcvr_read(hp, tregs, DP83840_CSCONFIG);
		if(hp->timer_ticks == 1) {
			/* Re-enable transceiver, we'll re-enable the transceiver next
			 * tick, then check link state on the following tick. */
			hp->sw_csconfig |= CSCONFIG_TCVDISAB;
			happy_meal_tcvr_write(hp, tregs, DP83840_CSCONFIG, hp->sw_csconfig);
			restart_timer = 1;
			break;
		}
		if(hp->timer_ticks == 2) {
			hp->sw_csconfig &= ~(CSCONFIG_TCVDISAB);
			happy_meal_tcvr_write(hp, tregs, DP83840_CSCONFIG, hp->sw_csconfig);
			restart_timer = 1;
			break;
		}
		if(hp->sw_bmsr & BMSR_LSTATUS) {
			/* Force mode selection success. */
			display_forced_link_mode(hp, tregs);
			set_happy_link_modes(hp, tregs); /* XXX error? then what? */
			hp->timer_state = asleep;
			restart_timer = 0;
		} else {
			if(hp->timer_ticks >= 4) { /* 6 seconds or so... */
				int ret;

				ret = try_next_permutation(hp, tregs);
				if(ret == -1) {
					/* Aieee, tried them all, reset the
					 * chip and try all over again.
					 */

					/* Let the user know... */
					printk("%s: Link down, cable problem?\n",
					       hp->hmename);

					ret = happy_meal_init(hp, 0);
					if(ret) {
						/* ho hum... */
						printk("%s: Error, cannot re-init the "
						       "Happy Meal.\n", hp->hmename);
					}
					return;
				}
				hp->sw_csconfig = happy_meal_tcvr_read(hp, tregs, DP83840_CSCONFIG);
				hp->sw_csconfig |= CSCONFIG_TCVDISAB;
				happy_meal_tcvr_write(hp, tregs, DP83840_CSCONFIG, hp->sw_csconfig);
				hp->timer_ticks = 0;
				restart_timer = 1;
			} else {
				restart_timer = 1;
			}
		}
		break;

	case asleep:
	default:
		/* Can't happens.... */
		printk("%s: Aieee, link timer is asleep but we got one anyways!\n",
		       hp->hmename);
		restart_timer = 0;
		hp->timer_ticks = 0;
		hp->timer_state = asleep; /* foo on you */
		break;
	};

	if(restart_timer) {
		hp->happy_timer.expires = jiffies + ((12 * HZ)/10); /* 1.2 sec. */
		add_timer(&hp->happy_timer);
	}
}

#define TX_RESET_TRIES     32
#define RX_RESET_TRIES     32

static void happy_meal_tx_reset(struct happy_meal *hp,
				       struct hmeal_bigmacregs *bregs)
{
	int tries = TX_RESET_TRIES;

	HMD(("happy_meal_tx_reset: reset, "));

	/* Would you like to try our SMCC Delux? */
	hme_write32(hp, &bregs->tx_swreset, 0);
	while((hme_read32(hp, &bregs->tx_swreset) & 1) && --tries)
		udelay(20);

	/* Lettuce, tomato, buggy hardware (no extra charge)? */
	if(!tries)
		printk("happy meal: Transceiver BigMac ATTACK!");

	/* Take care. */
	HMD(("done\n"));
}

static void happy_meal_rx_reset(struct happy_meal *hp,
				       struct hmeal_bigmacregs *bregs)
{
	int tries = RX_RESET_TRIES;

	HMD(("happy_meal_rx_reset: reset, "));

	/* We have a special on GNU/Viking hardware bugs today. */
	hme_write32(hp, &bregs->rx_swreset, 0);
	while((hme_read32(hp, &bregs->rx_swreset) & 1) && --tries)
		udelay(20);

	/* Will that be all? */
	if(!tries)
		printk("happy meal: Receiver BigMac ATTACK!");

	/* Don't forget your vik_1137125_wa.  Have a nice day. */
	HMD(("done\n"));
}

#define STOP_TRIES         16

static void happy_meal_stop(struct happy_meal *hp,
				   struct hmeal_gregs *gregs)
{
	int tries = STOP_TRIES;

	HMD(("happy_meal_stop: reset, "));

	/* We're consolidating our STB products, it's your lucky day. */
	hme_write32(hp, &gregs->sw_reset, GREG_RESET_ALL);
	while(hme_read32(hp, &gregs->sw_reset) && --tries)
		udelay(20);

	/* Come back next week when we are "Sun Microelectronics". */
	if(!tries)
		printk("happy meal: Fry guys.");

	/* Remember: "Different name, same old buggy as shit hardware." */
	HMD(("done\n"));
}

#if 0 /* hmm.. */
static void happy_meal_poll_start(struct happy_meal *hp,
					 struct hmeal_tcvregs *tregs)
{
	unsigned long tmp;
	int speed;

	ASD(("happy_meal_poll_start: "));
	if(!(hp->happy_flags & HFLAG_POLLENABLE)) {
		HMD(("polling disabled, return\n"));
		return;
	}

	/* Start the MIF polling on the external transceiver. */
	ASD(("polling on, "));
	tmp = hme_read32(hp, &tregs->cfg);
	tmp &= ~(TCV_CFG_PDADDR | TCV_CFG_PREGADDR);
	tmp |= ((hp->paddr & 0x1f) << 10);
	tmp |= (TCV_PADDR_ETX << 3);
	tmp |= TCV_CFG_PENABLE;
	hme_write32(hp, &tregs->cfg, tmp);

	/* Let the bits set. */
	udelay(200);

	/* We are polling now. */
	ASD(("now polling, "));
	hp->happy_flags |= HFLAG_POLL;

	/* Clear the poll flags, get the basic status as of now. */
	hp->poll_flag = 0;
	hp->poll_data = tregs->status >> 16;

	if(hp->happy_flags & HFLAG_AUTO)
		speed = hp->auto_speed;
	else
		speed = hp->forced_speed;

	/* Listen only for the MIF interrupts we want to hear. */
	ASD(("mif ints on, "));
	if(speed == 100)
		hme_write32(hp, &tregs->int_mask, 0xfffb);
	else
		hme_write32(hp, &tregs->int_mask, 0xfff9);
	ASD(("done\n"));
}
#endif /* hmm.. */

static void happy_meal_poll_stop(struct happy_meal *hp,
					struct hmeal_tcvregs *tregs)
{
	ASD(("happy_meal_poll_stop: "));

	/* If polling disabled or not polling already, nothing to do. */
	if((hp->happy_flags & (HFLAG_POLLENABLE | HFLAG_POLL)) !=
	   (HFLAG_POLLENABLE | HFLAG_POLL)) {
		ASD(("not polling, return\n"));
		return;
	}

	/* Shut up the MIF. */
	ASD(("were polling, mif ints off, "));
	hme_write32(hp, &tregs->int_mask, 0xffff);

	/* Turn off polling. */
	ASD(("polling off, "));
	hme_write32(hp, &tregs->cfg,
		    hme_read32(hp, &tregs->cfg) & ~(TCV_CFG_PENABLE));

	/* We are no longer polling. */
	hp->happy_flags &= ~(HFLAG_POLL);

	/* Let the bits set. */
	udelay(200);
	ASD(("done\n"));
}

/* Only Sun can take such nice parts and fuck up the programming interface
 * like this.  Good job guys...
 */
#define TCVR_RESET_TRIES       16 /* It should reset quickly        */
#define TCVR_UNISOLATE_TRIES   32 /* Dis-isolation can take longer. */

static int happy_meal_tcvr_reset(struct happy_meal *hp,
				 struct hmeal_tcvregs *tregs)
{
	unsigned long tconfig;
	int result, tries = TCVR_RESET_TRIES;

	tconfig = hme_read32(hp, &tregs->cfg);
	ASD(("happy_meal_tcvr_reset: tcfg<%08lx> ", tconfig));
	if(hp->tcvr_type == external) {
		ASD(("external<"));
		hme_write32(hp, &tregs->cfg, tconfig & ~(TCV_CFG_PSELECT));
		hp->tcvr_type = internal;
		hp->paddr = TCV_PADDR_ITX;
		ASD(("ISOLATE,"));
		happy_meal_tcvr_write(hp, tregs, DP83840_BMCR,
				      (BMCR_LOOPBACK|BMCR_PDOWN|BMCR_ISOLATE));
		result = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);
		if(result == TCVR_FAILURE) {
			ASD(("phyread_fail>\n"));
			return -1;
		}
		ASD(("phyread_ok,PSELECT>"));
		hme_write32(hp, &tregs->cfg, tconfig | TCV_CFG_PSELECT);
		hp->tcvr_type = external;
		hp->paddr = TCV_PADDR_ETX;
	} else {
		if(tconfig & TCV_CFG_MDIO1) {
			ASD(("internal<PSELECT,"));
			hme_write32(hp, &tregs->cfg, (tconfig | TCV_CFG_PSELECT));
			ASD(("ISOLATE,"));
			happy_meal_tcvr_write(hp, tregs, DP83840_BMCR,
					      (BMCR_LOOPBACK|BMCR_PDOWN|BMCR_ISOLATE));
			result = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);
			if(result == TCVR_FAILURE) {
				ASD(("phyread_fail>\n"));
				return -1;
			}
			ASD(("phyread_ok,~PSELECT>"));
			hme_write32(hp, &tregs->cfg, (tconfig & ~(TCV_CFG_PSELECT)));
			hp->tcvr_type = internal;
			hp->paddr = TCV_PADDR_ITX;
		}
	}

	ASD(("BMCR_RESET "));
	happy_meal_tcvr_write(hp, tregs, DP83840_BMCR, BMCR_RESET);

	while(--tries) {
		result = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);
		if(result == TCVR_FAILURE)
			return -1;
		hp->sw_bmcr = result;
		if(!(result & BMCR_RESET))
			break;
		udelay(20);
	}
	if(!tries) {
		ASD(("BMCR RESET FAILED!\n"));
		return -1;
	}
	ASD(("RESET_OK\n"));

	/* Get fresh copies of the PHY registers. */
	hp->sw_bmsr      = happy_meal_tcvr_read(hp, tregs, DP83840_BMSR);
	hp->sw_physid1   = happy_meal_tcvr_read(hp, tregs, DP83840_PHYSID1);
	hp->sw_physid2   = happy_meal_tcvr_read(hp, tregs, DP83840_PHYSID2);
	hp->sw_advertise = happy_meal_tcvr_read(hp, tregs, DP83840_ADVERTISE);

	ASD(("UNISOLATE"));
	hp->sw_bmcr &= ~(BMCR_ISOLATE);
	happy_meal_tcvr_write(hp, tregs, DP83840_BMCR, hp->sw_bmcr);

	tries = TCVR_UNISOLATE_TRIES;
	while(--tries) {
		result = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);
		if(result == TCVR_FAILURE)
			return -1;
		if(!(result & BMCR_ISOLATE))
			break;
		udelay(20);
	}
	if(!tries) {
		ASD((" FAILED!\n"));
		return -1;
	}
	ASD((" SUCCESS and CSCONFIG_DFBYPASS\n"));
	result = happy_meal_tcvr_read(hp, tregs, DP83840_CSCONFIG);
	happy_meal_tcvr_write(hp, tregs, DP83840_CSCONFIG, (result | CSCONFIG_DFBYPASS));
	return 0;
}

/* Figure out whether we have an internal or external transceiver. */
static void happy_meal_transceiver_check(struct happy_meal *hp,
					 struct hmeal_tcvregs *tregs)
{
	unsigned long tconfig = hme_read32(hp, &tregs->cfg);

	ASD(("happy_meal_transceiver_check: tcfg=%08lx ", tconfig));
	if(hp->happy_flags & HFLAG_POLL) {
		/* If we are polling, we must stop to get the transceiver type. */
		ASD(("<polling> "));
		if(hp->tcvr_type == internal) {
			if(tconfig & TCV_CFG_MDIO1) {
				ASD(("<internal> <poll stop> "));
				happy_meal_poll_stop(hp, tregs);
				hp->paddr = TCV_PADDR_ETX;
				hp->tcvr_type = external;
				ASD(("<external>\n"));
				tconfig &= ~(TCV_CFG_PENABLE);
				tconfig |= TCV_CFG_PSELECT;
				hme_write32(hp, &tregs->cfg, tconfig);
			}
		} else {
			if(hp->tcvr_type == external) {
				ASD(("<external> "));
				if(!(hme_read32(hp, &tregs->status) >> 16)) {
					ASD(("<poll stop> "));
					happy_meal_poll_stop(hp, tregs);
					hp->paddr = TCV_PADDR_ITX;
					hp->tcvr_type = internal;
					ASD(("<internal>\n"));
					hme_write32(hp, &tregs->cfg,
						    hme_read32(hp, &tregs->cfg) &
						    ~(TCV_CFG_PSELECT));
				}
				ASD(("\n"));
			} else {
				ASD(("<none>\n"));
			}
		}
	} else {
		unsigned long reread = hme_read32(hp, &tregs->cfg);

		/* Else we can just work off of the MDIO bits. */
		ASD(("<not polling> "));
		if(reread & TCV_CFG_MDIO1) {
			hme_write32(hp, &tregs->cfg, tconfig | TCV_CFG_PSELECT);
			hp->paddr = TCV_PADDR_ETX;
			hp->tcvr_type = external;
			ASD(("<external>\n"));
		} else {
			if(reread & TCV_CFG_MDIO0) {
				hme_write32(hp, &tregs->cfg,
					    tconfig & ~(TCV_CFG_PSELECT));
				hp->paddr = TCV_PADDR_ITX;
				hp->tcvr_type = internal;
				ASD(("<internal>\n"));
			} else {
				printk("happy meal: Transceiver and a coke please.");
				hp->tcvr_type = none; /* Grrr... */
				ASD(("<none>\n"));
			}
		}
	}
}

/* The receive ring buffers are a bit tricky to get right.  Here goes...
 *
 * The buffers we dma into must be 64 byte aligned.  So we use a special
 * alloc_skb() routine for the happy meal to allocate 64 bytes more than
 * we really need.
 *
 * We use skb_reserve() to align the data block we get in the skb.  We
 * also program the etxregs->cfg register to use an offset of 2.  This
 * imperical constant plus the ethernet header size will always leave
 * us with a nicely aligned ip header once we pass things up to the
 * protocol layers.
 *
 * The numbers work out to:
 *
 *         Max ethernet frame size         1518
 *         Ethernet header size              14
 *         Happy Meal base offset             2
 *
 * Say a skb data area is at 0xf001b010, and its size alloced is
 * (ETH_FRAME_LEN + 64 + 2) = (1514 + 64 + 2) = 1580 bytes.
 *
 * First our alloc_skb() routine aligns the data base to a 64 byte
 * boundry.  We now have 0xf001b040 as our skb data address.  We
 * plug this into the receive descriptor address.
 *
 * Next, we skb_reserve() 2 bytes to account for the Happy Meal offset.
 * So now the data we will end up looking at starts at 0xf001b042.  When
 * the packet arrives, we will check out the size received and subtract
 * this from the skb->length.  Then we just pass the packet up to the
 * protocols as is, and allocate a new skb to replace this slot we have
 * just received from.
 *
 * The ethernet layer will strip the ether header from the front of the
 * skb we just sent to it, this leaves us with the ip header sitting
 * nicely aligned at 0xf001b050.  Also, for tcp and udp packets the
 * Happy Meal has even checksummed the tcp/udp data for us.  The 16
 * bit checksum is obtained from the low bits of the receive descriptor
 * flags, thus:
 *
 * 	skb->csum = rxd->rx_flags & 0xffff;
 * 	skb->ip_summed = CHECKSUM_HW;
 *
 * before sending off the skb to the protocols, and we are good as gold.
 */
static void happy_meal_clean_rings(struct happy_meal *hp)
{
	int i;

	for(i = 0; i < RX_RING_SIZE; i++) {
		if(hp->rx_skbs[i] != NULL) {
			dev_kfree_skb(hp->rx_skbs[i]);
			hp->rx_skbs[i] = NULL;
		}
	}

	for(i = 0; i < TX_RING_SIZE; i++) {
		if(hp->tx_skbs[i] != NULL) {
			dev_kfree_skb(hp->tx_skbs[i]);
			hp->tx_skbs[i] = NULL;
		}
	}
}

static void happy_meal_init_rings(struct happy_meal *hp, int from_irq)
{
	struct hmeal_init_block *hb = hp->happy_block;
	struct device *dev = &hp->edev;
	int i, gfp_flags = GFP_KERNEL;

	if(from_irq)
		gfp_flags = GFP_ATOMIC;

	HMD(("happy_meal_init_rings: counters to zero, "));
	hp->rx_new = hp->rx_old = hp->tx_new = hp->tx_old = 0;

	/* Free any skippy bufs left around in the rings. */
	HMD(("clean, "));
	happy_meal_clean_rings(hp);

	/* Now get new skippy bufs for the receive ring. */
	HMD(("init rxring, "));
	for(i = 0; i < RX_RING_SIZE; i++) {
		struct sk_buff *skb;

		skb = dev_alloc_skb(RX_BUF_ALLOC_SIZE);
		if(!skb)
			continue;
if (((int)skb->data & 63) != 0) {
   printk("init skb->data 0x%x\n", skb->data); /* P3 */
}
		hp->rx_skbs[i] = skb;
		skb->dev = dev;

		/* Because we reserve afterwards. */
		skb_put(skb, (ETH_FRAME_LEN + RX_OFFSET));

		if(hp->happy_flags & HFLAG_PCI) {
			pcihme_write_rxd(&hb->happy_meal_rxd[i],
					(RXFLAG_OWN |
					 ((RX_BUF_ALLOC_SIZE-RX_OFFSET)<<16)),
					(__u32)virt_to_bus((void *)skb->data));
		} else
		{
			hb->happy_meal_rxd[i].rx_addr = sbus_dvma_addr(skb->data);
			hb->happy_meal_rxd[i].rx_flags =
				(RXFLAG_OWN | ((RX_BUF_ALLOC_SIZE - RX_OFFSET) << 16));
		}
		skb_reserve(skb, RX_OFFSET);
	}

	HMD(("init txring, "));
	for(i = 0; i < TX_RING_SIZE; i++)
		hb->happy_meal_txd[i].tx_flags = 0;
	HMD(("done\n"));
}

static void happy_meal_begin_auto_negotiation(struct happy_meal *hp,
					      struct hmeal_tcvregs *tregs,
					      struct ethtool_cmd *ep)
{
	int timeout;

	/* Read all of the registers we are interested in now. */
	hp->sw_bmsr      = happy_meal_tcvr_read(hp, tregs, DP83840_BMSR);
	hp->sw_bmcr      = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);
	hp->sw_physid1   = happy_meal_tcvr_read(hp, tregs, DP83840_PHYSID1);
	hp->sw_physid2   = happy_meal_tcvr_read(hp, tregs, DP83840_PHYSID2);

	/* XXX Check BMSR_ANEGCAPABLE, should not be necessary though. */

	hp->sw_advertise = happy_meal_tcvr_read(hp, tregs, DP83840_ADVERTISE);
	if(ep == NULL || ep->autoneg == AUTONEG_ENABLE) {
		/* Advertise everything we can support. */
		if(hp->sw_bmsr & BMSR_10HALF)
			hp->sw_advertise |= (ADVERTISE_10HALF);
		else
			hp->sw_advertise &= ~(ADVERTISE_10HALF);

		if(hp->sw_bmsr & BMSR_10FULL)
			hp->sw_advertise |= (ADVERTISE_10FULL);
		else
			hp->sw_advertise &= ~(ADVERTISE_10FULL);
		if(hp->sw_bmsr & BMSR_100HALF)
			hp->sw_advertise |= (ADVERTISE_100HALF);
		else
			hp->sw_advertise &= ~(ADVERTISE_100HALF);
		if(hp->sw_bmsr & BMSR_100FULL)
			hp->sw_advertise |= (ADVERTISE_100FULL);
		else
			hp->sw_advertise &= ~(ADVERTISE_100FULL);
		happy_meal_tcvr_write(hp, tregs, DP83840_ADVERTISE, hp->sw_advertise);

		/* XXX Currently no Happy Meal cards I know off support 100BaseT4,
		 * XXX and this is because the DP83840 does not support it, changes
		 * XXX would need to be made to the tx/rx logic in the driver as well
		 * XXX so I completely skip checking for it in the BMSR for now.
		 */

#ifdef AUTO_SWITCH_DEBUG
		ASD(("%s: Advertising [ ", hp->dev->name));
		if(hp->sw_advertise & ADVERTISE_10HALF)
			ASD(("10H "));
		if(hp->sw_advertise & ADVERTISE_10FULL)
			ASD(("10F "));
		if(hp->sw_advertise & ADVERTISE_100HALF)
			ASD(("100H "));
		if(hp->sw_advertise & ADVERTISE_100FULL)
			ASD(("100F "));
#endif

		/* Enable Auto-Negotiation, this is usually on already... */
		hp->sw_bmcr |= BMCR_ANENABLE;
		happy_meal_tcvr_write(hp, tregs, DP83840_BMCR, hp->sw_bmcr);

		/* Restart it to make sure it is going. */
		hp->sw_bmcr |= BMCR_ANRESTART;
		happy_meal_tcvr_write(hp, tregs, DP83840_BMCR, hp->sw_bmcr);

		/* BMCR_ANRESTART self clears when the process has begun. */

		timeout = 64;  /* More than enough. */
		while(--timeout) {
			hp->sw_bmcr = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);
			if(!(hp->sw_bmcr & BMCR_ANRESTART))
				break; /* got it. */
			udelay(10);
		}
		if(!timeout) {
			printk("%s: Happy Meal would not start auto negotiation "
			    "BMCR=0x%x\n", hp->hmename, hp->sw_bmcr & 0xFFFF);
			printk("%s: Performing force link detection.\n",
			       hp->hmename);
			goto force_link;
		} else {
			hp->timer_state = arbwait;
		}
	} else {
force_link:
		/* Force the link up, trying first a particular mode.
		 * Either we are here at the request of ethtool or
		 * because the Happy Meal would not start to autoneg.
		 */

		/* Disable auto-negotiation in BMCR, enable the duplex and
		 * speed setting, init the timer state machine, and fire it off.
		 */
		if(ep == NULL || ep->autoneg == AUTONEG_ENABLE) {
			hp->sw_bmcr = BMCR_SPEED100;
		} else {
			if(ep->speed == SPEED_100)
				hp->sw_bmcr = BMCR_SPEED100;
			else
				hp->sw_bmcr = 0;
			if(ep->duplex == DUPLEX_FULL)
				hp->sw_bmcr |= BMCR_FULLDPLX;
		}
		happy_meal_tcvr_write(hp, tregs, DP83840_BMCR, hp->sw_bmcr);

		/* OK, seems we need do disable the transceiver for the first
		 * tick to make sure we get an accurate link state at the
		 * second tick.
		 */
		hp->sw_csconfig = happy_meal_tcvr_read(hp, tregs,
						       DP83840_CSCONFIG);
		hp->sw_csconfig &= ~(CSCONFIG_TCVDISAB);
		happy_meal_tcvr_write(hp, tregs, DP83840_CSCONFIG,
				      hp->sw_csconfig);

		hp->timer_state = ltrywait;
	}

	hp->timer_ticks = 0;
	hp->happy_timer.expires = jiffies + (12 * HZ)/10;  /* 1.2 sec. */
	hp->happy_timer.data = (unsigned long) hp;
	hp->happy_timer.function = &happy_meal_timer;
	add_timer(&hp->happy_timer);
}

#define CRC_POLYNOMIAL_BE 0x04c11db7UL  /* Ethernet CRC, big endian */
#define CRC_POLYNOMIAL_LE 0xedb88320UL  /* Ethernet CRC, little endian */

static int happy_meal_init(struct happy_meal *hp, int from_irq)
{
	struct hmeal_gregs   *gregs        = hp->gregs;
	struct hmeal_etxregs *etxregs      = hp->etxregs;
	struct hmeal_erxregs *erxregs      = hp->erxregs;
	struct hmeal_bigmacregs *bregs     = hp->bigmacregs;
	struct hmeal_tcvregs *tregs        = hp->tcvregs;
	unsigned long regtmp, rxcfg;
	unsigned char *e = &hp->edev.dev_addr[0];

	/* If auto-negotiation timer is running, kill it. */
	del_timer(&hp->happy_timer);

	HMD(("happy_meal_init: happy_flags[%x] ", hp->happy_flags));
	if(!(hp->happy_flags & HFLAG_INIT)) {
		HMD(("set HFLAG_INIT, "));
		hp->happy_flags |= HFLAG_INIT;
	}

	/* Stop polling. */
	HMD(("to happy_meal_poll_stop\n"));
	happy_meal_poll_stop(hp, tregs);

	/* Stop transmitter and receiver. */
	HMD(("happy_meal_init: to happy_meal_stop\n"));
	happy_meal_stop(hp, gregs);

	/* Alloc and reset the tx/rx descriptor chains. */
	HMD(("happy_meal_init: to happy_meal_init_rings\n"));
	happy_meal_init_rings(hp, from_irq);

	/* Shut up the MIF. */
	HMD(("happy_meal_init: Disable all MIF irqs (old[%x]), ",
	     hme_read32(hp, &tregs->int_mask)));
	hme_write32(hp, &tregs->int_mask, 0xffff);

	/* See if we can enable the MIF frame on this card to speak to the DP83840. */
	if(hp->happy_flags & HFLAG_FENABLE) {
		HMD(("use frame old[%x], ",
		     hme_read32(hp, &tregs->cfg)));
		hme_write32(hp, &tregs->cfg,
			    hme_read32(hp, &tregs->cfg) & ~(TCV_CFG_BENABLE));
	} else {
		HMD(("use bitbang old[%x], ",
		     hme_read32(hp, &tregs->cfg)));
		hme_write32(hp, &tregs->cfg,
			    hme_read32(hp, &tregs->cfg) | TCV_CFG_BENABLE);
	}

	/* Check the state of the transceiver. */
	HMD(("to happy_meal_transceiver_check\n"));
	happy_meal_transceiver_check(hp, tregs);

	/* Put the Big Mac into a sane state. */
	HMD(("happy_meal_init: "));
	switch(hp->tcvr_type) {
	case none:
		/* Cannot operate if we don't know the transceiver type! */
		HMD(("AAIEEE no transceiver type, EAGAIN"));
		return -EAGAIN;

	case internal:
		/* Using the MII buffers. */
		HMD(("internal, using MII, "));
		hme_write32(hp, &bregs->xif_cfg, 0);
		break;

	case external:
		/* Not using the MII, disable it. */
		HMD(("external, disable MII, "));
		hme_write32(hp, &bregs->xif_cfg, BIGMAC_XCFG_MIIDISAB);
		break;
	};

	if(happy_meal_tcvr_reset(hp, tregs))
		return -EAGAIN;

	/* Reset the Happy Meal Big Mac transceiver and the receiver. */
	HMD(("tx/rx reset, "));
	happy_meal_tx_reset(hp, bregs);
	happy_meal_rx_reset(hp, bregs);

	/* Set jam size and inter-packet gaps to reasonable defaults. */
	HMD(("jsize/ipg1/ipg2, "));
	hme_write32(hp, &bregs->jsize, DEFAULT_JAMSIZE);
	hme_write32(hp, &bregs->ipkt_gap1, DEFAULT_IPG1);
	hme_write32(hp, &bregs->ipkt_gap2, DEFAULT_IPG2);

	/* Load up the MAC address and random seed. */
	HMD(("rseed/macaddr, "));

	/* The docs recommend to use the 10LSB of our MAC here. */
	hme_write32(hp, &bregs->rand_seed, ((e[5] | e[4]<<8)&0x3ff));

	hme_write32(hp, &bregs->mac_addr2, ((e[4] << 8) | e[5]));
	hme_write32(hp, &bregs->mac_addr1, ((e[2] << 8) | e[3]));
	hme_write32(hp, &bregs->mac_addr0, ((e[0] << 8) | e[1]));

	HMD(("htable, "));
	{
#if 0
		u16 hash_table[4];
		struct dev_mc_list *dmi = hp->dev->mc_list;
		char *addrs;
		int i, j, bit, byte;
		__u32 crc, poly = CRC_POLYNOMIAL_LE;

		for(i = 0; i < 4; i++)
			hash_table[i] = 0;

		for(i = 0; i < hp->dev->mc_count; i++) {
			addrs = dmi->dmi_addr;
			dmi = dmi->next;

			if(!(*addrs & 1))
				continue;

			crc = 0xffffffffU;
			for(byte = 0; byte < 6; byte++) {
				for(bit = *addrs++, j = 0; j < 8; j++, bit >>= 1) {
					int test;

					test = ((bit ^ crc) & 0x01);
					crc >>= 1;
					if(test)
						crc = crc ^ poly;
				}
			}
			crc >>= 26;
			hash_table[crc >> 4] |= 1 << (crc & 0xf);
		}
		hme_write32(hp, &bregs->htable0, hash_table[0]);
		hme_write32(hp, &bregs->htable1, hash_table[1]);
		hme_write32(hp, &bregs->htable2, hash_table[2]);
		hme_write32(hp, &bregs->htable3, hash_table[3]);
#else
		hme_write32(hp, &bregs->htable0, 0xffff);
		hme_write32(hp, &bregs->htable1, 0xffff);
		hme_write32(hp, &bregs->htable2, 0xffff);
		hme_write32(hp, &bregs->htable3, 0xffff);
#endif
	}

	/* Set the RX and TX ring ptrs. */
	HMD(("ring ptrs rxr[%x] txr[%x]\n",
	     (hp->hblock_dvma + hblock_offset(happy_meal_rxd, 0)),
	     (hp->hblock_dvma + hblock_offset(happy_meal_txd, 0))));
	hme_write32(hp, &erxregs->rx_ring,
		    (hp->hblock_dvma + hblock_offset(happy_meal_rxd, 0)));
	hme_write32(hp, &etxregs->tx_ring,
		    (hp->hblock_dvma + hblock_offset(happy_meal_txd, 0)));

	/* Set the supported burst sizes. */
	HMD(("happy_meal_init: old[%x] bursts<",
	     hme_read32(hp, &gregs->cfg)));

#ifdef __sparc_v9__	/* P3: too harsh, there are PCI 32 bitters now. */
	/* XXX Can sun4d do these too? */
	if(hp->happy_bursts & DMA_BURST64) {
		__u32 gcfg = GREG_CFG_BURST64;

		/* I have no idea if I should set the extended
		 * transfer mode bit for Cheerio, so for now I
		 * do not.  -DaveM
		 */
		if((hp->happy_flags & HFLAG_PCI) == 0) {
			mmu_set_sbus64(hp->happy_sbus_dev,
				       hp->happy_bursts);
			gcfg |= GREG_CFG_64BIT;
		}

		HMD(("64>"));
		hme_write32(hp, &gregs->cfg, gcfg);
	} else
#endif
	HMD(("32>"));
	hme_write32(hp, &gregs->cfg, GREG_CFG_BURST32);

	/* Turn off interrupts we do not want to hear. */
	HMD((", enable global interrupts, "));
	hme_write32(hp, &gregs->imask,
		    (GREG_IMASK_GOTFRAME | GREG_IMASK_RCNTEXP |
		     GREG_IMASK_SENTFRAME | GREG_IMASK_TXPERR));

	/* Set the transmit ring buffer size. */
	HMD(("tx rsize=%d oreg[%x], ", (int)TX_RING_SIZE,
	     hme_read32(hp, &etxregs->tx_rsize)));
	hme_write32(hp, &etxregs->tx_rsize, (TX_RING_SIZE >> ETX_RSIZE_SHIFT) - 1);

	/* Enable transmitter DVMA. */
	HMD(("tx dma enable old[%x], ",
	     hme_read32(hp, &etxregs->cfg)));
	hme_write32(hp, &etxregs->cfg,
		    hme_read32(hp, &etxregs->cfg) | ETX_CFG_DMAENABLE);

	/* This chip really rots, for the receiver sometimes when you
	 * write to it's control registers not all the bits get there
	 * properly.  I cannot think of a sane way to provide complete
	 * coverage for this hardware bug yet.
	 */
	HMD(("erx regs bug old[%x]\n",
	     hme_read32(hp, &erxregs->cfg)));
	hme_write32(hp, &erxregs->cfg, ERX_CFG_DEFAULT(RX_OFFSET));
	regtmp = hme_read32(hp, &erxregs->cfg);
	hme_write32(hp, &erxregs->cfg, ERX_CFG_DEFAULT(RX_OFFSET));
	if(hme_read32(hp, &erxregs->cfg) != ERX_CFG_DEFAULT(RX_OFFSET)) {
		printk("happy meal: Eieee, rx config register gets greasy fries.\n");
		printk("happy meal: Trying to set %x, reread gives %x\n",
		       ERX_CFG_DEFAULT(RX_OFFSET), (int)regtmp);
		/* XXX Should return failure here... */
	}

	/* Enable Big Mac hash table filter. */
	HMD(("happy_meal_init: enable hash rx_cfg_old[%x], ",
	     hme_read32(hp, &bregs->rx_cfg)));
	rxcfg = BIGMAC_RXCFG_HENABLE;
	hme_write32(hp, &bregs->rx_cfg, rxcfg);

	/* Let the bits settle in the chip. */
	udelay(10);

	/* Ok, configure the Big Mac transmitter. */
	HMD(("BIGMAC init, "));
	regtmp = 0;
	if(hp->happy_flags & HFLAG_FULL)
		regtmp |= BIGMAC_TXCFG_FULLDPLX;
	hme_write32(hp, &bregs->tx_cfg, regtmp | BIGMAC_TXCFG_DGIVEUP);

	/* Enable the output drivers no matter what. */
	regtmp = BIGMAC_XCFG_ODENABLE;

	/* If card can do lance mode, enable it. */
	if(hp->happy_flags & HFLAG_LANCE)
		regtmp |= (DEFAULT_IPG0 << 5) | BIGMAC_XCFG_LANCE;

	/* Disable the MII buffers if using external transceiver. */
	if(hp->tcvr_type == external)
		regtmp |= BIGMAC_XCFG_MIIDISAB;

	HMD(("XIF config old[%x], ",
	     hme_read32(hp, &bregs->xif_cfg)));
	hme_write32(hp, &bregs->xif_cfg, regtmp);

	/* Start things up. */
	HMD(("tx old[%x] and rx [%x] ON!\n",
	     hme_read32(hp, &bregs->tx_cfg),
	     hme_read32(hp, &bregs->rx_cfg)));
	hme_write32(hp, &bregs->tx_cfg,
		    hme_read32(hp, &bregs->tx_cfg) | BIGMAC_TXCFG_ENABLE);
	hme_write32(hp, &bregs->rx_cfg,
		    hme_read32(hp, &bregs->rx_cfg) | BIGMAC_RXCFG_ENABLE);

	/* Get the autonegotiation started, and the watch timer ticking. */
	happy_meal_begin_auto_negotiation(hp, tregs, NULL);

	/* Success. */
	return 0;
}

static void happy_meal_set_initial_advertisement(struct happy_meal *hp)
{
	struct hmeal_tcvregs *tregs	= hp->tcvregs;
	struct hmeal_bigmacregs *bregs	= hp->bigmacregs;
	struct hmeal_gregs *gregs	= hp->gregs;

	happy_meal_stop(hp, gregs);
	hme_write32(hp, &tregs->int_mask, 0xffff);
	if(hp->happy_flags & HFLAG_FENABLE)
		hme_write32(hp, &tregs->cfg,
			    hme_read32(hp, &tregs->cfg) & ~(TCV_CFG_BENABLE));
	else
		hme_write32(hp, &tregs->cfg,
			    hme_read32(hp, &tregs->cfg) | TCV_CFG_BENABLE);
	happy_meal_transceiver_check(hp, tregs);
	switch(hp->tcvr_type) {
	case none:
		return;
	case internal:
		hme_write32(hp, &bregs->xif_cfg, 0);
		break;
	case external:
		hme_write32(hp, &bregs->xif_cfg, BIGMAC_XCFG_MIIDISAB);
		break;
	};
	if(happy_meal_tcvr_reset(hp, tregs))
		return;

	/* Latch PHY registers as of now. */
	hp->sw_bmsr      = happy_meal_tcvr_read(hp, tregs, DP83840_BMSR);
	hp->sw_advertise = happy_meal_tcvr_read(hp, tregs, DP83840_ADVERTISE);

	/* Advertise everything we can support. */
	if(hp->sw_bmsr & BMSR_10HALF)
		hp->sw_advertise |= (ADVERTISE_10HALF);
	else
		hp->sw_advertise &= ~(ADVERTISE_10HALF);

	if(hp->sw_bmsr & BMSR_10FULL)
		hp->sw_advertise |= (ADVERTISE_10FULL);
	else
		hp->sw_advertise &= ~(ADVERTISE_10FULL);
	if(hp->sw_bmsr & BMSR_100HALF)
		hp->sw_advertise |= (ADVERTISE_100HALF);
	else
		hp->sw_advertise &= ~(ADVERTISE_100HALF);
	if(hp->sw_bmsr & BMSR_100FULL)
		hp->sw_advertise |= (ADVERTISE_100FULL);
	else
		hp->sw_advertise &= ~(ADVERTISE_100FULL);

	/* Update the PHY advertisement register. */
	happy_meal_tcvr_write(hp, tregs, DP83840_ADVERTISE, hp->sw_advertise);
}

/* Once status is latched (by happy_meal_interrupt) it is cleared by
 * the hardware, so we cannot re-read it and get a correct value.
 */
static int happy_meal_is_not_so_happy(struct happy_meal *hp,
				      struct hmeal_gregs *gregs,
				      unsigned long status)
{
	int reset = 0;

	/* Only print messages for non-counter related interrupts. */
	if(status & (GREG_STAT_RFIFOVF | GREG_STAT_STSTERR | GREG_STAT_TFIFO_UND |
		     GREG_STAT_MAXPKTERR | GREG_STAT_RXERR |
		     GREG_STAT_RXPERR | GREG_STAT_RXTERR | GREG_STAT_EOPERR |
		     GREG_STAT_MIFIRQ | GREG_STAT_TXEACK | GREG_STAT_TXLERR |
		     GREG_STAT_TXPERR | GREG_STAT_TXTERR | GREG_STAT_SLVERR |
		     GREG_STAT_SLVPERR))
		printk("%s: Error interrupt for happy meal, status = %x\n",
		       hp->hmename, status);

	if(status & GREG_STAT_RFIFOVF) {
		/* The receive FIFO overflowwed, usually a DMA error. */
		printk("%s: Happy Meal receive FIFO overflow.\n", hp->hmename);
		reset = 1;
	}

	if(status & GREG_STAT_STSTERR) {
		/* BigMAC SQE link test failed. */
		printk("%s: Happy Meal BigMAC SQE test failed.\n", hp->hmename);
		reset = 1;
	}

	if(status & GREG_STAT_TFIFO_UND) {
		/* Transmit FIFO underrun, again DMA error likely. */
		printk("%s: Happy Meal transmitter FIFO underrun, DMA error.\n",
		       hp->hmename);
		reset = 1;
	}

	if(status & GREG_STAT_MAXPKTERR) {
		/* Driver error, tried to transmit something larger
		 * than ethernet max mtu.
		 */
		printk("%s: Happy Meal MAX Packet size error.\n", hp->hmename);
		reset = 1;
	}

	if(status & GREG_STAT_NORXD) {
		/* This is harmless, it just means the system is
		 * quite loaded and the incomming packet rate was
		 * faster than the interrupt handler could keep up
		 * with.
		 */
		printk("%s: Happy Meal out of receive "
		       "descriptors, packet dropped.\n",
		       hp->hmename);
for (;;) { }   /* P3 */
	}

	if(status & (GREG_STAT_RXERR|GREG_STAT_RXPERR|GREG_STAT_RXTERR)) {
		/* All sorts of DMA receive errors. */
		printk("%s: Happy Meal rx DMA errors [ ", hp->hmename);
		if(status & GREG_STAT_RXERR)
			printk("GenericError ");
		if(status & GREG_STAT_RXPERR)
			printk("ParityError ");
		if(status & GREG_STAT_RXTERR)
			printk("RxTagBotch ");
		printk("]\n");
		reset = 1;
	}

	if(status & GREG_STAT_EOPERR) {
		/* Driver bug, didn't set EOP bit in tx descriptor given
		 * to the happy meal.
		 */
		printk("%s: EOP not set in happy meal transmit descriptor!\n",
		       hp->hmename);
		reset = 1;
	}

	if(status & GREG_STAT_MIFIRQ) {
		/* MIF signalled an interrupt, were we polling it? */
		printk("%s: Happy Meal MIF interrupt.\n", hp->hmename);
	}

	if(status &
	   (GREG_STAT_TXEACK|GREG_STAT_TXLERR|GREG_STAT_TXPERR|GREG_STAT_TXTERR)) {
		/* All sorts of transmit DMA errors. */
		printk("%s: Happy Meal tx DMA errors [ ", hp->hmename);
		if(status & GREG_STAT_TXEACK)
			printk("GenericError ");
		if(status & GREG_STAT_TXLERR)
			printk("LateError ");
		if(status & GREG_STAT_TXPERR)
			printk("ParityErro ");
		if(status & GREG_STAT_TXTERR)
			printk("TagBotch ");
		printk("]\n");
		reset = 1;
	}

	if(status & (GREG_STAT_SLVERR|GREG_STAT_SLVPERR)) {
		/* Bus or parity error when cpu accessed happy meal registers
		 * or it's internal FIFO's.  Should never see this.
		 */
		printk("%s: Happy Meal register access SBUS slave (%s) error.\n",
		       hp->hmename,
		       (status & GREG_STAT_SLVPERR) ? "parity" : "generic");
		reset = 1;
	}

	if(reset) {
		printk("%s: Resetting...\n", hp->hmename);
		happy_meal_init(hp, 1);
		return 1;
	}
	return 0;
}

static inline void happy_meal_mif_interrupt(struct happy_meal *hp,
					    struct hmeal_gregs *gregs,
					    struct hmeal_tcvregs *tregs)
{
	printk("%s: Link status change.\n", hp->hmename);
	hp->sw_bmcr = happy_meal_tcvr_read(hp, tregs, DP83840_BMCR);
	hp->sw_lpa = happy_meal_tcvr_read(hp, tregs, DP83840_LPA);

	/* Use the fastest transmission protocol possible. */
	if(hp->sw_lpa & LPA_100FULL) {
		printk("%s: Switching to 100Mbps at full duplex.", hp->hmename);
		hp->sw_bmcr |= (BMCR_FULLDPLX | BMCR_SPEED100);
	} else if(hp->sw_lpa & LPA_100HALF) {
		printk("%s: Switching to 100MBps at half duplex.", hp->hmename);
		hp->sw_bmcr |= BMCR_SPEED100;
	} else if(hp->sw_lpa & LPA_10FULL) {
		printk("%s: Switching to 10MBps at full duplex.", hp->hmename);
		hp->sw_bmcr |= BMCR_FULLDPLX;
	} else {
		printk("%s: Using 10Mbps at half duplex.", hp->hmename);
	}
	happy_meal_tcvr_write(hp, tregs, DP83840_BMCR, hp->sw_bmcr);

	/* Finally stop polling and shut up the MIF. */
	happy_meal_poll_stop(hp, tregs);
}

#ifdef TXDEBUG
#define TXD(x) printk x
#else
#define TXD(x)
#endif

static inline void pci_happy_meal_tx(struct happy_meal *hp)
{
	struct happy_meal_txd *txbase = &hp->happy_block->happy_meal_txd[0];
	struct happy_meal_txd *this;
	int elem = hp->tx_old;

	TXD(("TX<"));
	while(elem != hp->tx_new) {
		struct sk_buff *skb;
		unsigned int flags;

		TXD(("[%d]", elem));
		this = &txbase[elem];
#ifdef  __sparc_v9__
		__asm__ __volatile__("lduwa [%1] %2, %0"
				     : "=r" (flags)
				     : "r" (&this->tx_flags), "i" (ASI_PL));
#else
		flags = flip_dword(this->tx_flags);
#endif
		if(flags & TXFLAG_OWN)
			break;
		skb = hp->tx_skbs[elem];
		hp->tx_skbs[elem] = NULL;

		dev_kfree_skb(skb);

		elem = NEXT_TX(elem);
	}
	hp->tx_old = elem;
	TXD((">"));
}

#ifdef RXDEBUG
#define RXD(x) printk x
#else
#define RXD(x)
#endif

/* Originally I use to handle the allocation failure by just giving back just
 * that one ring buffer to the happy meal.  Problem is that usually when that
 * condition is triggered, the happy meal expects you to do something reasonable
 * with all of the packets it has DMA'd in.  So now I just drop the entire
 * ring when we cannot get a new skb and give them all back to the happy meal,
 * maybe things will be "happier" now.
 */
static inline void pci_happy_meal_rx(struct happy_meal *hp, struct device *dev,
				     struct hmeal_gregs *gregs)
{
	struct happy_meal_rxd *rxbase = &hp->happy_block->happy_meal_rxd[0];
	struct happy_meal_rxd *this;
	unsigned int flags;
	int elem = hp->rx_new, drops = 0;

	RXD(("RX<"));
	this = &rxbase[elem];
#ifdef  __sparc_v9__
	__asm__ __volatile__("lduwa [%1] %2, %0"
			     : "=r" (flags)
			     : "r" (&this->rx_flags), "i" (ASI_PL));
#else
	flags = flip_dword(this->rx_flags); /* FIXME */
#endif
	while(!(flags & RXFLAG_OWN)) {
		struct sk_buff *skb;
		int len;
		u16 csum;

		RXD(("[%d ", elem));

		len = flags >> 16;
		csum = flags & RXFLAG_CSUM;

		/* Check for errors. */
		if((len < ETH_ZLEN) || (flags & RXFLAG_OVERFLOW)) {
			RXD(("ERR(%08x)]", flags));

			/* Return it to the Happy meal. */
	drop_it:
			pcihme_write_rxd(this,
			    (RXFLAG_OWN|((RX_BUF_ALLOC_SIZE-RX_OFFSET)<<16)),
			    (__u32) virt_to_bus((volatile void *)hp->rx_skbs[elem]->data));
			goto next;
		}
		skb = hp->rx_skbs[elem];
		if(len > RX_COPY_THRESHOLD) {
			struct sk_buff *new_skb;

			/* Now refill the entry, if we can. */
			new_skb = dev_alloc_skb(RX_BUF_ALLOC_SIZE);
			if(!new_skb) {
				drops++;
				goto drop_it;
			}

			hp->rx_skbs[elem] = new_skb;
			new_skb->dev = dev;
			skb_put(new_skb, (ETH_FRAME_LEN + RX_OFFSET));
			pcihme_write_rxd(this,
				 (RXFLAG_OWN|((RX_BUF_ALLOC_SIZE-RX_OFFSET)<<16)),
				  (__u32)virt_to_bus((volatile void *)new_skb->data));
			skb_reserve(new_skb, RX_OFFSET);

			/* Trim the original skb for the netif. */
			skb_trim(skb, len);
		} else {
			struct sk_buff *copy_skb = dev_alloc_skb(len + 2);

			if(!copy_skb) {
				drops++;
				goto drop_it;
			}

			copy_skb->dev = dev;
			skb_reserve(copy_skb, 2);
			skb_put(copy_skb, len);
			memcpy(copy_skb->data, skb->data, len);

			/* Reuse original ring buffer. */
			pcihme_write_rxd(this,
				 (RXFLAG_OWN|((RX_BUF_ALLOC_SIZE-RX_OFFSET)<<16)),
				 (__u32)virt_to_bus((volatile void *)skb->data));

			skb = copy_skb;
		}

		/* This card is _fucking_ hot... */
		if(!~(csum))
			skb->ip_summed = CHECKSUM_UNNECESSARY;
		else
			skb->ip_summed = CHECKSUM_NONE;

		RXD(("len=%d csum=%x]", len, csum));
		skb->protocol = eth_type_trans(skb, dev);
		netif_rx(skb);

	next:
		elem = NEXT_RX(elem);
		this = &rxbase[elem];
#ifdef __sparc_v9__ 
		__asm__ __volatile__("lduwa [%1] %2, %0"
				     : "=r" (flags)
				     : "r" (&this->rx_flags), "i" (ASI_PL));
#else
		flags = flip_dword(this->rx_flags); /* FIXME */
#endif
	}
	hp->rx_new = elem;
	if(drops)
		printk("%s: Memory squeeze, deferring packet.\n", hp->hmename);
	RXD((">"));
}

static void pci_happy_meal_interrupt(void *dev_id)
{
	struct device *dev            = (struct device *) dev_id;
	struct happy_meal *hp         = (struct happy_meal *) dev->priv;
	struct hmeal_gregs *gregs     = hp->gregs;
	struct hmeal_tcvregs *tregs   = hp->tcvregs;
	unsigned int happy_status     = ld_bp_swap((unsigned long)&gregs->stat);

	HMD(("happy_meal_interrupt: status=%x ", happy_status));

	dev->interrupt = 1;

	if(happy_status & GREG_STAT_ERRORS) {
		HMD(("ERRORS "));
		if(happy_meal_is_not_so_happy(hp, gregs, /* un- */ happy_status)) {
			dev->interrupt = 0;
			return;
		}
	}

	if(happy_status & GREG_STAT_MIFIRQ) {
		HMD(("MIFIRQ "));
		happy_meal_mif_interrupt(hp, gregs, tregs);
	}

	if(happy_status & GREG_STAT_TXALL) {
		HMD(("TXALL "));
		pci_happy_meal_tx(hp);
	}

	if(happy_status & GREG_STAT_RXTOHOST) {
		HMD(("RXTOHOST "));
		pci_happy_meal_rx(hp, dev, gregs);
	}

	if(dev->tbusy && (TX_BUFFS_AVAIL(hp) >= 0)) {
		dev->tbusy = 0;
		mark_bh(NET_BH);
	}
	tx_add_log(hp, TXLOG_ACTION_IRQ, happy_status);
	dev->interrupt = 0;
	HMD(("done\n"));
}

static int happy_meal_open(struct device *dev)
{
	struct happy_meal *hp = (struct happy_meal *) dev->priv;
	int res;

	HMD(("happy_meal_open: "));

	if(request_irq(hp->irq, &pci_happy_meal_interrupt, dev)) {
		HMD(("EAGAIN\n"));
		printk("happy_meal(PCI): Can't order irq %d to go.\n", hp->irq);
		return -EAGAIN;
	}

	HMD(("to happy_meal_init\n"));
	res = happy_meal_init(hp, 0);
	return res;
}

static int happy_meal_close(struct device *dev)
{
	struct happy_meal *hp = (struct happy_meal *) dev->priv;

	happy_meal_stop(hp, hp->gregs);
	happy_meal_clean_rings(hp);

	/* If auto-negotiation timer is running, kill it. */
	del_timer(&hp->happy_timer);

	free_irq(hp->irq, (void *)dev);

	return 0;
}

#ifdef SXDEBUG
#define SXD(x) printk x
#else
#define SXD(x)
#endif

static int pci_happy_meal_start_xmit(struct sk_buff *skb, struct device *dev)
{
	struct happy_meal *hp = (struct happy_meal *) dev->priv;
	int len, entry;

	if(test_and_set_bit(0, (void *) &dev->tbusy) != 0) {
		int tickssofar = jiffies - dev->trans_start;
	    
		if (tickssofar >= 40) {
			unsigned long flags;

			printk ("%s: transmit timed out, resetting\n", dev->name);

			save_and_cli(flags);
			tx_dump_log();
			tx_dump_ring(hp);
			restore_flags(flags);

			happy_meal_init(hp, 0);
			dev->tbusy = 0;
			dev->trans_start = jiffies;
		} else
			tx_add_log(hp, TXLOG_ACTION_TXMIT|TXLOG_ACTION_TBUSY, 0);
		return 1;
	}

	if(!TX_BUFFS_AVAIL(hp)) {
		tx_add_log(hp, TXLOG_ACTION_TXMIT|TXLOG_ACTION_NBUFS, 0);
		return 1;
	}
	len = skb->len;
	entry = hp->tx_new;

	SXD(("SX<l[%d]e[%d]>", len, entry));
	hp->tx_skbs[entry] = skb;
	pcihme_write_txd(&hp->happy_block->happy_meal_txd[entry],
			 (TXFLAG_OWN|TXFLAG_SOP|TXFLAG_EOP|(len & TXFLAG_SIZE)),
			 (u32) virt_to_bus((volatile void *)skb->data));
	hp->tx_new = NEXT_TX(entry);

	/* Get it going. */
	dev->trans_start = jiffies;
	st_bp_swap((unsigned long)&hp->etxregs->tx_pnding, ETX_TP_DMAWAKEUP);

	if(TX_BUFFS_AVAIL(hp))
		dev->tbusy = 0;

	tx_add_log(hp, TXLOG_ACTION_TXMIT, 0);
	return 0;
}

static int hme_init(struct happy_meal *hp, struct hme_info *info, int instance)
{
	struct device *dev = &hp->edev;
	unsigned long hpreg_base;
	unsigned short pci_command;
	int i;

	memset(hp, 0, sizeof(*hp));
	hp->hmename[0] = 'h';
	hp->hmename[1] = 'm';
	hp->hmename[2] = 'e';
	hp->hmename[3] = instance + '0';
	hp->hmename[4] = '\0';

	hp->irq = info->intr;

	hpreg_base = info->physaddr[1];

	printk("%s: HAPPY MEAL ", hp->hmename);
	memcpy(dev->dev_addr, idprom + 2, 6);
	for(i = 0; i < 6; i++)
		printk("%x%c", dev->dev_addr[i], i == 5 ? ' ' : ':');
	printk("\n");

	/* Layout registers. */
	hp->gregs      = (struct hmeal_gregs *)		(hpreg_base + 0x0000);
	hp->etxregs    = (struct hmeal_etxregs *)	(hpreg_base + 0x2000);
	hp->erxregs    = (struct hmeal_erxregs *)	(hpreg_base + 0x4000);
	hp->bigmacregs = (struct hmeal_bigmacregs *)	(hpreg_base + 0x6000);
	hp->tcvregs    = (struct hmeal_tcvregs *)	(hpreg_base + 0x7000);

	hp->hm_revision = info->hm_rev;
	if(hp->hm_revision == 0xff)
		hp->hm_revision = 0xa0;

	/* Now enable the feature flags we can. */
	if(hp->hm_revision == 0x20 || hp->hm_revision == 0x21)
		hp->happy_flags = HFLAG_20_21;
	else if(hp->hm_revision != 0xa0)
		hp->happy_flags = HFLAG_NOT_A0;

	/* And of course, indicate this is PCI. */
	hp->happy_flags |= HFLAG_PCI;

#if 0
	/* Assume PCI happy meals can handle all burst sizes. */
	hp->happy_bursts = DMA_BURSTBITS;
#endif

	hp->happy_block = dvma_alloc(PAGE_SIZE, &hp->hblock_dvma);
	if(!hp->happy_block) {
		printk("happymeal(PCI): Cannot get hme init block.\n");
		return -1;
	}

	hp->linkcheck = 0;
	hp->timer_state = asleep;
	hp->timer_ticks = 0;
	happy_meal_set_initial_advertisement(hp);

	init_timer(&hp->happy_timer);

	dev->priv = hp;
	dev->name = hp->hmename;
	dev->open = &happy_meal_open;
	dev->stop = &happy_meal_close;
	dev->hard_start_xmit = &pci_happy_meal_start_xmit;
	ether_setup(dev);

	/* If we don't do this, nothing works. */
	pci_command = hme_pci_read_config_word(info, PCI_COMMAND);
	pci_command |= PCI_COMMAND_MASTER;
	hme_pci_write_config_word(info, PCI_COMMAND, pci_command);

	pci_command = hme_pci_read_config_word(info, PCI_COMMAND);

	/* Set the latency timer and cache line size as well,
	 * PROM leaves it at zero.
	 */
	hme_pci_write_config_byte(info, PCI_LATENCY_TIMER, 128);
#ifdef __sparc_v9__
	/* NOTE: Cache line size is in 32-bit word units. */
	hme_pci_write_config_byte(info, PCI_CACHE_LINE_SIZE, 0x10);
#endif
	return 0;
}

void hme_probe()
{
	unsigned base0;
	unsigned id;

#if 0
	pdev = pci_find_device(PCI_VENDOR_ID_SUN,
				       PCI_DEVICE_ID_SUN_HAPPYMEAL, 0);
#endif
	/* What does 7020 means that PROM prints? Looks more like @0,1.. */
	hme_node0.pci_bus = 0;
	hme_node0.pci_func = 1;

	id = hme_pci_read_config_dword(&hme_node0, PCI_VENDOR_ID);
	if (id != ((PCI_DEVICE_ID_SUN_HAPPYMEAL<<16)|PCI_VENDOR_ID_SUN)) {
                printk("hme_probe: no hme id=0x%x\n", id);
                return;
	}

	{
		unsigned n;
		n = hme_pci_read_config_word(&hme_node0, PCI_COMMAND);
		n |= PCI_COMMAND_MEMORY|PCI_COMMAND_IO;
		hme_pci_write_config_word(&hme_node0, PCI_COMMAND, n);
	}

	base0 = hme_pci_read_config_dword(&hme_node0, PCI_BASE_ADDRESS_0);

        hme_node0.physaddr[0] = 0;
        hme_node0.physaddr[1] = base0;
        hme_node0.physaddr[3] = 0x10000;
        /* Hardcode everything for Krups/Espresso. */
        hme_node0.tpe = 2;
	hme_node0.intr = 6;              /* 0x26 - OBIO? */
	hme_node0.hm_rev = 0xFF; /* Espresso PROM does not have the property */

        if (hme_arena[0].active) {
                printk("hme_probe: no free hme\n");
                return;
        }

        if (hme_init(&hme_arena[0], &hme_node0, 0) != 0) {
		printk("hme_probe: hme0 init failed\n");
		return;
        }

	return;
}
