/***************************************************************************
                splashscreen.cpp  -  description
                             -------------------
    begin                : Sun Feb 16 2003
    copyright            : (C) 2003 by Paul-henri ferme
    email                : paul-henri.ferme@noos.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qapplication.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qmessagebox.h>
#include "splashscreen.h"
#include "prokyon.h"


SplashScreen::SplashScreen( const QPixmap &pixmap )
: QWidget( 0, 0, WStyle_Customize | WStyle_NoBorder | /*WStyle_StaysOnTop |*/ WX11BypassWM),
pix( pixmap ) {
    setErasePixmap( pix );
    resize( pix.size() );
    QRect scr = QApplication::desktop()->screenGeometry();
    move( scr.center() - rect().center() );
    show();
    repaint();
}

void SplashScreen::repaint() {
    QWidget::repaint();
    QApplication::flush();
}

#if defined(Q_WS_X11)
void qt_wait_for_window_manager( QWidget *widget );
#endif

void SplashScreen::finish( QWidget *mainWin ) {
    qApp->lock()
    ;
    #if defined(Q_WS_X11)

    qt_wait_for_window_manager( mainWin );
    #endif

    close();
    qApp->unlock();
}

void SplashScreen::setStatus( const QString &message, int alignment, const QColor &color ) {
    QPixmap textPix = pix;
    QPainter painter;
    if( textPix.isNull() ) {  // nice message if cannot found any images...
        painter.begin( this);
        QMessageBox::critical(this, _("Too bad..."),
                              QString(_("Prokyon3 cannot find any images in %1 \n You are really missing a lot...:-((\n") )
                              .arg( PROKYON_HOME + "/images/"));
    } else
        painter.begin( &textPix, this );
    painter.setPen( color );
    QRect r = rect();
    r.setRect( r.x() + 15, r.y() + 15, r.width() - 20, r.height() - 20 );
    painter.drawText( r, alignment, message );
    setErasePixmap( textPix );
    repaint();
}

void SplashScreen::mousePressEvent( QMouseEvent * ) {
    hide();
}
