#ifndef MIXXXCLIENT_H
#define MIXXXCLIENT_H

#include "prokyon.h"
#include "gui_mixxxqueue.h"

#include <qobject.h>
#include <qthread.h>
#include <qstring.h>
#include <qsocket.h>
#include <qtimer.h>

class MixxxClient : public QObject {
    Q_OBJECT
public:
    MixxxClient();

    void lock() {
        mutex.lock();
    }
    void unlock() {
        mutex.unlock();
    }

    void establishConnection(QString host, int port);
    void disconnect();
    bool isConnected() {
        return connected;
    }

    void loadAtChannel(QString, int);
    void loadAndPlayAtChannel(QString, int);
    void stopAtChannel(int);
    void pauseAtChannel(int);
    void continueAtChannel(int);

    void registerListener(GUI_MixxxQueue*);
    ~MixxxClient() {}

private:
    QMutex mutex;
    QSocket *socket;
    QTimer *timer;
    QStringList commandQueue;
    bool connected;
    bool connecting;
    bool sending;
    GUI_MixxxQueue *listener;

    void enqueueCommand(QString);
    QString dequeueCommand();

    void enqueueOnChannel(QString, int);
    QString dequeueFromChannel(int);

    void sendToServer(QString);

private slots:
    void slot_handleCommandQueue();
    void slot_socketReadyRead();
    void slot_socketConnected();
    void slot_socketConnectionClosed();
    void slot_socketClosed();
    void slot_socketError(int);
};

#endif
