/***************************************************************************
                          lvi_album.cpp  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lvi_album.h"
#include "database.h"
#include "gui.h"
#include "pixmapcache.h"

LVI_Album::LVI_Album(QListView *parent, DELTAINFO *delta)
: QListViewItem(parent) {
    setText(0, delta->name);

    isArtist = true;
    isArtistFavourite = false;
    total       = delta->total;
    local       = delta->local;
    medium = -1;
    adjustIcon();
}

LVI_Album::LVI_Album(QListViewItem *parent, ARTISTALBUM *album)
: QListViewItem(parent) {
    setText(0, album->album);

    isArtist          = false;
    isArtistFavourite = false;
    artistId          = 0;
    total             = album->total;
    local             = album->local;
    medium            = album->medium;
    adjustIcon();
}

LVI_Album::LVI_Album(QListView *parent, ARTISTALBUM *album)
: QListViewItem(parent) {
    setText(0, album->artist);

    isArtist          = true;
    isArtistFavourite = album->isFavourite;
    artistId          = album->artistId;
    total             = 0;
    local             = 0;
    medium            = album->medium;
    adjustIcon();
}

LVI_Album::LVI_Album(QListViewItem *parent, ALBUMINFO delta)
: QListViewItem(parent) {
    setText(0, delta.name);

    isArtist          = false;
    isArtistFavourite = false;
    artistId          = 0;
    total             = delta.total;
    local             = delta.local;
    medium            = -1;
    adjustIcon();
}

bool LVI_Album::applyDelta(ALBUMINFO delta) {
    total += delta.total;
    local += delta.local;

    if (total != 0)
        adjustIcon();

    return (total != 0);
}

bool LVI_Album::applyDelta(DELTAINFO *delta) {
    total += delta->total;
    local += delta->local;

    if (total != 0)
        adjustIcon();

    return (total != 0);
}

void LVI_Album::adjustIcon() {
    adjustIcon(false);
}

void LVI_Album::adjustIcon(bool isAvailable) {
    if(isArtist) {
        QString path = "lvi_artist.png";
        if(isArtistFavourite)
            path = "lvi_artist_favourite.png";
        setPixmap(0, pixmapcache->get
                  (path));
        /*
            if(isAvailable || local != 0) setPixmap(0, pixmapcache->get(path));
            else setPixmap(0, pixmapcache->getFaded(path));
        */
    } else {
        /*
            if(isAvailable || local != 0) setPixmap(0, pixmapcache->get("lvi_album.png"));
            else setPixmap(0, pixmapcache->getFaded("lvi_album.png"));
        */
        QPixmap *pixmap = database->getAlbumThumbnail(parent()->text(0), text(0));
        setPixmap(0, *pixmap);
    }
}

void LVI_Album::changeLocal(int delta) {
    local += delta;
    adjustIcon();
}

