/***************************************************************************
                          job_playalbum.cpp  -  description
                             -------------------
    begin                : Wed feb 14 2004
    copyright            : (C) 2004 by Paul-henri Ferme
    email                : paul-henri.ferme@noos.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_playalbum.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"
#include "gui.h"

#ifdef EMBEDDED
#include <mysql.h>
#endif

Job_PlayAlbum::Job_PlayAlbum(int type, QString data, QString data2 )
: querytype(type), querydata(data), querydata2(data2) {}

void Job_PlayAlbum::run() {
    int error;
    QList<TRACK> *list = 0;

    if (verbose==8)
        qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

    #ifdef EMBEDDED

    mysql_thread_init();
    #endif

    database->lock()
    ;  // Thread will wait for database mutex

    if(gui->getSelector()->currentPage() == gui->getSelector()->getTabAlbum()) {
        list = database->queryTracksByAlbum(querydata, querydata2);
    } else {
        list = database->queryTracksByArtistAlbum(querydata, querydata2);
    }

    error = database->getError();
    database->unlock();

    app->lock()
    ;  // Thread will wait for GUI mutex
    datadispatcher->eventNewTrackListing(list);   // update track list display
    app->unlock();

    switch( querytype) {
    case XMMS_PLAY:
        gui->getListing()->slot_play(false);   // play all displayed tracks
        break;
    case XMMS_ENQUEUE:
        gui->getListing()->slot_enqueue(false);   // enqueue all displayed tracks
        break;
        #ifdef HAVE_MIXXX

    case CH1_ENQUEUE:
        gui->getListing()->mixxxEnqueueAtChannel(false, 1);   // enqueue all displayed tracks
        break;
    case CH2_ENQUEUE:
        gui->getListing()->mixxxEnqueueAtChannel(false, 2);   // enqueue all displayed tracks
        break;
        #endif /* HAVE_MIXXX */

    default:
        qWarning("Job_playalbum::Unknown querytype:%d", querytype);
    }

    jobman->lock()
    ;  //
    jobman->jobDone(this);
    jobman->unlock();

    #ifdef EMBEDDED

    mysql_thread_end();
    #endif

    if (verbose==8)
        qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

    exit();
}

