#include "job_disconnectfrommixxx.h"

#include "jobmanager.h"
#include "mixxxclient.h"

Job_DisconnectFromMixxx::Job_DisconnectFromMixxx() {}

void Job_DisconnectFromMixxx::run() {

    if (verbose==8)
        qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

    mixxxClient->lock()
    ;
    mixxxClient->disconnect();
    mixxxClient->unlock();

    jobman->lock()
    ;
    jobman->jobDone(this);
    jobman->unlock();

    if (verbose==8)
        qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

    exit();
}

Job_DisconnectFromMixxx::~Job_DisconnectFromMixxx() {}
