/****************************************************************************
**
** Copyright (C) 1992-2002 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
****************************************************************************/

#ifndef FINDDIALOG_H
#define FINDDIALOG_H

#include <qvariant.h>
#include <qdialog.h>

#include <prokyon.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QButtonGroup;
class QCheckBox;
class QComboBox;
class QLabel;
class QPushButton;
class QRadioButton;
class QTextBrowser;
class QStatusBar;

class FindDialog : public QDialog {
    Q_OBJECT

public:
    FindDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~FindDialog();

    QButtonGroup* ButtonGroup2;
    QRadioButton* radioForward;
    QRadioButton* radioBackward;
    QLabel* TextLabel1;
    QComboBox* comboFind;
    QPushButton* PushButton2;
    QButtonGroup* ButtonGroup1;
    QCheckBox* checkWords;
    QCheckBox* checkCase;
    QPushButton* PushButton1;

public slots:
    virtual void doFind();
    virtual void setBrowser( QTextBrowser * b );

protected:
    bool fromBegin;
    QTextBrowser *browser;
    bool firstRun;
    QStatusBar *sb;
    bool onceFound;
    QString findExpr;

    QVBoxLayout* FindDialogLayout;
    QGridLayout* Layout5;
    QVBoxLayout* ButtonGroup2Layout;
    QHBoxLayout* Layout1;
    QVBoxLayout* ButtonGroup1Layout;

protected slots:
    virtual void languageChange();

    virtual void init();
    virtual void destroy();

};

#endif // FINDDIALOG_H
