/***************************************************************************
                    configuration_dialog.cpp  -  description
                             -------------------
    begin                : Sat Feb 9 2001
    copyright            : (C) 2002 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configuration_dialog.h"
#include "configuration.h"
#include "gui.h"
#include "pixmapcache.h"

#include <qbuttongroup.h>
#include <qlayout.h>
#include <qframe.h>
#include <qhgroupbox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qtooltip.h>
#include <qtextedit.h>
#include <qheader.h>

Configuration_Dialog::Configuration_Dialog(QWidget *parent, const char *name)
: QTabDialog(parent, name) {

    setCaption("prokyon3 - " + QString(_("Settings...")));
    setIcon(pixmapcache->get
            ("action_settings.png"));

    QFrame *dbframe = new QFrame(this);
    QHBoxLayout *hlay = new QHBoxLayout(dbframe);

    QGroupBox *dbbox = new QGroupBox(1, Qt::Horizontal, "Settings", dbframe);
    QFrame *dbboxf = new QFrame(dbbox);
    QGridLayout *dblay = new QGridLayout(dbboxf, 6, 2);
    QToolTip::add
        ( dbboxf, _("When disconnected, you can change all MySQL \nconnection parameters here. \nDefault values are usually OK.") );

    QLabel *a = new QLabel("<b>" + QString(_("Host")) + ": </b>", dbboxf);
    a->setAlignment(Qt::AlignRight);
    dblay->addWidget(a, 0, 0);
    QLabel *b = new QLabel("<b>" + QString(_("Database")) + ": </b>", dbboxf);
    b->setAlignment(Qt::AlignRight);
    dblay->addWidget(b, 1, 0);
    QLabel *c = new QLabel("<b>" + QString(_("User")) + ": </b>", dbboxf);
    c->setAlignment(Qt::AlignRight);
    dblay->addWidget(c, 2, 0);
    QLabel *d = new QLabel("<b>" + QString(_("Password")) + ": </b>", dbboxf);
    d->setAlignment(Qt::AlignRight);
    dblay->addWidget(d, 3, 0);
    #ifdef EMBEDDED

    QLabel *e = new QLabel("<b>" + QString(_("Embedded Basedir")) + ": </b>", dbboxf);
    e->setAlignment(Qt::AlignRight);
    dblay->addWidget(c, 4, 0);
    QLabel *f = new QLabel("<b>" + QString(_("Embedded Language")) + ": </b>", dbboxf);
    f->setAlignment(Qt::AlignRight);
    dblay->addWidget(d, 5, 0);
    #endif /* EMBEDDED */

    db_host_line = new QLineEdit(config->db_host, dbboxf);
    dblay->addWidget(db_host_line, 0, 1);
    db_database_line = new QLineEdit(config->db_database, dbboxf);
    dblay->addWidget(db_database_line, 1, 1);
    db_user_line = new QLineEdit(config->db_user, dbboxf);
    dblay->addWidget(db_user_line, 2, 1);
    db_pass_line = new QLineEdit(config->db_pass, dbboxf);
    db_pass_line->setEchoMode(QLineEdit::Password);
    dblay->addWidget(db_pass_line, 3, 1);
    #ifdef EMBEDDED

    embedded_basedir_line = new QLineEdit(config->embeddedBasedir, dbboxf);
    dblay->addWidget(embedded_basedir_line, 4, 1);
    embedded_language_line = new QLineEdit(config->embeddedLanguage, dbboxf);
    dblay->addWidget(embedded_language_line, 5, 1);
    #endif /* EMBEDDED */

    hlay->addWidget(dbbox);

    QFrame *dirframe = new QFrame(this);
    QHBoxLayout *dhlay = new QHBoxLayout(dirframe);

    QString *typeDirs = new QString();

    #if HAVE_ID3

    typeDirs->append("MP3");
    #endif /* HAVE_ID3 */
    #if HAVE_OGG

    if (typeDirs->isNull() == true) {
        typeDirs->append("OGG");
    } else {
        typeDirs->append("/Ogg");
    }
    #endif /* HAVE_OGG */
    #if HAVE_FLAC
    if (typeDirs->isNull() == true) {
        typeDirs->append("Flac");
    } else {
        typeDirs->append("/Flac");
    }
    #endif /* HAVE_FLAC */
    #if HAVE_TAG
    *typeDirs ="MP3/Ogg/Flac/...";
    #endif /* HAVE_TAG */


    typeDirs->append(" Directories");

    QHGroupBox *dirbox = new QHGroupBox(*typeDirs, dirframe);
    delete typeDirs;

    hddlist = new QListView(dirbox);
    hddlist->setAllColumnsShowFocus(true);
    hddlist->setSorting(-1);
    hddlist->addColumn(_("Directory"), 300);
    QString temps = _("Here you can manage a list of directories to search for music files.\n Please note that sub-directories are searched as well.");
    QToolTip::add
        ( hddlist, temps );
    QToolTip::add
        ( hddlist->viewport(), temps );
    /*************************/
    QFrame *hddbuttonframe = new QFrame(dirbox);
    QVBoxLayout *hddbuttonlayout = new QVBoxLayout(hddbuttonframe);

    QPushButton *hddadd = new QPushButton(_("Add"), hddbuttonframe);
    hddbuttonlayout->addWidget(hddadd, 0, AlignTop);
    hddedit = new QPushButton(_("Edit"), hddbuttonframe);
    hddbuttonlayout->addWidget(hddedit, 0, AlignTop);
    hddremove = new QPushButton(_("Remove"), hddbuttonframe);
    hddbuttonlayout->addWidget(hddremove, 1, AlignTop);

    for(QStringList::Iterator it = config->mp3dirs.begin(); it != config->mp3dirs.end(); ++it) {
        QListViewItem *item = new QListViewItem(hddlist, *it);
        item->setPixmap(0, pixmapcache->get
                        ("artist.png"));
    }

    connect(hddlist, SIGNAL(selectionChanged()), this, SLOT(slot_selectionChanged()));
    connect(hddadd, SIGNAL(clicked()), this, SLOT(slot_hddadd()));
    connect(hddremove, SIGNAL(clicked()), this, SLOT(slot_hddremove()));
    connect(hddedit, SIGNAL(clicked()), this, SLOT(slot_hddedit()));

    if(hddlist->firstChild() != 0)
        hddlist->setSelected(hddlist->firstChild(), true);

    dhlay->addWidget(dirbox);

    QFrame *togframe = new QFrame(this);
    QHBoxLayout *toghlay = new QHBoxLayout(togframe);

    QGroupBox *togbox = new QGroupBox(1, Qt::Horizontal, _("Behavior"), togframe);
    toghlay->addWidget(togbox);
    QFrame *togboxf = new QFrame(togbox);
    QGridLayout *toglay = new QGridLayout(togboxf, 12, 1);

    readv2check = new QCheckBox( _("Read ID3v2 tags"), togboxf);
    readv2check->setChecked(config->readid3v2 == 1);
    QToolTip::add
        ( readv2check, _("When checked, Prokyon will read ID3V2 tags from mp3 files.\n It will default to V1 if no V2 tags are available") );
    toglay->addWidget(readv2check, 0, 0);
    writev2check = new QCheckBox( _("Write ID3v2 tags"), togboxf);
    writev2check->setChecked(config->writeid3v2 == 1);
    QToolTip::add
        ( writev2check, _("When checked, Prokyon will always write ID3 V2 tags to mp3 files.") );
    toglay->addWidget(writev2check, 1, 0);
    autocheck = new QCheckBox( _("Autoconnect to database at startup"), togboxf);
    autocheck->setChecked(config->autoconn == 1);
    toglay->addWidget(autocheck, 2, 0);
    hidecheck = new QCheckBox( _("Autohide artists/sources/playlists in tagedit mode"), togboxf);
    hidecheck->setChecked(config->autohide == 1);
    QToolTip::add
        ( hidecheck, _("When checked, Prokyon will expand display when tags are edited.") );
    toglay->addWidget(hidecheck, 3, 0);
    hddcheck = new QCheckBox( _("Never show content of whole harddisk"), togboxf);
    hddcheck->setChecked(config->avoidhdd == 1);
    QToolTip::add
        ( hddcheck, _("Useful if you have lots of files on your harddisk.") );
    toglay->addWidget(hddcheck, 4, 0);
    smbcheck = new QCheckBox( _("Never show content of whole SMB shares"), togboxf);
    smbcheck->setChecked(config->avoidsmb == 1);
    QToolTip::add
        ( smbcheck, _("Useful if you have lots of files on your SMB share.") );
    toglay->addWidget(smbcheck, 5, 0);
    nfscheck = new QCheckBox( _("Never show content of whole NFS exports"), togboxf);
    nfscheck->setChecked(config->avoidnfs == 1);
    QToolTip::add
        ( nfscheck, _("Useful if you have lots of files on your NFS share.") );
    toglay->addWidget(nfscheck, 6, 0);
    showtooltip = new QCheckBox( _("Allow tool tip"), togboxf);
    showtooltip->setChecked( config->getShowToolTip() == 1 );
    QToolTip::add
        ( showtooltip, _("Get rid of silly messages like this one....") );
    toglay->addWidget(showtooltip, 7, 0);
    maxwidthmode = new QCheckBox( _("Allow column to expand automatically"), togboxf);
    maxwidthmode->setChecked( config->getMaxWidthMode() == 1 );
    QToolTip::add
        ( maxwidthmode, _(" When checked, columns size will be adjusted automatically.\n If unchecked, Prokyon will remember your adjustements\n between sessions.") );
    toglay->addWidget(maxwidthmode, 8, 0);
    guirestore = new QCheckBox( _("Allow GUI configuration restore "), togboxf);
    guirestore->setChecked( config->getAllowGuiRestore() == 1 );
    QToolTip::add
        ( guirestore, _("When checked, internal frame sizes  as well as relative \ncolumns position in central frame \nwill be saved and restored between sessions.") );
    toglay->addWidget(guirestore, 9, 0);

    QFrame *customframe = new QFrame(togboxf);
    QHBoxLayout *customlay = new QHBoxLayout(customframe);

    QLabel* lcustomrename = new QLabel(QString(_("Custom filename template")) + ": ", customframe);
    lcustomrename->setAlignment(Qt::AlignLeft);
    customlay->addWidget(lcustomrename, 0);

    customrename_line = new QLineEdit(config->getCustomRename(), customframe);
    QToolTip::add
        ( customrename_line, _("Allows you to define a custom file renaming template.\n  Valid markup tags are:\n  %A - track artist\n  %T - track title\n  %S - track album (source)\n  %N - track number\n  %Y - track year") );
    customlay->addWidget(customrename_line, 1);
    toglay->addMultiCellWidget( customframe, 11, 11, 0, 0);


    QFrame *comboframe = new QFrame(togboxf);
    QHBoxLayout *combohlay = new QHBoxLayout(comboframe);
    QLabel* lcombo = new QLabel( _("Tracks sorted by:"), comboframe);
    combohlay->addWidget( lcombo, 1 );
    QToolTip::add
        ( lcombo, _("Select here a default column for tracks sorting..") );
    comboSortingMode = new QComboBox(comboframe);
    combohlay->addWidget( comboSortingMode, 1 );
    QHeader* qh = gui->getListing()->list()->header();
    for (int i = 0 ; i < qh->count(); i++)
        if ( !qh->label(qh->mapToSection(i)).isEmpty() )
            comboSortingMode->insertItem(qh->label(qh->mapToSection(i)));
    if (!config->getComboSortingMode().isEmpty())
        comboSortingMode->setCurrentText( config->getComboSortingMode() );
    QToolTip::add
        ( comboSortingMode, _("Select here a default column for tracks sorting..") );
    comboSortingAuto = new QCheckBox( _("Smart sorting "), comboframe);
    comboSortingAuto->setChecked( config->getComboSortingAuto() == 1 );
    combohlay->addWidget( comboSortingAuto, 3, Qt::AlignHCenter );
    QToolTip::add
        ( comboSortingAuto, _("If checked, sort by tracks number when available, otherwise default to sorting column..") );
    toglay->addMultiCellWidget( comboframe,10,10,0,1);

    QFrame *sharesframe = new QFrame(this);
    QHBoxLayout *shareshlay = new QHBoxLayout(sharesframe);

    QGroupBox *sharesbox = new QGroupBox(1, Qt::Horizontal, "Keywords", sharesframe);
    QFrame *sharesboxf = new QFrame(sharesbox);
    QGridLayout *sharesglay = new QGridLayout(sharesboxf, 2, 2);

    QLabel *smblabel = new QLabel("<b>" + QString(_("SMB Keywords")) + ": </b>", sharesboxf);
    smblabel->setAlignment(Qt::AlignRight);
    sharesglay->addWidget(smblabel, 0, 0);
    QLabel *nfslabel = new QLabel("<b>" + QString(_("NFS Keywords")) + ": </b>", sharesboxf);
    nfslabel->setAlignment(Qt::AlignRight);
    sharesglay->addWidget(nfslabel, 1, 0);

    smbKeywords_line = new QLineEdit(config->smbKeywords.join(","), sharesboxf);
    QToolTip::add
        ( smbKeywords_line, _("Enter \",\" separated keyword(s) for  detecting smb share in /etc/fstab.") );
    sharesglay->addWidget(smbKeywords_line, 0, 1);
    nfsKeywords_line = new QLineEdit(config->nfsKeywords.join(","), sharesboxf);
    QToolTip::add
        ( nfsKeywords_line, _("Enter \",\" separated keyword(s) for detecting nfs share in /etc/fstab..") );
    sharesglay->addWidget(nfsKeywords_line, 1, 1);

    shareshlay->addWidget(sharesbox);

    QFrame *playframe = new QFrame(this);
    QHBoxLayout *playhlay = new QHBoxLayout(playframe);
    QGroupBox *playbox = new QGroupBox(1, Qt::Horizontal, "Player Settings", playframe);
    QFrame *playboxf = new QFrame(playbox);
    QGridLayout *playlay = new QGridLayout(playboxf, 16, 3);
    playlay->setColStretch(2, 1); // enlarge play_line and enqueue_line if HAVE_MIXXX not defined
    #ifdef HAVE_MIXXX

    enableRegularPlayer = new QCheckBox( _("Enable regular player"), playboxf);
    enableRegularPlayer->setChecked(config->RegularPlayerEnabled());
    QToolTip::add
        ( enableRegularPlayer, _("When checked, prokyon3 will add player controls for regular players to context menus.") );
    playlay->addMultiCellWidget(enableRegularPlayer, 0, 0, 0,2);
    #endif /* HAVE_MIXXX */

    play_label = new QLabel(_("<b>play</b> command: "), playboxf);
    play_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(play_label, play_line, config->playcmd, "play");
    playlay->addWidget(play_label, 1, 1);
    playlay->addWidget(play_line, 1, 2);
    QToolTip::add( play_label, _("Track(s) will be pased to the player as playlist.") );
    QToolTip::add( play_line, _("Track(s) will be pased to the player as playlist.") );

    pause_label = new QLabel(_("<b>pause</b> command: "), playboxf);
    pause_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(pause_label, pause_line, config->pausecmd, "pause");
    playlay->addWidget(pause_label, 2, 1);
    playlay->addWidget(pause_line, 2, 2);

    stop_label = new QLabel(_("<b>stop</b> command: "), playboxf);
    stop_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(stop_label, stop_line, config->stopcmd, "stop");
    playlay->addWidget(stop_label, 3, 1);
    playlay->addWidget(stop_line, 3, 2);

    next_label = new QLabel(_("<b>next</b> command: "), playboxf);
    next_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(next_label, next_line, config->nextcmd, "next");
    playlay->addWidget(next_label, 4, 1);
    playlay->addWidget(next_line, 4, 2);

    prev_label = new QLabel(_("<b>previous</b> command: "), playboxf);
    prev_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(prev_label, prev_line, config->prevcmd, "prev");
    playlay->addWidget(prev_label, 5, 1);
    playlay->addWidget(prev_line, 5, 2);

    enqueue_label = new QLabel(_("<b>enqueue</b> command: "), playboxf);
    enqueue_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(enqueue_label, enqueue_line, config->enqueuecmd, "enqueue");
    playlay->addWidget(enqueue_label, 6, 1);
    playlay->addWidget(enqueue_line, 6, 2);

    preplay_label = new QLabel(_("<b>prelisten</b> command: "), playboxf);
    preplay_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(preplay_label, preplay_line, config->preplaycmd, "play");
    playlay->addWidget(preplay_label, 7, 1);
    playlay->addWidget(preplay_line, 7, 2);
    QToolTip::add( preplay_label, _("Track(s) will be pased to the player as playlist.") );
    QToolTip::add( preplay_line, _("Track(s) will be pased to the player as playlist.") );

    prepause_label = new QLabel(_("<b>prelisten pause</b> command: "), playboxf);
    prepause_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(prepause_label, prepause_line, config->prepausecmd, "pause");
    playlay->addWidget(prepause_label, 8, 1);
    playlay->addWidget(prepause_line, 8, 2);

    prestop_label = new QLabel(_("<b>prelisten stop</b> command: "), playboxf);
    prestop_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(prestop_label, prestop_line, config->prestopcmd, "stop");
    playlay->addWidget(prestop_label, 9, 1);
    playlay->addWidget(prestop_line, 9, 2);

    prenext_label = new QLabel(_("<b>prelisten next</b> command: "), playboxf);
    prenext_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(prenext_label, prenext_line, config->prenextcmd, "next");
    playlay->addWidget(prenext_label, 10, 1);
    playlay->addWidget(prenext_line, 10, 2);

    preprev_label = new QLabel(_("<b>prelisten previous</b> command: "), playboxf);
    preprev_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(preprev_label, preprev_line, config->preprevcmd, "prev");
    playlay->addWidget(preprev_label, 11, 1);
    playlay->addWidget(preprev_line, 11, 2);

    preenqueue_label = new QLabel(_("<b>prelisten enqueue</b> command: "), playboxf);
    preenqueue_line = new QComboBox(true, playboxf);
    generatePlayerControlLine(preenqueue_label, preenqueue_line, config->preenqueuecmd, "enqueue");
    playlay->addWidget(preenqueue_label, 12, 1);
    playlay->addWidget(preenqueue_line, 12, 2);

    #ifdef HAVE_MIXXX

    enableMixxxPlayer = new QCheckBox( _("Enable mixxx player"), playboxf);
    enableMixxxPlayer->setChecked(config->MixxxPlayerEnabled());
    QToolTip::add
        ( enableMixxxPlayer, _("When checked, prokyon3 will add controls for mixxx to context menus.") );
    playlay->addMultiCellWidget(enableMixxxPlayer, 13, 13, 0,2);
    lmixxxhost = new QLabel(QString(_("mixxx host")) + ": ", playboxf);
    lmixxxhost->setAlignment(Qt::AlignRight);
    playlay->addWidget(lmixxxhost, 14, 1);
    mixxxhost_line = new QLineEdit(config->MixxxHost(), playboxf);
    playlay->addWidget(mixxxhost_line, 14, 2);
    lmixxxport = new QLabel(QString(_("mixxx port")) + ": ", playboxf);
    lmixxxport->setAlignment(Qt::AlignRight);
    playlay->addWidget(lmixxxport, 15,1);
    mixxxport_line = new QLineEdit(playboxf);
    mixxxport_line->setInputMask("000000");
    mixxxport_line->setText(QString::number(config->MixxxPort()));
    playlay->addWidget(mixxxport_line, 15, 2);

    connect(enableRegularPlayer, SIGNAL(clicked()), this, SLOT(slot_clickenableRegularPlayer()));
    connect(enableMixxxPlayer, SIGNAL(clicked()), this, SLOT(slot_clickenableMixxxPlayer()));
    #endif /* HAVE_MIXXX */

    playhlay->addWidget(playbox);

    QFrame *burnframe = new QFrame(this);
    QHBoxLayout *burnhlay = new QHBoxLayout(burnframe);
    QGroupBox *burnbox = new QGroupBox(1, Qt::Horizontal, "CD/DVD Burning Settings", burnframe);
    QFrame *burnboxf = new QFrame(burnbox);
    QGridLayout *burnlay = new QGridLayout(burnboxf, 2, 2);
    QLabel *l3 = new QLabel(_("<b>burnCD</b> command: "), burnboxf);
    l3->setAlignment(Qt::AlignRight);
    burnlay->addWidget(l3, 0, 0);
    burnCD_line = new QLineEdit(config->burnCDcmd, burnboxf);
    QToolTip::add
        ( burnCD_line, _("Program used to burn CD. Selected tracks are passed as command parameters.") );
    burnlay->addWidget(burnCD_line, 0, 1);

    QLabel *l4 = new QLabel(_("<b>k3b</b> command: "), burnboxf);
    l4->setAlignment(Qt::AlignRight);
    burnlay->addWidget(l4, 1, 0);
    k3b_line = new QLineEdit(config->k3bcmd, burnboxf);
    QToolTip::add
        ( k3b_line, _("Command to run k3b, the KDE CD/DVD writing application.") );
    burnlay->addWidget(k3b_line, 1, 1);

    burnhlay->addWidget(burnbox);

    #ifdef HAVE_MEXTRAS

    QFrame *mexframe = new QFrame(this);
    QHBoxLayout *mexhlay = new QHBoxLayout(mexframe);

    QGroupBox *togbox2 = new QGroupBox(1, Qt::Horizontal, _("Musicextras toggles"), mexframe);
    mextras_bgnd = new QCheckBox( _("Background cover"), togbox2);
    mextras_bgnd->setChecked(config->mextras_bgnd());
    QToolTip::add
        ( mextras_bgnd, _("When checked, Prokyon will merge cover image into track list background.") );

    mexhlay->addWidget(togbox2);

    QFrame *mexcountframe = new QFrame(togbox2);
    QGridLayout *mexcountlay = new QGridLayout(mexcountframe, 1, 2);
    QLabel *l5 = new QLabel(_("Number of concurrent web access threads: "), mexcountframe);
    QToolTip::add
        ( l5, _("Prokyon can run more than one request to lyrics web sites in parallel to speed up scanning.\n"
                "However, some sites may ban your IP if you increase the access rate beyond a\n"
                "reasonable level.") );
    mexcountlay->addWidget(l5, 0, 0);
    mexspinbox = new QSpinBox(1,50,1,mexcountframe);
    mexspinbox->setMaximumWidth(50);
    mexspinbox->setValue(config->Mextras_count);
    mexcountlay->addWidget(mexspinbox, 0, 1, Qt::AlignLeft);

    QFrame *mexselframe = new QFrame(togbox2);
    QToolTip::add
        ( mexselframe, _("When checked, Prokyon will scan the web for this item.") );
    QGridLayout *mexsellay = new QGridLayout(mexselframe, 2, 4);

    checkartist = new QCheckBox( _("Artist image"), mexselframe);
    checkartist->setChecked(config->getcheckartist() );
    mexsellay->addWidget(checkartist, 0, 0);

    checkcover = new QCheckBox( _("Album cover image"), mexselframe);
    checkcover->setChecked(config->getcheckcover() );
    mexsellay->addWidget(checkcover, 0, 1);

    checklyrics = new QCheckBox( _("Lyrics"), mexselframe);
    checklyrics->setChecked(config->getchecklyrics() );
    mexsellay->addWidget(checklyrics, 0, 2);

    checkyears = new QCheckBox( _("Years active"), mexselframe);
    checkyears->setChecked(config->getcheckyears() );
    mexsellay->addWidget(checkyears, 0, 3);

    checkalbum = new QCheckBox( _("Album review"), mexselframe);
    checkalbum->setChecked(config->getcheckalbum() );
    mexsellay->addWidget(checkalbum, 1, 0);

    checktracks = new QCheckBox( _("Album tracks"), mexselframe);
    checktracks->setChecked(config->getchecktracks() );
    mexsellay->addWidget(checktracks, 1, 1);

    checksyncedlyrics = new QCheckBox( _("Synced Lyrics"), mexselframe);
    checksyncedlyrics->setChecked(config->getchecksyncedlyrics() );
    mexsellay->addWidget(checksyncedlyrics, 1, 2);


    checkbiography = new QCheckBox( _("Biography"), mexselframe);
    checkbiography->setChecked(config->getcheckbiography() );
    mexsellay->addWidget(checkbiography, 1, 3);

    #endif /* HAVE_MEXTRAS */

    #ifdef HAVE_LIBMUSICBRAINZ

    QFrame *mbframe = new QFrame(this);
    QHBoxLayout *mbhlay = new QHBoxLayout(mbframe);

    QGroupBox *mbbox = new QGroupBox(1, Qt::Horizontal, "Settings", mbframe);
    QFrame *mbboxf = new QFrame(mbbox);
    QGridLayout *mbglay = new QGridLayout(mbboxf, 2, 2);

    QLabel *mbhostlabel = new QLabel("<b>" + QString(_("Host")) + ": </b>", mbboxf);
    mbhostlabel->setAlignment(Qt::AlignRight);
    mbglay->addWidget(mbhostlabel, 0, 0);
    QLabel *mbportlabel = new QLabel("<b>" + QString(_("Port")) + ": </b>", mbboxf);
    mbportlabel->setAlignment(Qt::AlignRight);
    mbglay->addWidget(mbportlabel, 1, 0);

    musicBrainzServer_line = new QLineEdit(config->musicbrainz_server, mbboxf);
    mbglay->addWidget(musicBrainzServer_line, 0, 1);
    musicBrainzPort_line = new QLineEdit(mbboxf);
    musicBrainzPort_line->setInputMask("000000");
    musicBrainzPort_line->setText(QString::number(config->musicbrainz_port));
    mbglay->addWidget(musicBrainzPort_line, 1, 1);

    mbhlay->addWidget(mbbox);
    #endif /* HAVE_LIBMUSICBRAINZ */

    addTab(togframe,   _("Toggles") );
    addTab(playframe,  _("Players") );
    addTab(dbframe,    _("Database") );
    addTab(dirframe,   _("Directories") );
    addTab(sharesframe,_("Shares") );
    addTab(burnframe,  _("CD Burning") );
    #ifdef HAVE_MEXTRAS

    addTab(mexframe,   _("Musicextras") );
    #endif /* HAVE_MEXTRAS */
    #ifdef HAVE_LIBMUSICBRAINZ

    addTab(mbframe,    _("MusicBrainz") );
    #endif /* HAVE_LIBMUSICBRAINZ */

    setOkButton();
    setCancelButton( _("Cancel") );

    slot_selectionChanged();

    if(gui->getConnectionState())
        dbbox->setEnabled(false);

    #ifdef HAVE_MIXXX

    if( !config->MixxxPlayerEnabled() ) {
        // TODO : labels are not enabled when you click on the checkbox actually
        // need to fix Configuration_Dialog::slot_clickenableMixxxPlayer()
        lmixxxport->setEnabled(false);
        mixxxport_line->setEnabled(false);
        lmixxxhost->setEnabled(false);
        mixxxhost_line->setEnabled(false);
    }
    #endif /* HAVE_MIXXX */
}

void Configuration_Dialog::slot_clickenableRegularPlayer() {
    #ifdef HAVE_MIXXX
    bool show = enableRegularPlayer->isChecked();
    play_label->setEnabled(show);
    play_line->setEnabled(show);
    pause_label->setEnabled(show);
    pause_line->setEnabled(show);
    stop_label->setEnabled(show);
    stop_line->setEnabled(show);
    next_label->setEnabled(show);
    next_line->setEnabled(show);
    prev_label->setEnabled(show);
    prev_line->setEnabled(show);
    enqueue_label->setEnabled(show);
    enqueue_line->setEnabled(show);
    preplay_label->setEnabled(show);
    preplay_line->setEnabled(show);
    prepause_label->setEnabled(show);
    prepause_line->setEnabled(show);
    prestop_label->setEnabled(show);
    prestop_line->setEnabled(show);
    prenext_label->setEnabled(show);
    prenext_line->setEnabled(show);
    preprev_label->setEnabled(show);
    preprev_line->setEnabled(show);
    preenqueue_label->setEnabled(show);
    preenqueue_line->setEnabled(show);
    #endif /* HAVE_MIXXX */
}

void Configuration_Dialog::slot_clickenableMixxxPlayer() {
    #ifdef HAVE_MIXXX
    if(enableMixxxPlayer->isChecked()) {
        lmixxxport->setEnabled(true);
        mixxxport_line->setEnabled(true);
        lmixxxhost->setEnabled(true);
        mixxxhost_line->setEnabled(true);
    } else {
        lmixxxport->setEnabled(false);
        mixxxport_line->setEnabled(false);
        lmixxxhost->setEnabled(false);
        mixxxhost_line->setEnabled(false);
    }
    #endif /* HAVE_MIXXX */
}

void Configuration_Dialog::slot_selectionChanged() {
    if(hddlist->selectedItem() == 0) {
        hddedit->setEnabled(false);
        hddremove->setEnabled(false);
    } else {
        hddedit->setEnabled(true);
        hddremove->setEnabled(true);
    }
}

void Configuration_Dialog::slot_hddadd() {
    QString filename = QFileDialog::getExistingDirectory("/", this);
    if(!filename.isNull()) {
        QListViewItem *curr = hddlist->firstChild();
        while(curr) {
            if(curr->text(0) == filename)
                break;
            curr = curr->nextSibling();
        }
        if(curr)
            QMessageBox::information(this, "Message", _("The chosen directory is already in use"), QMessageBox::Ok);
        else {
            QListViewItem *item = new QListViewItem(hddlist, filename);
            item->setPixmap(0, pixmapcache->get
                            ("artist.png"));
            hddlist->setSelected(item, true);
        }
    }
}

void Configuration_Dialog::slot_hddedit() {
    QString filename = QFileDialog::getExistingDirectory(hddlist->selectedItem()->text(0), this);
    if(!filename.isNull()) {
        QListViewItem *curr = hddlist->firstChild();
        while(curr) {
            if(curr->text(0) == filename && curr != hddlist->selectedItem())
                break;
            curr = curr->nextSibling();
        }
        if(curr)
            QMessageBox::information(this, "Message", _("The chosen directory is already in use"), QMessageBox::Ok);
        else {
            hddlist->selectedItem()->setText(0, filename);
        }
    }
}

void Configuration_Dialog::slot_hddremove() {
    hddlist->takeItem(hddlist->selectedItem());
    if(hddlist->firstChild() != 0)
        hddlist->setSelected(hddlist->firstChild(), true);
}


void Configuration_Dialog::generatePlayerControlLine (QLabel *label, QComboBox *line, QString cmd, QString action) {
    label->setAlignment(Qt::AlignRight);
    if(cmd.startsWith("amarok")) {
        line->insertItem(pixmapcache->get("amarok.png"), cmd);
    } else if(cmd.startsWith("beep-media-player")) {
        line->insertItem(pixmapcache->get("beep-media-player.png"), cmd);
    } else if(cmd.startsWith("kaffeine")) {
        line->insertItem(pixmapcache->get("kaffeine.png"),cmd);
    } else if(cmd.startsWith("mplayer")) {
        line->insertItem(pixmapcache->get("mplayer.png"), cmd);
    } else if(cmd.startsWith("noatun")) {
        line->insertItem(pixmapcache->get("noatun.png"), cmd);
    } else if(cmd.startsWith("totem")) {
        line->insertItem(pixmapcache->get("totem.png"), cmd);
    } else if(cmd.startsWith("xmms")) {
        line->insertItem(pixmapcache->get("xmms.png"), cmd);
    } else {
        line->insertItem(cmd);
    }
    line->insertItem(pixmapcache->get("amarok.png"), config->playerOptions["amarok"][action]);
    line->insertItem(pixmapcache->get("beep-media-player.png"), config->playerOptions["beep-media-player"][action]);
    line->insertItem(pixmapcache->get("kaffeine.png"), config->playerOptions["kaffeine"][action]);
    line->insertItem(pixmapcache->get("mplayer.png"), config->playerOptions["mplayer"][action]);
    line->insertItem(pixmapcache->get("noatun.png"), config->playerOptions["noatun"][action]);
    line->insertItem(pixmapcache->get("totem.png"), config->playerOptions["totem"][action]);
    line->insertItem(pixmapcache->get("xmms.png"), config->playerOptions["xmms"][action]);
}

Configuration_Dialog::~Configuration_Dialog() {}

