/* $Cambridge: hermes/src/prayer/cmd/cmd_reply.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"
#include "cmd.h"

void cmd_reply(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct pool *pool = tvals->pool;
    struct request *request = session->request;
    struct draft *draft = session->draft;
    char *s, *opt_cc = NIL;
    MAILSTREAM *stream = session->stream;
    MESSAGECACHE *elt;
    ENVELOPE *env;
    ADDRESS *sender;
    struct buffer *b = request->write_buffer;
    unsigned long msgno, msguid;
    BOOL have_reply_flag = NIL;
    BOOL reply_all = NIL;
    char *string;

    if (request->argc >= 4) {
        msgno = atoi(request->argv[2]);
        msguid = atoi(request->argv[3]);
        session->current = msgno;

        have_reply_flag = T;
        if (!strcmp(request->argv[1], "all"))
            reply_all = T;
    } else if (request->argc == 3) {
        msgno = atoi(request->argv[1]);
        msguid = atoi(request->argv[2]);
        session->current = msgno;

    } else if (request->argc == 2) {
        msgno = session->current;
        msguid = ml_uid(session, stream, msgno);
        session->current = msgno;

        have_reply_flag = T;
        if (!strcmp(request->argv[1], "all"))
            reply_all = T;
    } else {
        msgno = session->current;
        msguid = ml_uid(session, stream, msgno);
    }

    if (!(msgno = stream_check_uid(session, stream, msgno, msguid))) {
        session_redirect(session, request, "list");
        return;
    }

    if (!((elt = ml_elt(session, stream, msgno)) &&
          (env = ml_fetch_structure(session, stream, msgno, NIL, 0)))) {
        session_redirect(session, request, "restart");
        return;
    }

    session->reply_all = NIL;   /* Clear Reply to all flag */
    draft_role_set(draft, NIL); /* Clear Role indication */

    sender = (env->reply_to) ? (env->reply_to) : (env->from);

    /* Calculate possible Cc value from message recipients */
    if (env->to) {
        opt_cc =
            addr_text_exclude(session, request->pool, env->to, sender);

        if (env->cc) {
            s = addr_text_exclude(session, request->pool, env->cc, sender);
            if (s && s[0]) {
                if (opt_cc && opt_cc[0])
                    opt_cc = pool_strcat3(request->pool, opt_cc, ", ", s);
                else
                    opt_cc = pool_strdup(request->pool, s);
            }
        }
    } else if (env->cc)
        opt_cc =
            addr_text_exclude(session, request->pool, env->cc, sender);

    if (have_reply_flag) {
        /* Don't need to ask user here */
        session->reply_all = reply_all;
        cmd_reply1(session);
        return;
    }

    if (!(opt_cc && opt_cc[0])) {
        /* Don't need to ask user here */
        cmd_reply1(session);
        return;
    }

    string = addr_text(pool, sender);
    string = (char *)
        rfc1522_decode(pool_alloc(pool, strlen(string)),
                       strlen(string), string, NIL);
    template_vals_string(tvals, "sender", string);

    string = opt_cc;
    string = (char *)
        rfc1522_decode(pool_alloc(pool, strlen(string)),
                       strlen(string), string, NIL);
    template_vals_string(tvals, "recipients", string);
    
    string = env->subject;
    if (string && string[0]) {
        string = (char *)
            rfc1522_decode(pool_alloc(pool, strlen(string)),
                           strlen(string), string, NIL);
    } else
        string = "No subject";
    template_vals_string(tvals, "subject", string);

    session_seed_template(session, tvals);
    template_expand("reply", tvals, b);
    response_html(request, 200);
}
