/* ----------------------------------------------------------------------------
 * powerprefs.c
 * Tool to toogle certain functions of pbbuttonsd.
 * It has an GTK interface and needs X.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <signal.h>
#include <gtk/gtk.h>

#include <pbb.h>

#ifdef ENABLE_NLS
#  include <locale.h>
#endif

#include "msghandler.h"
#include "interface.h"
#include "support.h"
#include "init.h"

volatile sig_atomic_t prgexit = 0;
volatile struct basedata masterdata;

int main(int argc, char *argv[])
{
	struct basedata *base = (struct basedata*) &masterdata;
	int rc = 1;

#ifdef ENABLE_NLS
	setlocale(LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (GETTEXT_PACKAGE);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif

	gtk_init (&argc, &argv);
	init_libpbb ();  /* initialise the libpbb library */
	
	if((rc = evaluate_args(argc, argv)) == 0) {		/* evaluate command line */
		add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
		add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");
		if ((rc = init_powerprefs (base)) == 0) {
			if (! install_sighandler ()) {
				if ((rc = get_server_config(base)) == 0) {
					gui_finetuning(base);  /* fix last screws */
					gtk_timeout_add(POLLTIME, timeout_callback, base);
					gtk_main();
					rc = 0;
				}
			}
			exit_powerprefs(base);
		}
	}
	if (rc == E_INFO) rc = 0; /* E_INFO isn't a real error */
	exit (rc);
}

/* debug function in libpbb.a, if compiled with --enable-debug */
void peep_ipc (struct tagitem *taglist) { }
