#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/times.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <fcntl.h>
#include <termios.h>
#include <termio.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

#include "server.h"
#include "rot_buffer.h"

void do_telnet_options(void);
int main_routine_socket(int DeviceFd, int poll_interval);
void fill_auth_struct(struct auth *ai);

struct auth		*pai;

/* Device file descriptor */
int DeviceFd;
static int		max_fd=0;
static fd_set	list_fds;

/* Function executed when the program exits */
void ExitFunction(void)
  {
	int fd;

	/* Program termination notification */
	nsyslog(LOG_NOTICE,"socket stopped");
	
	if (pai->do_acct) {
		pai->do_acct = 0;
		rad_acct(pai, 0);   
	}

	close(0);
	close(1);
	close(2);

	serial_close(DeviceFd);

#ifdef FIXME
	stop_start_buffering(1);
#endif

	/* Closes the sockets/ttySxx */
	for(fd=0; fd < max_fd; fd++) {
		if (FD_ISSET(fd, &list_fds)) {
			close(fd);
		}
	}
  }
  
/* Main function */

#define TELNET_PORT 23
#define MAX_RETRIES 5
#define MAX_WAIT_TIMER	8

void create_socket_server(struct sockaddr_in *sock, char *devname, fd_set *fds, int *max)
{
	char	str[40];
	int		fd, len = sizeof(struct sockaddr_in);
	int		retries = 0, on = 1;
	struct linger LingerParm = {0, 0};

	sprintf(str, "%s/%d", inet_ntoa(sock->sin_addr), sock->sin_port);

	while (++retries < MAX_RETRIES) {
		if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
			nsyslog(LOG_ERR, "Create server socket [%s] error: %s", str, strerror(errno));
			xsleep(MAX_WAIT_TIMER);
			continue;
		}

		/* Set socket options.  We try to make the port reusable and have it
		   close as fast as possible without waiting in unnecessary wait states
		   on close. */
		setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, (void *)&on, sizeof(on));
		setsockopt(fd, SOL_SOCKET, SO_LINGER, &LingerParm, sizeof(LingerParm));

		if (bind(fd, (struct sockaddr *)sock, len) < 0) {
			nsyslog(LOG_ERR, "Bind socket [%s] error: %s", str, strerror(errno));
			close(fd);
			xsleep(MAX_WAIT_TIMER);
			continue;
		}

		if (listen(fd, 2) < 0) {
			nsyslog(LOG_ERR, "Listen socket [%s] error: %s", str, strerror(errno));
			close(fd);
			xsleep(MAX_WAIT_TIMER);
			continue;
		}
		break;
	}

	if (retries >= MAX_RETRIES) {
		return;
	}

	FD_SET(fd, fds);

	if ((fd + 1) > *max) {
		*max = fd + 1;
	}

	nsyslog(LOG_INFO, "socket: listen to [%s] device /dev/%s\n", str, devname);

}

static bool got_int_flag = false;

void got_int(int unused)
{
	got_int_flag = true;
}

int do_socket_auth(struct auth *ai)
{
	char s[1024];
	int  len, i, r;

	pai->do_acct = 0;

	if(lineconf.authtype == AUTH_NONE || ai->proto != P_SOCKET_SERVER)
	{
        	update_utmp("%L", lineconf.utmpfrom, ai, lineconf.syswtmp);
		return(0);
	}

	/*
	 *  Show the banner and say hello.
	 */
	if(lineconf.issue && lineconf.issue[0]) {
		expand_format(s, sizeof(s), lineconf.issue, ai);
		if (s) {
			len = strlen(s);
			write(STDOUT_FILENO, s, len);
		}
	}

	for(i=0; i < 3; i++) {
		r = do_login(ai);

		if (r == 2)	continue;

		if (r < 0)	return(1);

		/*
		 *	Do authentication if needed.
		 */


		if (!do_local_or_server_authentication(ai, 0)) {
			break;
		}

	}

	if (i >= 3) {
		/*
		 *	3 login failures - exit!
		 */
		xusleep(250000);
		maketermsane();
		return(1);
	}

	if (ai->do_acct == 1) {
		/*
		 *	While messing around with accounting, we have to
		 *	block, but not ignore, SIGHUP and friends.
		 */
		block(SIGHUP);
		block(SIGTERM);

		rad_acct(ai, 1);

		unblock(SIGHUP);
		unblock(SIGTERM);

	}
	return(0);
}

int do_socket(struct auth *ai)
{
	socklen_t addr_len;
	int	 server_fd, client_fd, signals;
	struct sockaddr_in	sock_server, sock_client;
	struct sigaction sa;
	fd_set	list_aux;

	memset(&sa, 0, sizeof(sa));
	pai = ai;

	atexit(ExitFunction);

	sa.sa_handler = got_int;
	sigaction(SIGINT,  &sa, NULL);
	sigaction(SIGTERM, &sa, NULL);
	unblock(SIGINT);
	unblock(SIGTERM);

	if(lineconf.protocol == P_SOCKET_SERVER)
	{
		FD_ZERO(&list_fds);

		/* create all socket to listen to */
		if(lineconf.socket_port)
		{
			/* Socket with a especific port */
			sock_server.sin_family = AF_INET;
			sock_server.sin_addr.s_addr = lineconf.loc_host;
			sock_server.sin_port = lineconf.socket_port;
			create_socket_server(&sock_server, lineconf.tty, &list_fds, &max_fd);
		}
		if(lineconf.rem_host)
		{
			/* Socket with a especific ip address */
			sock_server.sin_addr.s_addr = lineconf.rem_host;
			sock_server.sin_family = AF_INET;
			sock_server.sin_port = TELNET_PORT;
			create_socket_server(&sock_server, lineconf.tty, &list_fds, &max_fd);
		}

		if (!max_fd) {
			nsyslog(LOG_ERR, "Socket: Could not create any socket to listen to...");
			return(0);
		}

		list_aux = list_fds;

		if (select(max_fd, &list_aux, NULL, NULL, NULL) < 0) {
			return(0);
		}

		for(server_fd=0; server_fd < max_fd; server_fd++) {
			if ((FD_ISSET(server_fd, &list_aux))) {
				break;
			}
		}
		if (server_fd >= max_fd) {
			return(0);
		}
		/* Validate the connection request */
		addr_len = sizeof(sock_client);
		close(0);
		close(1);
		close(2);
		client_fd = accept(server_fd, (struct sockaddr *)&sock_client, &addr_len);
		ai->address= sock_client.sin_addr.s_addr;

		dup(client_fd);
		dup(client_fd);

#if 0
		for(server_fd=0; server_fd < max_fd; server_fd++) {
			if (FD_ISSET(server_fd, &list_fds)) {
				close(server_fd);
				FD_CLR(server_fd, &list_fds);
			}
		}
#endif
#ifdef FIXME
		do_telnet_options();
#endif

		if (do_socket_auth(pai)) {
			nsyslog(LOG_NOTICE,"Authentication Failure");
			return(0);
		}

#ifdef FIXME
		stop_start_buffering(0);
#endif

		if ((DeviceFd = getty(pai, eLocSocSrv)) < 0) {
			nsyslog(LOG_ERR,"Error when openning %s", lineconf.tty);
			return(0);
		}

		if(lineconf.dcd)
		{ /* must check DCD */
			ioctl(DeviceFd,TIOCMGET,&signals);
			signals = signals | TIOCM_DTR;
			ioctl(DeviceFd,TIOCMSET,&signals);
			ioctl(DeviceFd, TIOCMGET, &signals);
			if (!(signals & TIOCM_CD) ) { /* DCD is OFF */
				nsyslog(LOG_NOTICE,"Fail to connect due to DCD OFF");
				return(0);
			}
		}

		update_utmp("%L", lineconf.utmpfrom, ai, lineconf.syswtmp);
#ifdef FIXME
		main_routine_socket(DeviceFd, lineconf.poll_interval);
#endif
	} else {
		DeviceFd = dup(0);
		close(0);
		close(1);
		close(2);

		if(lineconf.dcd)
		{ /* must check DCD */
			ioctl(DeviceFd,TIOCMGET,&signals);
			signals = signals | TIOCM_DTR;
			ioctl(DeviceFd,TIOCMSET,&signals);
			while(1)
			{
				ioctl(DeviceFd, TIOCMGET, &signals);
				if (signals & TIOCM_CD) { /* DCD is ON */
					break;
				}
				xsleep(1);
				
				if(got_int_flag)
					return(0);
			}
		}

		sock_client.sin_family = AF_INET;
		sock_client.sin_addr.s_addr = lineconf.host;
		sock_client.sin_port = lineconf.socket_port ? lineconf.socket_port : TELNET_PORT;
		addr_len = sizeof(sock_client);
		if ((client_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
			nsyslog(LOG_ERR, "Create client socket error: %s", strerror(errno));
			return(0);
		}

		if (connect(client_fd, (struct sockaddr *)&sock_client, addr_len) < 0) {
			nsyslog(LOG_ERR, "Connect socket error: %s", strerror(errno));
			return(0);
		}

		nsyslog(LOG_INFO, "socket: connected to %s port %d device %s\n", inet_ntoa(sock_client.sin_addr), sock_client.sin_port, lineconf.tty);
		dup(client_fd);
		dup(client_fd);
		update_utmp("%L", lineconf.utmpfrom, ai, lineconf.syswtmp);

#ifdef FIXME
		do_telnet_options();

		main_routine_socket(DeviceFd, lineconf.poll_interval);
#endif
	}
	return(0);
}

