/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef PXMCHEM_FINDMASSOPT_H
#define PXMCHEM_FINDMASSOPT_H

#include "libpolyxmass-globals.h"
#include "libpolyxmass-prop.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


  typedef struct _PxmFindmassOpt PxmFindmassOpt;


  struct _PxmFindmassOpt
  {
    /* Mass type to find.
     */
    PxmMassType mass_type;
  
    /* Mass to find.
     */
    gdouble mass;
  
    /* Type of the tolerance: atomic mass unit, percentage, ppm.
     */
    PxmMassTolerance tolerance_type;

    /* Tolerance value.
     */
    gdouble tolerance;
  };
  
 

  /* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
   */
  PxmFindmassOpt *
  pxmchem_findmassopt_new (void);
  
  PxmFindmassOpt *
  pxmchem_findmassopt_dup (PxmFindmassOpt *fmopt, PxmHowDup how_dup);
  
  PxmProp *
  pxmchem_findmassopt_prop_dup (PxmProp * prop, PxmHowDup how_dup);
  

  /* UTILITY FUNCTIONS
   */
  gboolean
  pxmchem_findmassopt_set_default (PxmFindmassOpt *smopt);
  
  
  /* FREE'ING FUNCTIONS
   */
  gboolean
  pxmchem_findmassopt_free (PxmFindmassOpt *smopt);

  gint 
  pxmchem_findmassopt_prop_free (PxmProp *prop);
  




  /* GPtrArray-RELATED FUNCTIONS
   */
  gint
  pxmchem_findmassopt_GPA_free (GPtrArray *GPA);
  













#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif /* PXMCHEM_FINDMASSOPT_H */




