/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef LIBPOLYXMASS_NOTE_H
#define LIBPOLYXMASS_NOTE_H


#include "libpolyxmass-globals.h"
#include "libpolyxmass-prop.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


  typedef struct _PxmNote PxmNote;
  typedef struct _PxmNoteVal PxmNoteVal;
  typedef enum _PxmNoteValType PxmNoteValType;

  typedef enum _PxmNoteCmp PxmNoteCmp;
  typedef enum _PxmNoteDup PxmNoteDup;

  typedef enum _PxmNoteValCmp PxmNoteValCmp;
  typedef enum _PxmNoteValDup PxmNoteValDup;

  typedef enum _PxmNotePropCmp PxmNotePropCmp;
  typedef enum _PxmNotePropDup PxmNotePropDup;


  enum _PxmNoteValType
    {
      PXM_NOTE_VAL_TYPE_STR = 0,
      PXM_NOTE_VAL_TYPE_INT = 1,
      PXM_NOTE_VAL_TYPE_DBL = 2
    };

  

  /* A PxmNote object is made of one compulsory 'name' string and of
     an array of PxmNoteVal objects. While the array must exist, it can
     be empty.
  */
  struct _PxmNote
  {
    gchar *name;
 
    GPtrArray *notevalGPA;
  };

  struct _PxmNoteVal
  {
    PxmNoteValType type;
    gpointer value;
  };


  /* HELPER FUNCTIONS
   */



  /* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
   */
  PxmNote *
  libpolyxmass_note_new (void);

  PxmNoteVal *
  libpolyxmass_noteval_new (void);

  PxmProp *
  libpolyxmass_note_prop_new (void);

  PxmNote *
  libpolyxmass_note_dup (PxmNote *note, PxmHowDup how_dup);

  PxmProp*
  libpolyxmass_note_prop_dup (PxmProp *prop, PxmHowDup how_dup);



  /*  LOCATING FUNCTIONS
   */
  gint
  libpolyxmass_noteval_get_index_by_noteval (PxmNoteVal *noteval, 
					     GPtrArray *GPA);



  /* DATA MODIFYING FUNCTIONS
   */
  gchar *
  libpolyxmass_note_set_name (PxmNote *note, gchar *name);



  /* COMPARISON FUNCTIONS
   */
  gint
  libpolyxmass_note_cmp (PxmNote *note1,
		     PxmNote *note2,
		     PxmHowCmp how_cmp);

  gint
  libpolyxmass_noteval_cmp (PxmNoteVal *noteval1,
			    PxmNoteVal *noteval2);

  gint
  libpolyxmass_note_prop_cmp (PxmProp *prop1,
			      PxmProp *prop2,
			      PxmHowCmp how_cmp);




  /* RENDERING FUNCTIONS - FORMATTER FUNCTIONS
   */
  gchar *
  libpolyxmass_note_prop_format_xml_note (PxmProp *prop,
					  gchar *indent,
					  gint offset,
					  gpointer user_data);
  
  gchar *
  libpolyxmass_note_prop_format_txt_note (PxmProp *prop,
					  gpointer user_data);
  
  PxmProp *
  libpolyxmass_note_prop_render_xml_note (xmlDocPtr xml_doc,
					  xmlNodePtr xml_node,
					  gpointer user_data);
  


  /* FREE'ING FUNCTIONS
   */
  gint 
  libpolyxmass_note_free (PxmNote *note);

  gint 
  libpolyxmass_noteval_GPA_empty (GPtrArray *GPA);

  gint 
  libpolyxmass_noteval_free (PxmNoteVal *noteval);

  gint 
  libpolyxmass_note_prop_free (PxmProp *prop);

  gint 
  libpolyxmass_note_prop_free_but_not_data (PxmProp *prop);







#ifdef __cplusplus
}
#endif /* __cplusplus */





#endif
/* ifndef LIBPOLYXMASS_NOTE_H
 */





