/***************************************************************************
 *   Copyright (C) 2004-2005 by Adam Jakubek <mig21@static.int.pl>         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../config.h"
#include <qcheckbox.h>
#include <qcolordialog.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qsettings.h>
#include <qslider.h>
#include "MainForm.h"

MainForm::MainForm() : MainFormBase(0, 0, false,
	WStyle_Customize | WStyle_NormalBorder | WStyle_Title |
	WStyle_SysMenu | WStyle_Minimize)
{
#ifndef HAVE_XRENDER
	comboBox1->removeItem(3);
#endif
	readSettings();
	// override state changes
	isModified = false;
}

MainForm::~MainForm()
{
}

void MainForm::engineChange(int index)
{
	if (!index)
		slider1->setEnabled(false);
	else
		slider1->setEnabled(true);
	setModified();
}

void MainForm::opacityChange(int opacity)
{
	if (opacity < 0)
		opacity = 0;
	else if (opacity > 100)
		opacity = 100;
	QString str = QString::number(opacity) + "%";
	textLabel4->setText(str);
}

void MainForm::setModified()
{
	isModified = true;
}

void MainForm::customOverHighlight()
{
	QColor col =
		QColorDialog::getColor(pushButton1->paletteBackgroundColor(), this);
	if (col.isValid())
		pushButton1->setPaletteBackgroundColor(col);
	setModified();
}

void MainForm::customFocusHighlight()
{
	QColor col =
		QColorDialog::getColor(pushButton2->paletteBackgroundColor(), this);
	if (col.isValid())
		pushButton2->setPaletteBackgroundColor(col);
	setModified();
}

void MainForm::customCheckMarkColor()
{
	QColor col =
		QColorDialog::getColor(pushButton3->paletteBackgroundColor(), this);
	if (col.isValid())
		pushButton3->setPaletteBackgroundColor(col);
	setModified();
}

void MainForm::closeEvent(QCloseEvent *e)
{
	if (isModified)
	{
		int sel = QMessageBox::question(this, tr("Polymer configuration"),
			tr("Do you wish to save settings before quitting?"),
			tr("&Yes"), tr("&No"), tr("&Cancel"), 0, 2);
		switch (sel)
		{
		case 0:
			if (!writeSettings())
				QMessageBox::warning(this, tr("Polymer configuration"),
					tr("Failed to save settings"), QMessageBox::Ok, QMessageBox::NoButton);
			// fall through intended
		case 1:
			e->accept();
			break;
		}
	}
	else
		e->accept();
}

void MainForm::readSettings()
{
	QSettings s;

	// Polymer specific settings
	s.beginGroup("/polymerstyle/Settings");
	if (!s.readBoolEntry("/scrollBarLines", false))
		radioButton1->setChecked(true);
	else
		radioButton2->setChecked(true);

	checkBox1->setChecked(s.readBoolEntry("/animateProgressBar", false));
	checkBox2->setChecked(s.readBoolEntry("/drawToolBarSeparator", true));
	checkBox3->setChecked(s.readBoolEntry("/drawToolBarItemSeparator", true));
	checkBox4->setChecked(s.readBoolEntry("/drawFocusRect", true));
	checkBox5->setChecked(s.readBoolEntry("/drawTriangularExpander", false));
	checkBox6->setChecked(s.readBoolEntry("/inputFocusHighlight", true));
	checkBox7->setChecked(s.readBoolEntry("/customOverHighlightColor", false));
	if (!checkBox7->isChecked())
		pushButton1->setEnabled(false);
	QColor over(s.readEntry("/overHighlightColor", "black"));
	if (!over.isValid())
		over.setNamedColor("black");
	pushButton1->setPaletteBackgroundColor(over);
	checkBox8->setChecked(s.readBoolEntry("/customFocusHighlightColor", false));
	if (!checkBox8->isChecked())
		pushButton2->setEnabled(false);
	QColor focus(s.readEntry("/focusHighlightColor", "black"));
	if (!focus.isValid())
		focus.setNamedColor("black");
	pushButton2->setPaletteBackgroundColor(focus);
	checkBox9->setChecked(s.readBoolEntry("/customCheckMarkColor", false));
	if (!checkBox9->isChecked())
		pushButton3->setEnabled(false);
	QColor checkmark(s.readEntry("/checkMarkColor", "black"));
	if (!checkmark.isValid())
		checkmark.setNamedColor("black");
	pushButton3->setPaletteBackgroundColor(checkmark);
	s.endGroup();

	// KStyle specific settings
	QString engine = s.readEntry("/KStyle/Settings/MenuTransparencyEngine", "Disabled");
	if (engine == "SoftwareTint")
		comboBox1->setCurrentItem(1);
	else if (engine == "SoftwareBlend")
		comboBox1->setCurrentItem(2);
	else if (engine == "XRender")
#ifdef HAVE_XRENDER
		comboBox1->setCurrentItem(3);
#else
		comboBox1->setCurrentItem(2);
#endif
	else
		comboBox1->setCurrentItem(0);

	if (!comboBox1->currentItem())
		slider1->setEnabled(false);
	else
		slider1->setEnabled(true);

	int opacity = static_cast<int>(s.readDoubleEntry("/KStyle/Settings/MenuOpacity", 0.90) * 100);
	if (opacity < 0)
		opacity = 0;
	else if (opacity > 100)
		opacity = 100;
	slider1->setValue(opacity);

	checkBox10->setChecked(s.readBoolEntry("/KStyle/Settings/MenuDropShadow", false));
}

bool MainForm::writeSettings()
{
	QSettings s;
	bool ok = true;

	// Polymer specific settings
	s.beginGroup("/polymerstyle/Settings");
	ok = s.writeEntry("/scrollBarLines", !radioButton1->isChecked()) && ok;
	ok = s.writeEntry("/animateProgressBar", checkBox1->isChecked()) && ok;
	ok = s.writeEntry("/drawToolBarSeparator", checkBox2->isChecked()) && ok;
	ok = s.writeEntry("/drawToolBarItemSeparator", checkBox3->isChecked()) && ok;
	ok = s.writeEntry("/drawFocusRect", checkBox4->isChecked()) && ok;
	ok = s.writeEntry("/drawTriangularExpander", checkBox5->isChecked()) && ok;
	ok = s.writeEntry("/inputFocusHighlight", checkBox6->isChecked()) && ok;
	ok = s.writeEntry("/customOverHighlightColor", checkBox7->isChecked()) && ok;
	QColor over = pushButton1->paletteBackgroundColor();
	if (!over.isValid())
		over.setNamedColor("black");
	ok = s.writeEntry("/overHighlightColor", over.name()) && ok;
	ok = s.writeEntry("/customFocusHighlightColor", checkBox8->isChecked()) && ok;
	QColor focus = pushButton2->paletteBackgroundColor();
	if (!focus.isValid())
		focus.setNamedColor("black");
	ok = s.writeEntry("/focusHighlightColor", focus.name()) && ok;
	ok = s.writeEntry("/customCheckMarkColor", checkBox9->isChecked()) && ok;
	QColor checkmark = pushButton3->paletteBackgroundColor();
	if (!checkmark.isValid())
		checkmark.setNamedColor("black");
	ok = s.writeEntry("/checkMarkColor", checkmark.name()) && ok;
	s.endGroup();

	// KStyle specific settings
	QString str;
	switch (comboBox1->currentItem())
	{
	case 1:
		str = "SoftwareTint";
		break;
	case 2:
		str = "SoftwareBlend";
		break;
	case 3:
#ifdef HAVE_XRENDER
		str = "XRender";
#else
		str = "SoftwareBlend";
#endif
		break;
	default:
		str = "Disabled";
		break;
	}
	ok = s.writeEntry("/KStyle/Settings/MenuTransparencyEngine", str) && ok;

	double opacity = slider1->value() / 100.0;
	if (opacity < 0.0)
		opacity = 0.0;
	else if (opacity > 1.0)
		opacity = 1.0;
	ok = s.writeEntry("/KStyle/Settings/MenuOpacity", opacity) && ok;

	ok = s.writeEntry("/KStyle/Settings/MenuDropShadow", checkBox10->isChecked()) && ok;

	return ok;
}
