from util import *

if not PRGM.no_gui:
    import pygtk
    pygtk.require('2.0')
    import gtk
    import gobject

global group_name_map
group_name_map = {}

MAX_WINDOW_Y_SIZE=650

def do_anomaly ():
    return 'done'
    
class Anomaly:
    def __init__(self):
        self.init_gui()
    def callback (self, window, arg):
        window.destroy()
          
    def init_gui(self):
        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.window.set_title("Multiple Transition Problem")
        self.window.set_border_width(30)
        self.window.set_position(gtk.WIN_POS_MOUSE)
        box1 = gtk.VBox(0, 0)
        self.window.add(box1)
        box1.show()
        box2 = gtk.VBox(0, 10)
        box2.set_border_width(10)
        box1.pack_start(box2, 0, 0, 0)
        box2.show()

        actions = {"ppr": 'Confirm Recognized Patterns'}
        for a in actions.keys():
            button = gtk.CheckButton(actions[a])
            button.connect("toggled", self.callback, a)
            box2.pack_start(button, 1, 1, 0)
            button.show()
        self.window.show()
        
class GroupName:	
    # Call back function. 
    def enter_callback(self,widget,entry):
        global group_name_map
        entry_text = entry.get_text()
        group_name_map[entry.get_name()] = entry_text
    

    def when_done (self, window):
        global group_name_map
        for e in self.entries:
            entry_text = e.get_text()
            group_name_map[e.get_name()] = entry_text
        window.destroy()

    def __init__(self, groups):
        return self.init_gui(groups)

    def init_gui(self,groups):
        window=gtk.Window(gtk.WINDOW_TOPLEVEL)
        window.set_title("Set Names for Groups")
        # Set the size of the window.
        self.entries = []
        ysz = 1000
        nbr = len(groups)
        if 0==nbr:
                return
        if nbr < 10:
                ysz = (70 * nbr) + 60
        window.set_size_request(400, min(MAX_WINDOW_Y_SIZE,ysz))
        window.connect("delete_event",gtk.mainquit)
        # Create a  vertical box.
        vbox = gtk.VBox(0,0)
        window.add(vbox)
        vbox.show()
        for g in groups:
            entry = gtk.Entry()
            entry.set_max_length(50)
            entry.set_name(g)
            # Set the signal handler for activate that calls the callback
            # method. 
            entry.connect("activate",self.enter_callback,entry)
            entry.set_text(g)
            self.entries.append(entry)
            entry.select_region(0,len(entry.get_text()))
            vbox.pack_start(entry, 1, 1,0)
            entry.show()

        # Create a horizontal box.
        hbox = gtk.HBox(0, 0)
        vbox.add(hbox)
        hbox.show()
        button = gtk.Button("Done")
        button.connect_object("clicked", self.when_done, window)
        vbox.pack_start(button, 1, 1, 0)
        button.set_flags(gtk.CAN_DEFAULT)
        button.grab_default()

        button.show()
        window.show()


def main():
	global no_gui
	if not no_gui: gtk.main()
	return 0

if __name__ == "__main__":
	GroupName(['g1', 'g2', 'g3'])
	main()

