/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.KeyValueChunk;
import com.sixlegs.image.png.PngExceptionSoft;
import java.io.IOException;

final class Chunk_sPLT
extends Chunk {
    Chunk_sPLT() {
        super(1934642260);
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void readData() throws IOException {
        int[][] nArray;
        String string = this.in_data.readString();
        if (string.length() > 79) {
            throw new PngExceptionSoft("sPLT palette name too long");
        }
        if (this.img.data.palettes.containsKey(string = KeyValueChunk.repairKey(string))) {
            throw new PngExceptionSoft("Duplicate sPLT names");
        }
        int n = this.in_data.readUnsignedByte();
        int n2 = this.length - string.length();
        if (n == 8) {
            if (n2 % 6 != 0) {
                this.badLength();
            }
            int n3 = n2 / 6;
            nArray = new int[5][n3];
            int n4 = 0;
            while (n4 < n3) {
                nArray[0][n4] = this.in_data.readUnsignedByte();
                nArray[1][n4] = this.in_data.readUnsignedByte();
                nArray[2][n4] = this.in_data.readUnsignedByte();
                nArray[3][n4] = this.in_data.readUnsignedByte();
                nArray[4][n4] = this.in_data.readUnsignedShort();
                ++n4;
            }
        } else if (n == 16) {
            if (n2 % 10 != 0) {
                this.badLength();
            }
            int n5 = n2 / 10;
            nArray = new int[5][n5];
            int n6 = 0;
            while (n6 < n5) {
                nArray[0][n6] = this.in_data.readUnsignedShort();
                nArray[1][n6] = this.in_data.readUnsignedShort();
                nArray[2][n6] = this.in_data.readUnsignedShort();
                nArray[3][n6] = this.in_data.readUnsignedShort();
                nArray[4][n6] = this.in_data.readUnsignedShort();
                ++n6;
            }
        } else {
            throw new PngExceptionSoft("Bad sPLT sample depth: " + n);
        }
        this.img.data.palettes.put(string, nArray);
    }
}

