#lang scribble/doc
@(require "common.ss")

@title[#:tag "html-events"]{HTML Events}

  MysterX HTML events are generated by mouse and
  keyboard interaction with HTML elements in a
  document.

@definterface[mx-event<%> ()]{

@defmethod*[
([(keypress?) boolean?]
 [(keydown?) boolean?]
 [(keyup?) boolean?]
 [(mousedown?) boolean?]
 [(mousemove?) boolean?]
 [(mouseover?) boolean?]
 [(mouseout?) boolean?]
 [(mouseup?) boolean?]
 [(click?) boolean?]
 [(dblclick?) boolean?]
 [(error?) boolean?])]{

 Exactly one of these methods returns @scheme[#t] to indicate the type
 of a given event, and the others return @scheme[#f] for the event.}

@defmethod[(alt-key) boolean?]{

  Returns @scheme[#t] if the Alt key was pressed when the 
  event was generated, @scheme[#f] otherwise.}

@defmethod[(ctrl-key) boolean?]{

  Returns @scheme[#t] if the Ctrl key was pressed when the 
  event was generated, @scheme[#f] otherwise. }

@defmethod[(from-tag) string?]{

  Returns a string indicating the tag of the HTML element where the
  mouse is being moved from.  The return value is valid only for
  events for which @method[mx-event<%> mouseover?] or @method[mx-event<%>
  mouseout?] produces @scheme[#t].}

@defmethod[(from-id) string?]{

  Returns a string indicating the identifier of the HTML element where
  the mouse is being moved from.  Return value is valid only for
  events for which @method[mx-event<%> mouseover?] or @method[mx-event<%>
  mouseout?] produces @scheme[#t].}

@defmethod[(id) string?]{

  Returns a string indicating the identifier of
  the HTML element where the event occurred.}

@defmethod[(keycode) exact-integer?]{

  Returns a number indicating the keycode for the key that generated
  the event.  Return value is valid only for events for which
  @method[mx-event<%> keypress?], @method[mx-event<%> keydown?], or
  @method[mx-event<%> keyup?] produces @scheme[#t].}

@defmethod[(shift-key) boolean?]{

  Returns @scheme[#t] if the Shift key was pressed when the 
  event was generated, @scheme[#f] otherwise.}

@defmethod[(tag) string?]{

  Returns a string indicating the HTML tag of the
  element where the event occurred.}

@defmethod[(to-tag) string?]{

  Returns a string indicating the tag of the target HTML element where
  the mouse is being moved to.  Return value is valid only for events
  for which @method[mx-event<%> mouseover?] or @method[mx-event<%>
  mouseout?] produces @scheme[#t].}

@defmethod[(to-id) boolean?]{

  Returns a string indicating the identifier of the target HTML
  element where the mouse is being moved from.  Return value is valid
  only for events for which @method[mx-event<%> mouseover?] or
  @method[mx-event<%> mouseout?] produces @scheme[#t].}

@defmethod[(x) exact-integer?]{

  Returns an integer indicating the x-coordinate 
  within the document where the event occurred.}

@defmethod[(y) exact-integer?]{

  Returns an integer indicating the y-coordinate 
  within the document where the event occurred.}

}
