/*************************************************************************\
*   Copyright (C) 2009 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
\*************************************************************************/

//--- QT4 ---
#include <QByteArray>
#include <QString>
#include <QHash>
#include <QMutex>
#include <QThread>

using namespace std;

typedef QHash<QString, QByteArray> AccuWeatherConfigMap;

class AccuWeatherConfigLoader : public QThread
{
public:
	AccuWeatherConfigLoader(QObject * parent = 0);
	virtual ~AccuWeatherConfigLoader();
    
	void readConfig();
	
	AccuWeatherConfigMap * configMap();
	
	static QString createLocationCode(const QString & areaCode);
	static QString createLocationCode(const QString & areaCode,
	                                  const QString & countryCode);
	static QString createLocationCode(const QString & areaCode,
	                                  const QString & countryCode,
	                                  const QString & locationCode);
	
protected:
	void run();
	
private:
	bool getConfigPath(QString & path);
  
	AccuWeatherConfigMap * m_pMap;
};
