/* Copyright (c) 2001-2010, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;

public class DeviceParticipant {

	protected String manufacturer;
	protected String modelName;
	protected String serialNumber;
	
	public DeviceParticipant(String manufacturer,String modelName,String serialNumber) {
		this.manufacturer = manufacturer;
		this.modelName = modelName;
		this.serialNumber = serialNumber;
	}

	public String getManufacturer() { return manufacturer; }
	public String getModelName() { return modelName; }
	public String getSerialNumber() { return serialNumber; }
	
	public ContentItem getStructuredReportFragment() throws DicomException {
		ContentItemFactory cif = new ContentItemFactory();
		ContentItem root = cif.new CodeContentItem(null,"CONTAINS",new CodedSequenceItem("113876","DCM","Device Role in Procedure"),new CodedSequenceItem("113859","DCM","Irradiating Device"));
		if (manufacturer != null && manufacturer.trim().length() > 0) { cif.new TextContentItem(root,"HAS PROPERTIES",new CodedSequenceItem("113878","DCM","Device Manufacturer"),manufacturer); }
		if (modelName != null && modelName.trim().length() > 0)       { cif.new TextContentItem(root,"HAS PROPERTIES",new CodedSequenceItem("113879","DCM","Device Model Name"),modelName); }
		if (serialNumber != null && serialNumber.trim().length() > 0) { cif.new TextContentItem(root,"HAS PROPERTIES",new CodedSequenceItem("113880","DCM","Device Serial Number"),serialNumber); }
		return root;
	}

}
