/* Generated by GOB (v2.0.18)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "client/gtk/resource-view.gob"

/* Pioneers - Implementation of the excellent Settlers of Catan board game.
 *   Go buy a copy.
 *
 * Copyright (C) 2006 Giancarlo Capella <giancarlo@comm.cc>
 * Copyright (C) 2011 Roland Clobus <rclobus@rclobus.nl>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#line 30 "resource-view.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 18

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "resource-view.h"

#include "resource-view-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
/* self casting macros */
#define SELF(x) RESOURCE_VIEW(x)
#define SELF_CONST(x) RESOURCE_VIEW_CONST(x)
#define IS_SELF(x) RESOURCE_IS_VIEW(x)
#define TYPE_SELF RESOURCE_TYPE_VIEW
#define SELF_CLASS(x) RESOURCE_VIEW_CLASS(x)

#define SELF_GET_CLASS(x) RESOURCE_VIEW_GET_CLASS(x)

/* self typedefs */
typedef ResourceView Self;
typedef ResourceViewClass SelfClass;

/* here are local prototypes */
#line 44 "client/gtk/resource-view.gob"
static void resource_view_class_init (ResourceViewClass * klass) G_GNUC_UNUSED;
#line 66 "resource-view.c"
#line 87 "client/gtk/resource-view.gob"
static void resource_view_init (ResourceView * self) G_GNUC_UNUSED;
#line 69 "resource-view.c"
#line 103 "client/gtk/resource-view.gob"
static void resource_view_calculate_size (ResourceView * self, gint * width, gint * height) G_GNUC_UNUSED;
#line 72 "resource-view.c"
#line 177 "client/gtk/resource-view.gob"
static gboolean resource_view_allocate (GtkWidget * self, GtkAllocation * allocation, gpointer user_data) G_GNUC_UNUSED;
#line 75 "resource-view.c"
#line 190 "client/gtk/resource-view.gob"
static gboolean resource_view_expose (GtkWidget * self, GdkEvent * event, gpointer user_data) G_GNUC_UNUSED;
#line 78 "resource-view.c"

/* pointer to the class of our parent */
static GtkMiscClass *parent_class = NULL;

/* Short form macros */
#define self_new resource_view_new
#define self_new_single_resource resource_view_new_single_resource
#define self_calculate_size resource_view_calculate_size
#define self_set resource_view_set
#define self_set_amount_of_single_resource resource_view_set_amount_of_single_resource
#define self_allocate resource_view_allocate
#define self_expose resource_view_expose
GType
resource_view_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (ResourceViewClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) resource_view_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (ResourceView),
			0 /* n_preallocs */,
			(GInstanceInitFunc) resource_view_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_MISC, "ResourceView", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((ResourceView *)g_object_new(resource_view_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static ResourceView * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static ResourceView *
GET_NEW_VARG (const char *first, ...)
{
	ResourceView *ret;
	va_list ap;
	va_start (ap, first);
	ret = (ResourceView *)g_object_new_valist (resource_view_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Resource:View::finalize"
	ResourceView *self G_GNUC_UNUSED = RESOURCE_VIEW (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

#line 44 "client/gtk/resource-view.gob"
static void 
resource_view_class_init (ResourceViewClass * klass G_GNUC_UNUSED)
{
#line 149 "resource-view.c"
#define __GOB_FUNCTION__ "Resource:View::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) klass;

	g_type_class_add_private(klass,sizeof(ResourceViewPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_MISC);

	g_object_class->finalize = ___finalize;
 {
#line 44 "client/gtk/resource-view.gob"

		gint i;
		static const gchar *resources_pixmaps[] = {
			"brick.png",
			"grain.png",
			"ore.png",
			"wool.png",
			"lumber.png"
		};
		for (i = 0; i < NO_RESOURCE; i++) {
			gchar *filename;
			/* determine full path to pixmap file */
			filename =
			    g_build_filename(DATADIR, "pixmaps",
					     "pioneers",
					     resources_pixmaps[i], NULL);
			if (g_file_test(filename, G_FILE_TEST_EXISTS)) {
				klass->surface[i] =
				    cairo_image_surface_create_from_png
				    (filename);

			}
			g_free(filename);
		}
	
#line 185 "resource-view.c"
 }
}
#undef __GOB_FUNCTION__
#line 87 "client/gtk/resource-view.gob"
static void 
resource_view_init (ResourceView * self G_GNUC_UNUSED)
{
#line 193 "resource-view.c"
#define __GOB_FUNCTION__ "Resource:View::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,RESOURCE_TYPE_VIEW,ResourceViewPrivate);
 {
#line 87 "client/gtk/resource-view.gob"

		gint width;
		gint height;

		self->_priv->distance = 16;
		self->_priv->max_width = -1;
		resource_view_calculate_size(self, &width, &height);
		GTK_WIDGET(self)->requisition.width = width;
		GTK_WIDGET(self)->requisition.height = height;

		g_signal_connect(G_OBJECT(self), "expose_event",
				 G_CALLBACK(resource_view_expose), NULL);
		g_signal_connect(G_OBJECT(self), "size_allocate",
				 G_CALLBACK(resource_view_allocate), NULL);
	
#line 213 "resource-view.c"
 }
}
#undef __GOB_FUNCTION__


#line 70 "client/gtk/resource-view.gob"
GtkWidget * 
resource_view_new (void)
{
#line 223 "resource-view.c"
#define __GOB_FUNCTION__ "Resource:View::new"
{
#line 70 "client/gtk/resource-view.gob"
	
		return (GtkWidget *) GET_NEW;
	}}
#line 230 "resource-view.c"
#undef __GOB_FUNCTION__

#line 74 "client/gtk/resource-view.gob"
GtkWidget * 
resource_view_new_single_resource (Resource resource)
{
#line 237 "resource-view.c"
#define __GOB_FUNCTION__ "Resource:View::new_single_resource"
{
#line 74 "client/gtk/resource-view.gob"
	
		ResourceView *rv;
		gint width;

		rv = GET_NEW;
		rv->_priv->resource[resource] = 1;
		resource_view_calculate_size(rv, &width, NULL);
		GTK_WIDGET(rv)->requisition.width = width;
		gtk_widget_set_tooltip_text(GTK_WIDGET(rv),
					    resource_name(resource, TRUE));
		return GTK_WIDGET(rv);
	}}
#line 253 "resource-view.c"
#undef __GOB_FUNCTION__


#line 103 "client/gtk/resource-view.gob"
static void 
resource_view_calculate_size (ResourceView * self, gint * width, gint * height)
{
#line 261 "resource-view.c"
#define __GOB_FUNCTION__ "Resource:View::calculate_size"
#line 103 "client/gtk/resource-view.gob"
	g_return_if_fail (self != NULL);
#line 103 "client/gtk/resource-view.gob"
	g_return_if_fail (RESOURCE_IS_VIEW (self));
#line 267 "resource-view.c"
{
#line 103 "client/gtk/resource-view.gob"
	
		gint i;
		gint num_res;
		gint tot_res;

		num_res = tot_res = 0;
		for (i = 0; i < NO_RESOURCE; i++) {
			if (self->_priv->resource[i]) {
				num_res++;
				tot_res += self->_priv->resource[i];
			}
		}

		if (tot_res == 0) {
			tot_res = 1;	/* Avoid division by zero */
		}

		gint size = 16;	//gui_get_resource_pixmap_res();

		if (self->_priv->max_width <= 0 || tot_res == num_res
		    || self->_priv->max_width >= size * tot_res) {
			self->_priv->distance = size;
		} else {
			self->_priv->distance =
			    (gdouble) (self->_priv->max_width -
				       num_res * size) / (tot_res -
							  num_res);
		}

		/* Set the optimal size as a request */
		if (width != NULL) {
			*width = size * tot_res + GTK_MISC(self)->xpad * 2;
		}
		if (height != NULL) {
			*height = size + GTK_MISC(self)->ypad * 2;
		}
	}}
#line 307 "resource-view.c"
#undef __GOB_FUNCTION__

#line 141 "client/gtk/resource-view.gob"
void 
resource_view_set (ResourceView * self, const gint * resource)
{
#line 314 "resource-view.c"
#define __GOB_FUNCTION__ "Resource:View::set"
#line 141 "client/gtk/resource-view.gob"
	g_return_if_fail (self != NULL);
#line 141 "client/gtk/resource-view.gob"
	g_return_if_fail (RESOURCE_IS_VIEW (self));
#line 320 "resource-view.c"
{
#line 141 "client/gtk/resource-view.gob"
	
		gint i;
		gchar *tooltip;
		gint width;

		for (i = 0; i < NO_RESOURCE; i++) {
			self->_priv->resource[i] = resource[i];
		}

		resource_view_calculate_size(self, &width, NULL);
		GTK_WIDGET(self)->requisition.width = width;
		gtk_widget_queue_resize(GTK_WIDGET(self));
		tooltip = resource_format_num(resource);
		gtk_widget_set_tooltip_text(GTK_WIDGET(self), tooltip);
		g_free(tooltip);
	}}
#line 339 "resource-view.c"
#undef __GOB_FUNCTION__

#line 158 "client/gtk/resource-view.gob"
void 
resource_view_set_amount_of_single_resource (ResourceView * self, Resource type, guint amount)
{
#line 346 "resource-view.c"
#define __GOB_FUNCTION__ "Resource:View::set_amount_of_single_resource"
#line 158 "client/gtk/resource-view.gob"
	g_return_if_fail (self != NULL);
#line 158 "client/gtk/resource-view.gob"
	g_return_if_fail (RESOURCE_IS_VIEW (self));
#line 352 "resource-view.c"
{
#line 159 "client/gtk/resource-view.gob"
	
		gchar *tooltip;

		memset(self->_priv->resource, 0,
		       sizeof(self->_priv->resource));

		self->_priv->resource[type] = amount;

		resource_view_calculate_size(self, NULL, NULL);
		gtk_widget_queue_draw(GTK_WIDGET(self));

		tooltip =
		    g_strdup_printf("%s: %d", resource_name(type, TRUE),
				    amount);
		gtk_widget_set_tooltip_text(GTK_WIDGET(self), tooltip);
		g_free(tooltip);
	}}
#line 372 "resource-view.c"
#undef __GOB_FUNCTION__

#line 177 "client/gtk/resource-view.gob"
static gboolean 
resource_view_allocate (GtkWidget * self, GtkAllocation * allocation, gpointer user_data)
{
#line 379 "resource-view.c"
#define __GOB_FUNCTION__ "Resource:View::allocate"
{
#line 179 "client/gtk/resource-view.gob"
	
		/* Remove compiler warning */
		user_data = user_data;

		RESOURCE_VIEW(self)->_priv->max_width = allocation->width;
		resource_view_calculate_size(RESOURCE_VIEW(self), NULL,
					     NULL);
		return FALSE;
	}}
#line 392 "resource-view.c"
#undef __GOB_FUNCTION__

#line 190 "client/gtk/resource-view.gob"
static gboolean 
resource_view_expose (GtkWidget * self, GdkEvent * event, gpointer user_data)
{
#line 399 "resource-view.c"
#define __GOB_FUNCTION__ "Resource:View::expose"
{
#line 191 "client/gtk/resource-view.gob"
	
		cairo_t *cr;
		gint i;
		GtkRequisition r;
		GtkAllocation allocation;

		if (!gtk_widget_get_mapped(self)) {
			return FALSE;
		}

		/* Remove compiler warnings */
		event = event;
		user_data = user_data;

		gtk_widget_size_request(GTK_WIDGET(self), &r);
		gtk_widget_get_allocation(GTK_WIDGET(self), &allocation);

		gfloat xalign;
		gfloat yalign;
		gtk_misc_get_alignment(GTK_MISC(self), &xalign, &yalign);

		gdouble yoffset = (allocation.height - r.height) * yalign;

		if (allocation.width != -1) {
			r.width = allocation.width;
		}
		if (allocation.height != -1) {
			r.height = allocation.height;
		}

		cr = gdk_cairo_create(gtk_widget_get_window
				      (GTK_WIDGET(self)));

		gdouble offset = 0;
		for (i = 0; i < NO_RESOURCE; i++) {
			gint n;
			for (n = 0;
			     n < RESOURCE_VIEW(self)->_priv->resource[i];
			     n++) {
				cairo_set_source_surface(cr,
							 SELF_GET_CLASS
							 (self)->surface
							 [i], offset,
							 yoffset);
				cairo_rectangle(cr, 0, 0, r.width,
						r.height);
				cairo_fill(cr);
				offset +=
				    RESOURCE_VIEW(self)->_priv->distance;
			}
		};

		cairo_destroy(cr);
		return FALSE;
	}}
#line 458 "resource-view.c"
#undef __GOB_FUNCTION__
