<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:qof-qsf="http://qof.sourceforge.net/" xmlns:dt="http://xsltsl.org/date-time" xmlns:date="http://exslt.org/dates-and-times" xmlns:str="http://xsltsl.org/string" version="1.0">
  <xsl:import href="date-time.xsl"/>
  <xsl:import href="string.xsl"/>
  <xsl:import href="date.difference.xsl"/>
  <!-- our own pilot-qof standard routines -->
  <xsl:import href="pilot-qof-std.xsl"/>
  <xsl:output method="text"/>
<!-- Representing QSF XML ToDo data in a calcurse format

  This stylesheet converts the output from pilot-qof -d pilot_todo
  into a calcurse todo file, by default ~/.calcurse/todo

  See the Pilot-QOF Extensions Manual for more information.
-->
<!-- Licence

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
-->
  <xsl:template match="/">
    <xsl:message>.</xsl:message>
    <xsl:message>This stylesheet is part of pilot-qof.</xsl:message>
    <xsl:message>pilot-qof is free software (GPL) and comes with NO WARRANTY.</xsl:message>
    <xsl:message>See 'COPYING' in the pilot-qof source for more information.</xsl:message>
    <xsl:message>Writing pilot-qof data to calcurse todo.</xsl:message>

    <xsl:apply-templates select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_todo']"/>
  </xsl:template>

  <xsl:template match="/*/qof-qsf:book/qof-qsf:object[@type='pilot_todo']">
    <xsl:variable name="calcurse_due">
        <xsl:call-template name="dt:format-date-time">
          <xsl:with-param name="xsd-date-time" select="qof-qsf:time[@type='date_due']"/>
          <xsl:with-param name="format" select="'%m/%d/%Y @ %H:%M'"/>
        </xsl:call-template>
    </xsl:variable>
	<xsl:value-of select="qof-qsf:string[@type='todo_description']"/>
	<xsl:text> : Due </xsl:text>
    <xsl:value-of select="$calcurse_due"/>
	<xsl:text>&#10;</xsl:text>
  </xsl:template>
</xsl:stylesheet>
