#!/usr/bin/perl

#  This package is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

use POSIX qw(locale_h);
use strict;
use warnings;
use Config::Auto;
use File::HomeDir;
use Locale::gettext;
use vars qw / $basefile %list @dates /;

# Added to 2.0.0 too late for string freeze,
# will be translated in the next release.

# A simple check script for the paid references file.

setlocale(LC_MESSAGES, "");
textdomain("datafreedom");
my $home = File::HomeDir->my_home;
# safeguard, just in case.
$home = "/tmp" if (!$home);
my $path =  "$home/.datafreedom";
mkdir $path if (! -d $path);

%list=();
my $pfile = $path . "/paid";
if (-f $pfile)
{
	my $payments = Config::Auto::parse ("$pfile", format => "colon");
	while (my ($key, $value) = each(%$payments) )
	{
		push @{$list{join(" ", @$value)}}, $key;
	}
	printf gettext("Found payment references file: %d"), scalar keys %list;
	print " ";
	print ngettext ("listing", "listings", scalar keys %list);
	print ".\n";
}
foreach my $ref (sort keys %list)
{
	printf (gettext ("Payment Reference: %s"), $ref);
	print "\n";
	print ngettext ("Date covered", "Dates covered", scalar (@{$list{$ref}}));
	print ":\n\t" . join("\n\t", @{$list{$ref}})."\n";
}
