# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

from core import models
from core.translation import _t

#---PIL
def init():
    global Image, ImageOps
    import Image, ImageOps
    
def autocontrast(image,amount=100.0,cutoff=0):
    """Apply a filter
    - amount: 0-1
    - repeat: how many times it should be repeated"""
    if image.mode in ['RGBA']:
        im      = image.convert('RGB')
    else:
        im      = image
    contrasted  = ImageOps.autocontrast(im, cutoff)
    if image.mode == 'RGBA':
        contrasted  = contrasted.convert('RGBA')
        contrasted.putalpha(image.split()[-1])
    if amount < 100:
        return Image.blend(image, contrasted, amount/100.0)
    return contrasted

#---Phatch
class Action(models.Action):
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    label       = _t('Auto Contrast')
    version     = '0.1'
    pil         = staticmethod(autocontrast)
    tags        = [_t('colours')]
    __doc__     = _t('Maximize image contrast')
    
    def interface(self,fields):
        fields[_t('Cutoff')] = self.SliderField(0,0,100)
        fields[_t('Amount')] = self.SliderField(100,1,100)
        
    icon = \
'x\xda\x01\xc9\x0c6\xf3\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x00.\x08\x06\x00\x00\x00n\xde\x9al\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\
\x08d\x88\x00\x00\x0c\x80IDATh\x81\xc5Y{pT\xd7y\xff\x9d\xbb\xf7\xae\x1e\xbb\
\x92vW\x0bX\x12,2\xb2p,+\xd8\xe2!\xb9\xf8\x11b\xcb\xd8N:\x13k<Mc\xdcNY\x0ft\
\xa6\xa5\x9eN&mD\x1d\x1bp\x83q\xa6\xf68n`\x822\x9d&N\rCC&\xa6\x81\x1a\x1b\
\x8c\x8d\x00\x1b\xc7\x12X\x98z\xa5\x02Z@\x0f\x90\xb4+i\xb5{\xf7u\xef9\xf7\
\x9c\xfe\xb1\xda\xd5\xbe\xf4\xc0\x90\xfa\xd3\x9c\xd1y|\xe7\x9e\xdf\xef\x9c\
\xef\x9c\xef;g!\x84@F\x02L9u_qZ\xb9reu[[\xdb?|\xfe\xf9\xe7\xc7\xce\x9e=\xfb\
\xf1\xf2\xe5\xcb\x8b\x93m\xd9\xe0m\x028(\xbe\x86o\x7f\xd5\xa0\x01\x14<\xfa\
\xe8\xa3;\x1ex\xe0\x01oyy9_\xb1b\x85\xe0\x9c\x0b!\x84x\xeb\xad\xb7\x9eI\xea\
\xc9\xc8\x94 \xbe\x8bq<\x0f\r_\x91477\xaf\x07\xf0\xb7\x8b\x17/nx\xff\xfd\xf7\
S\xf8\xc6\xc6\xc6\xd0\xd9\xd1\x89\xc6\xa6F\xcc\x9b7\xef\xb6T\x87\xafz\xa6\
\x85\x10X\xbdz\xf5\x9f<\xf6\xd8c\xef\xd4\xd7\xd7\xab\x92$\t\x00\xa9d2\x99\
\xc4\x86\r\x1b\xc4G\xa7>\x12G\x8f\x1ee\xe7\xcf\x9f?\xd1\xda\xda\xbad\xca\x84\
\x80*\xf1ul\x15N\xd8\xfe?A744T<\xfe\xf8\xe3\xff\xb6j\xd5\xaa\xa1\xe2\xe2\xe2\
\x0c\xd0\x00\xc4\x13O<!\xf6\xfff\xbf\xd8\xb4i\x93\xa8\xa9\xa9\x89777\x9fhmmm\
\xc8\xfe\x8e\x8c{\xf1}\xfc\x1c?\x80\x07\xbf\x050\x91oY?\xfc\xe0\x83bF\xd9*\
\xc6\xd8]\x9a\xae52\xc6\x1a\x0c\xce\xab\r\xca\xac\x8c1\xc2\x18#\x941\xc2\x18\
%\x8c2.\x84\x08r\xceG\x0c\xce\xfb)\xa5\xbd\xd1H\xa4\x871\xf6\xde\xbf\xbc\xf6\
\xea\x95\xb5k\xd7n\x8e\xc7\xe3\x7fy\xed\xda\xb5\xda\xae\xae.)}\x9ce\xcb\x96\
\xe1Y\xf7\xb3\xa8\xaf\xaf\xc7\xbag\xd6\x19\xe1p\xf8\xa2\xa2(\xbf\xf6z\xbd\
\xaf\xf6\xf6\xf6\xf2|\xd8\x88\xb0\xa2\x0e/\xc1\x8a+\xf0`\xa7\x88L\xb5\x10\
\xfb\xc9\xf6\xf6\xeaH$\xb2CQ\x94\x87\xb9\xc1\xcd\x8c1\x18\x8c\xc2\xa4(\x80\
\x10`\x8c!\xae\xe9\x88E\xa3\x88\xc5b\x88\xc7c\xd0t\x1d\xba\xae\x831\x03\x86a\
\x80s\x8e\xb1\xb1Q\x8c\xf8|\xf8\xe2\x8b/\x84\xd7\xeb%\xe9\x00\x9cN\'\xdc\xeb\
\xddp\xbb\xddX\xd5\xb8\nuuuCv\xbb\xfd\xa0\xd7\xeb}\xb1\xb7\xb7\xd7?\xdb\x9e!\
\x93;>\xad\x86\x90\xab\x9b6\xfd\xc8\x16<\xfd#\xefw_,\x8c\x96\xd8A\r\x03\x04\
\x04\xa5\xa5\xa5\xb0\xd9\xca\xc09G(\xa4BUC\x93\xffU\x84\xd4\x10\xd4\x90\x8a\
\x90\x9a(\xfb\xfd~\x84\xd4\x10\x06\x07\x07\xe1\xf1x\xc0\x18\xcb\x18f\xdd\xba\
up\xbb\xdd\xd8\xb2e\x0bB\xa1P\xa8\xaa\xaa\xaa]U\xd5\xed\xa7O\x9f\xee\x9c\rt\
\xba\xc8 \xa4\x18\x80\x13\xc0\xc0/\xdf|\xb3\xec\xeb;w~\xdapf\xebRy\xe38\\\
\xbe_\xe0\x7f\xad\xad\xb0\xdb\xedp8\x1cHN\x9d\xa6\xe5?\xa44M\xc3\xc0\xe0\x00\
\xae^\xbd\x8a\xae\xae.\xa8\xaa\x9a\xd1\xbe\xe6\x1bk\xe0v\xbb1<<\x8c\xb6_\xb4\
!0\x1e\xc0\xa2\x85\x8bz%I\xfa!c\xec\xf7G\x8e\x1c\xc9k&3\x13\x006`\'6\xef\xf5\
\xbfp\xdf\x92\xc5\x8b\xcf\x159\x1cvup\x05L\xf1\x00\x82\x05\x8d(\xb5\xd9`\xb7\
\xdb\xa7\xfd\x80\x10\x02\xdd\xdd\xdd\xf0\xf4t\xa3\xa3\xa3\x03CCC\x19\xed\xb5\
\xb5\xb5p\xafw\xe3\xa9\xa7\x9e\xc2\xea\xfbWc\xf7\xee\xdd\xd0t\x1d\x0b+\x17\
\xc2Y\xee\x84\x80\xb8\x831\xf6vIIIo\xcbwZ\x9e>\xf0\xfb\x03gn\x84\x00\x11@\
\x15\xfd\x99\xec\xfc\xa0\xf6\xd0\xc1j\x97\xcb\xc5\x18\x83\x11\x0cA7+P\x0c\
\x03\xf6\x8a\n\x10\x92a\xb6\xd04\r\x9d\x9dgp\xbc\xfd8>>}\x1a===\x19\xed\xc5\
\xc5\xc5p\xbb\xddp\xafw\xe3\x91\xe6GP[[\x8b\xc2\x82B\x0c\x0c\x0c"\xddd\x15E\
\xc1b\x97\x0b\xf3\xe6\xcf\x83a\x180\x98!\x8a-\x96\xdf\x8e\x8e\x8e\xfe\xcd{G\
\xde\x1d\x9f\x1b\x01!\xf0\xef\xbf\xfa\xd5\xcb\x0f55>_r~?F\xeb\x9e\x02\xa5\
\x0c\x8cQ8\xca\xcb\xa1\xc8S\xbenhh\x08\xff}\xf80\xda\x8f\x1fGGg\'t]\xcf\xf8X\
\xcb\x93-p\xbb\xdd\xd8\xb3g\x0f<\xdd\x1e\xb8\\.\xe8\x9a\x8eH$\nuro\xe4\x93\
\xa2\xa2"\xb8\x16-\x82\xc5b\x01e\x0c\x92$\xc5\x84\xe0\xadjH\xdd\xd5~\xb2]\
\xe4\xed\x94$\xf0\xfc\xd6\xadd\xf5\xf2{G\x9b\xcc\x9d\x0e\xc7\xe8\xbf\xc2\xbb\
t\x1f\xc2R\x05\x0c\xc3\xc0\xfc\x92\x12\xd0H\x04\x87N\x9d\xc2\xf1\x13\'p\xf2\
\xe4ILLd\x9e\xb4\x8d\x8d\x8dp\xafw\xa3\xac\xac\x0c\x9b\xffi3\x96-[\x06[\x99\
\r\x8a\xac$6\xb6\xaa\xa66\xfat\x04\x92R\xeep\xe0\xb6\x8a\np\xce\xc1\x18\x85"\
+^5\x1c\xfe\xf3\x8f>>uvZ\x02\xef\xac\x7f\xec;\xcdwu\xfc\x97\xf9\xae\x00P\r`\
\x02\x08^[\x83\xb3\x8e\xcdX\xd4\xba\x19\xbc\xc0\x83\xbb?\xa50\xd2:UUU\xa5Ld\
\xe5\xaa\x95hjj\xc2\x92\xdboGUe\x15\xa2\xb1X\x02lH\xbda\x02@\xc2\xac*+*a.P\
\xc0(\x033\x0c\xa1(\xca\xcb\xc7\xdb?|1\x9f\xbe\xf4\xf1\xe2\xfb\xc2\x9e\xfa\
\x1d@)\x80\xdb\x01\xdd\xb6\x10\x17\xab\x7f\x8c5\x16+\xe6?x\x01\xb5m\x14\x7f\
\xb7\x06 \x84\xe0Y\xf7\xb38u\xf2\x14\xacV+\xda\xdb\xdb\xb1k\xd7N\xbc\xfe\xfa\
\xeb\xf8\x8bu\xcf\xa0\xbe\xbe\x1e\xb2\x9c\x1dZ\xdd\xb8PJ\xd1\xd7\xdf\x87\xd1\
\xd1Q\x00\x80\x10\x82D\xa3\xd1\x17\x9a\x1a\xef{\xe7\x9ee\xf7*\xd9\xfa2\x80\
\x82\xe1\xeb\xc30\xca\xcb\x10\xediB\xf1X\x07lK\xe6AZz\'>\xf9\x8f&\x8c\xed\
\x1b\xc0\x83\x1b^\x80\xd4p\x1e\xc7\x8e\x1dC\xb1\xa5\x18\xaf\xec\xd8\x01\xd7"\
W\x86\x1f\xb8\xd5\x12\x08L@\xd3t8\x1c\x0e\x00\x00c\xec[\x00<w\xd7\xd5\xdf\
\xef\xe9\xfe"\xe5\xe0d\x00\x7f\xb8t=NkV\x1dQ\xb8R\x02\xc2\x07\x10\t\x8c\x01\
\x00\x96m\xdd\x8b\x96\x96\x16|\xad\xff\x08\x1ez\xf8a\xfc\xfds\xcf\x81\x10\
\x02M\xd3\x10\n\xddz\xd0\xd9\x12\x8dF! PVZ\x96\xac\xaa\x15B\\ZZ{\xe7C\x17/]8\
\x0f\x00\xd2\xcb\xdb\xb6\x8d\x8f\xf0\xc2\x83\x1f|\xfa9\x84\x10\xa0E\x15\x88\
\xea\x06:;:\xd0s\xee\x1cvl\xdf\x8e\x7f\\\xba\x14O\x9e=\x00\xf3\xb9s\x7ft\xd0\
\xd9b0#\xa3L\x08)\x13B|r{\xf5\x92\x85\x00\x90\x0c\xa6v\x0f^\xbf.:>\xfb\x0c\
\x00P\xa6\xe9X\xb2w\x1bj\xae\x1dE\x91a\xa0\xa2\xff\x08\xca\x9f{\x17}|\x18\
\xc1`\x10\x9c\xdf\xb0\xc3\xfcRb\xb1Z\xe0t:s\xea\t!\xc5\x84\x90\xce\xc5\xaej\
\xc5\xb4m\xdb6<\xb2f\xcd\x95\x0f\xdb\xdb\xc5X \xf0M\xce9\xe6+\n\\\xa5\xaf\
\x83\xaf(\x80_\x7f\x10\xe1\xa2J\xf4\xd1?ET/\x81O\x8db\xc4\xe7C(\x18D<\xae\
\x81R\nF)t\xaaC\xd7\xf4T0\x97\xc8k\xd0u\x1d\x9a6Y\x97\xe57\xf2\x89\xa2(p8\
\x1cX\xb0`>,\xc5\x16\x08!\xc09\xcfI\x86aX\x85\x10\x9e\x8c`\xee\x85\x97^\xda\
\'\xcb\xf2\xf7\xec\xa5\xa5\xb8g\xa9\x0b\xa5\x85\x14\x11\xcc\x03e,q\xa4\xb1\
\x84\x83\xa3l2\x9f\xaac\xa0\x8cA\xd7\xe2\x88Fc\x88D"\x08\x87#P#\x89\xe3t"\
\x10\xc4Dp\x02\xc1`\x10\xb2,\xc3$\x9b \x9bd\x98L\x12L&\x19\xe6\x023\n\x143dE\
\x06!\x12\x0c\xc3\x00c\x14\x8c\xb2\xa9\xb1\xd2R<\x1eO\x06\x87\xefe\x9c{\x84\
\x107!\xa4"\x1c\x8b}\xa3\xd3\xe3\xc5\xc2\xaa*T\xce\x9f\xbb\xb9H&\x13\n\x0b\
\x0b!\xcb2,\x16\x0b\x1c\xcc1I\x94\xa6H\xb2,\xf2\x94\xd1\x8c:\x9a\x15\xb5&\
\x85s\x8eX,\x06]\xd7\xd3\xc3\x91\xbb3.\x14?\xde\xb2%N\x08i&\x84l\x07!|\xd8\
\xef\xc7\x85\xcb\x971\x1a\x08 \xa6i\xe0\xd9\xa1\xf7\x1fQ\x08!(,,DQQ\x11$IB0\
\x18\x84\xa6i\xe9\xe0\x05\x80\x1f\xe4\xde\x07&e\xfbO~\xf2pyy\xf91\xce9\x91e\
\x19\x8a\xa2@\x96e\x14(\nL\x92\x94\xb8\xd0\xd0\xc4\xecj\x9a69\xbb4\xc7\xacf[\
\x01\xc9$\xc1n\xb7\xc3b\xb5\xa0\xc0\\\x00\x01@\xd7uD"\x11\xf8\xfd~\xf8FF\xe0\
\xf3\xf9\xe1\xf7\xa7\x8e~\x1d\xc0\x7f\x02x\xa3\xaf\xffj\xd7\xb4\xaes\xff\xde\
\xbd\x17\xf6\xed\xdbG.z\xbd\xf0\x8f\x8d\x81\x10\x02B\x08\x04\x00H\x12\x14EA\
\x91U\x86"\xcb\x90\x15%qG5\x0cPJ\x01\x00&\x93\t\xb2\xc9\x04\x93I\x86\xa2\xc8\
\x90e\x19\x8a\xac@1+P\x14\x05f\xb3\x19V\xab\x15VkI\n\xe8\xc8\xc8\x08|>\x1fFF\
|\x08N\x04Au\n]\xa7\xd0t\r\x00F\x00\xec\x06\xd0\xd6\xd7\x7fu$\x89sZ\x02uuu\
\x15%V+V\xdcs\x0fb\xf18\xc6\x03\x01\x04\x82A\xc4b1`\x92Lz2O\xaeP\x92P*\x9f\
\xb6z\xc9\xb6d\xbd,\xcb\x88F\xa3\xa0T\x87N)h*\xe9\xc9\xfc(\xa5\xf4C\xaa\xd3C\
\x00\xf6\xf7\xf5_\xcd9\xc6\xa6%P]]mK\xe6\x8b\n\x0bQ\xb1`\x01\x1c6\x1b4]G8\
\x12A,\x16\x0338\x90x\x1d\xcb!\x94J\x924}\x1b!\xa0\x94"\x1a\x8dbpp\x10\x97.^\
\xc2\xe5\xcb\x97108\x10u\x96\x97?\xaa\xeb\xfa\'\'f\t\xa7\xa7%\xe0t:m\xe9\xe5\
\xd4\xa0\x00\xcc\xb2\x0ca6C\xd34h\x9a\x86H(\x04J\x19\x04\x00\x93I\x82\x10H\\\
P\xb8\x01n\xf0D\xde0\xc0\r\x03\x06\x9f*\x8f\xfaG\xd1\xeb\xed\xc5\xb5k\xd7\
\xa1\xc5\xe3\xa9\xef\xa9\xe1\xf0G\xfd\x03}\xa7g\x02>+\x81yN\xa7k.\x1f\x00\
\x08\x00\x02\xcey\n@n\xd2\xa7\xf2zn; \x00\x02\x10)\xb1bB\xf0O\xe66\xf6T(\x91\
#6\x9b\xadv6\xd0H^\xf3I\xbeD\xd2R\xa6\xfat\xdfK\xae\xb2\xae\xd39\xcd\xfe\x8c\
\x04\x8a\x8a\x8b3\x08d\xdanb\xcct|\t\x18\x89\xbfdM6\xe6\xccr\xa6.\x00H\t/,\
\xc2\x11u\xceO+\xd3\x12(0\x9bgX\x81L S`\xf2\x01\x9d\xd2H\xb2N\xee% s\xa1@\
\x00\xcey \x12\x89\x04n\x8a\xc0\xf2\x86\x86\xca\x05\x0b\x16,\x9c\xb9k\x16\
\xccl\xf3\x98\xce\x8c\xa6\xe9\x9e,p\xc1}sB>)y\tt\x9d;\xe7\x0f\x85B\x91|m$\
\x0b\x10I\x07\x92\x0ezz\x83\xcf\x02\x9dL\x89\xd3Rp1|\xd3\x04\x84\x104\x10\
\x08\xe4<0%\xdf\x87\xb2\xf7$\xc9\xf8\x9bfO\xe7\xe8\xa5\xe9fp\x15y\'\xee\x86\
\x08\x00@wO\xcf\x9e\xd9\xbb\xcf2\xd33\x9dF\xb9\xb30y@Hw\xcc\x15<0\x03\x81\
\xddmm{\xfa\xfa\xfa\xae\xe4\x82\x9a\x03\xa0\x1b4#\xceEJW\x96\xe5\x1a\x8b\xc5\
z\xdb\xcc}\xe6@\xe0\xe2\xc5\x8bzooo\xc6*$O\x8f\xd9\xcd\xe3\xc6\xccHp\x9e\xa2\
*\x9bL\xb2\xd5bYq\xd3\x04\x00`\xe7\xae]\xaft\xf7\xf4\x9c\x9a^cV\x0f\x95\xab\
\x97\xc5\xc8\xe0\x06\x04\x99\nw\x88$AV\x949F\x01\xb3\x10\xf8\xac\xab+v\xf8\
\xf0\xe1\xbf\xba~\xfd\xfa\xd5\xfc\x80r\xf1\xe5\x98\xd1,\x9e\xd80\x8c\x8c\x06\
"\x11P]\xf7\xde\x12\x02\x00\xf0\xb3\x9d;\xaf\xfc\xee\xed\xb7\xbf\xe5\xf5z\
\xcf\xa4{\xe2\xfc\xf8\xd2\r#\xef>M\xe9\x01\x04\x86ad\xbcV\x13B`P\x16Q\xc3\
\xea\x1fn\x19\x01\x00x\xf5\xb5\xd7z~\xfa\xc6\x1bk;\xcf\x9c\xf9]\xee\r.\xff\
\xf4\xe6\xfa\xb54\xc7A\x00\x9dj\xc9\x8bJB\x97$~k\x88\xc6bo\xc6b\xb1\xd0-%\
\x00\x00\x07\x0f\x1d\n|\xef\xe9\xa7\xff\xec\xc0\x81\x03\xee\xfe\x81\x81\xff\
\x99\xd1\x8cR\xe5\xdce\xa2\x94"\x18\n"\x1e\x8f\'}\xd7\xe4\xd6\x90\xa0\x86\
\xc3\xef\x8e\x8e\xfa\x7f8WL\x00\xf2\xfcF6\x07\xa9\xab\xabS6n\xdc\xf8\xd7U\
\x95\x95\xdfw\xd8\xed5\x9a\xa6!\xaei\x08N\x04\x13\xef@\x93o@\x9a\xa6AO\xc4\
\xf7\x08\x87\xc3\x88D#\x88\xc7\xe2`F\xe2>l0\x03F\xe2\xbe\xa0\xfb\xfc\xbeW\
\xba\xbb=\xff,\x84\xb8\xa1W\xb3/E \xd5\x99\x10y\xe3\x86\r\x8f\xdfQs\xc7\xda\
\xa2\xa2\xa2\xb5V\xab\xf5N\x9f\xcf\x87\x90\xaa"\x12\x0e#\x1a\x8b%.\xfa\x8c%~\
\xb5d\x06(\xa3\x10B\x80\x80\x80RJ\'\x82\x13\xef\x8f\x8f\x8f\xff\xd4\xd3\xed9\
\xf6\xa50\xdc\x0c\x81,2\xa4\xe5\xc9\x96\x87j\x96,\xb9_\x96e\x97\x80X\xc49_\
\xc8\x98Q\xa5\xeb:\xd1u]\xd74M\x8bk\xf1\xb1h$z^U\xd5\xf3C\xc3CG/\\\xb8\xe0\
\xb9\x99q\xff\x0f\x8e\x01\x932\x88z\x0f\xcd\x00\x00\x00\x00IEND\xaeB`\x82\
\xdb\x18 \xe1'
