#include "petsc.h"
#include "petscfix.h"
/* mesh.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscmesh.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshdestroy_ MESHDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshdestroy_ meshdestroy
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshregisterdestroy_ MESHREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshregisterdestroy_ meshregisterdestroy
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetmaximumdegree_ MESHGETMAXIMUMDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetmaximumdegree_ meshgetmaximumdegree
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL   meshdestroy_(Mesh mesh, int *__ierr ){
*__ierr = MeshDestroy(
	(Mesh)PetscToPointer((mesh) ));
}
void PETSC_STDCALL   meshregisterdestroy_(int *__ierr ){
*__ierr = MeshRegisterDestroy();
}
void PETSC_STDCALL  meshgetmaximumdegree_(Mesh mesh,PetscInt *maxDegree, int *__ierr ){
*__ierr = MeshGetMaximumDegree(
	(Mesh)PetscToPointer((mesh) ),maxDegree);
}
#if defined(__cplusplus)
}
#endif
